/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.test.entities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.test.entities.Person;
import org.nuiton.topia.test.entities.Pet;
import org.nuiton.topia.test.entities.PetDAO;

public abstract class PersonDAOAbstract<E extends Person>
extends TopiaDAOImpl<E> {
    public Class<E> getEntityClass() {
        return Person.class;
    }

    public TopiaTestDAOHelper.TopiaTestEntityEnum getTopiaEntityEnum() {
        return TopiaTestDAOHelper.TopiaTestEntityEnum.Person;
    }

    public void delete(E entity) throws TopiaException {
        List list = this.getTopiaContext().getDAO(Pet.class).findAllByProperties("person", entity, new Object[0]);
        for (Pet item : list) {
            if (!entity.equals(item.getPerson())) continue;
            item.setPerson(null);
        }
        super.delete(entity);
    }

    public E findByName(String v) throws TopiaException {
        Person result = (Person)this.findByProperty("name", v);
        return (E)result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List result = this.findAllByProperty("name", v);
        return result;
    }

    public E findByFirstname(String v) throws TopiaException {
        Person result = (Person)this.findByProperty("firstname", v);
        return (E)result;
    }

    public List<E> findAllByFirstname(String v) throws TopiaException {
        List result = this.findAllByProperty("firstname", v);
        return result;
    }

    public E findContainsPet(Pet v) throws TopiaException {
        Person result = (Person)this.findContains("pet", v);
        return (E)result;
    }

    public List<E> findAllContainsPet(Pet v) throws TopiaException {
        List result = this.findAllContains("pet", v);
        return result;
    }

    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        ArrayList result = new ArrayList();
        if (type == Pet.class) {
            PetDAO dao = (PetDAO)this.getTopiaContext().getDAO(Pet.class);
            List tmp = dao.findAllByPerson((Person)entity);
            result.addAll(tmp);
        }
        return result;
    }

    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);
        List<Pet> list = this.findUsages(Pet.class, entity);
        if (!list.isEmpty()) {
            result.put(Pet.class, list);
        }
        return result;
    }
}

