/*
 * #%L
 * EchoBase :: Entities
 * 
 * $Id: AbstractImportModel.java 2641 2012-08-22 16:04:01Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.8.1.2/topia-persistence/src/main/java/org/nuiton/topia/persistence/csv/in/AbstractImportModel.java $
 * %%
 * Copyright (C) 2011 - 2012 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.topia.persistence.csv.in;

import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.csv.TopiaCsvCommons;

import java.util.List;
import java.util.Map;

/**
 * Abstract import model which add the useful methdo about importing foreign keys.
 *
 * @param <E> type of entity to import
 * @author tchemit <chemit@codelutin.com>
 * @since 2.6.12
 */
public abstract class AbstractImportModel<E> extends org.nuiton.util.csv.ext.AbstractImportModel<E> {

    public AbstractImportModel(char separator) {
        super(separator);
    }

    @Override
    public void pushCsvHeaderNames(List<String> headerNames) {
    }

    public <E extends TopiaEntity> void newForeignKeyColumn(String headerName, String propertyName, Class<E> entityType, String foreignKeyName, Map<String, E> universe) {
        newMandatoryColumn(headerName, propertyName, TopiaCsvCommons.newForeignKeyValue(entityType, foreignKeyName, universe));
    }

    public <E extends TopiaEntity> void newForeignKeyColumn(String propertyName, Class<E> entityType, String foreignKeyName, Map<String, E> universe) {
        newMandatoryColumn(propertyName, propertyName, TopiaCsvCommons.newForeignKeyValue(entityType, foreignKeyName, universe));
    }
}
