/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.TopiaPersistenceHelper;
import org.nuiton.topia.persistence.metadata.AssociationMeta;
import org.nuiton.topia.persistence.metadata.TableMeta;

public class DbMeta<T extends TopiaEntityEnum>
implements Iterable<TableMeta<T>> {
    protected final List<TableMeta<T>> tables;
    protected final Set<T> nonEditableTypes;
    protected final TopiaPersistenceHelper<T> persistenceHelper;

    public static <T extends TopiaEntityEnum> DbMeta<T> newDbMeta(TopiaPersistenceHelper<T> typeProvider, T[] universe, T ... nonEditables) {
        return new DbMeta(typeProvider, universe, nonEditables);
    }

    public void addTables(List<TableMeta<T>> entities, Iterable<T> types) {
        for (TopiaEntityEnum type : types) {
            TableMeta<TopiaEntityEnum> tableMeta = this.getTable(type);
            if (entities == null) continue;
            entities.add(tableMeta);
        }
    }

    public void addAssociations(List<AssociationMeta<T>> associations, Iterable<T> types) {
        for (TopiaEntityEnum type : types) {
            TableMeta<TopiaEntityEnum> tableMeta = this.getTable(type);
            if (associations == null) continue;
            associations.addAll(tableMeta.getAssociations());
        }
    }

    public List<String> getTableNames() {
        ArrayList result = Lists.newArrayList();
        for (TableMeta<T> tableMeta : this.getTables()) {
            result.add(tableMeta.getName());
        }
        return result;
    }

    public List<TableMeta<T>> getTables() {
        return this.tables;
    }

    public TableMeta<T> getTable(T entityType) {
        Preconditions.checkNotNull(entityType);
        TableMeta<T> result = null;
        for (TableMeta<T> tableMeta : this.getTables()) {
            if (!entityType.equals(tableMeta.getSource())) continue;
            result = tableMeta;
            break;
        }
        return result;
    }

    @Override
    public Iterator<TableMeta<T>> iterator() {
        return this.getTables().iterator();
    }

    protected DbMeta(TopiaPersistenceHelper<T> persistenceHelper, T[] entityTypes, T ... nonEditableTypes) {
        this.persistenceHelper = persistenceHelper;
        this.nonEditableTypes = Sets.newHashSet((Object[])nonEditableTypes);
        this.tables = Lists.newArrayList();
        for (T entityEnum : entityTypes) {
            TableMeta<T> tableMeta = TableMeta.newMeta(entityEnum, persistenceHelper);
            this.tables.add(tableMeta);
        }
    }

    public boolean isEditable(TableMeta<T> meta) {
        return !this.nonEditableTypes.contains(meta.getSource());
    }

    public TopiaPersistenceHelper<T> getPersistenceHelper() {
        return this.persistenceHelper;
    }
}

