/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaDatabase;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper;
import org.nuiton.topia.test.entities.Person;
import org.nuiton.topia.test.entities.PersonDAO;

public class TopiaDAOTest {
    @Rule
    public final TopiaDatabase db = new TopiaDatabase();
    protected TopiaContext context;
    protected PersonDAO dao;

    @Before
    public void setup() throws TopiaException {
        this.context = this.db.beginTransaction();
        this.dao = TopiaTestDAOHelper.getPersonDAO(this.context);
    }

    @Test
    public void testCreateAndFindInTransaction() throws Exception {
        this.createPerson("toto");
        List allPerson = this.dao.findAll();
        Assert.assertEquals((long)1L, (long)allPerson.size());
        this.context.commitTransaction();
        Person person2 = this.createPerson("titi");
        allPerson = this.dao.findAll();
        Assert.assertEquals((long)2L, (long)allPerson.size());
        Assert.assertThat((Object)allPerson, (Matcher)CoreMatchers.hasItem((Object)person2));
        this.context.rollbackTransaction();
        Person person3 = this.createPerson("tata");
        allPerson = this.dao.findAll();
        Assert.assertEquals((long)2L, (long)allPerson.size());
        Assert.assertThat((Object)allPerson, (Matcher)CoreMatchers.hasItem((Object)person3));
        this.context.commitTransaction();
    }

    @Test
    public void findAllLazyByQuery() throws TopiaException {
        Assert.assertEquals((long)this.dao.count(), (long)0L);
        this.createPersons(101);
        Iterable allByLazy = this.dao.findAllLazyByQuery(100, "FROM " + this.dao.getTopiaEntityEnum().getImplementationFQN() + " ORDER BY id", new Object[0]);
        ArrayList actual = Lists.newArrayList();
        for (Person person : allByLazy) {
            actual.add(person);
        }
        Assert.assertEquals((long)this.dao.count(), (long)actual.size());
        allByLazy = this.dao.findAllLazyByQuery(54, "FROM " + this.dao.getTopiaEntityEnum().getImplementationFQN() + " ORDER BY id", new Object[0]);
        actual = Lists.newArrayList();
        for (Person person : allByLazy) {
            actual.add(person);
        }
        Assert.assertEquals((long)this.dao.count(), (long)actual.size());
        allByLazy = this.dao.findAllLazyByQuery(49, "FROM " + this.dao.getTopiaEntityEnum().getImplementationFQN() + " ORDER BY id", new Object[0]);
        actual = Lists.newArrayList();
        for (Person person : allByLazy) {
            actual.add(person);
        }
        Assert.assertEquals((long)this.dao.count(), (long)actual.size());
        allByLazy = this.dao.findAllLazyByQuery(101, "FROM " + this.dao.getTopiaEntityEnum().getImplementationFQN() + " ORDER BY id", new Object[0]);
        actual = Lists.newArrayList();
        for (Person person : allByLazy) {
            actual.add(person);
        }
        Assert.assertEquals((long)this.dao.count(), (long)actual.size());
        allByLazy = this.dao.findAllLazyByQuery(102, "FROM " + this.dao.getTopiaEntityEnum().getImplementationFQN() + " ORDER BY id", new Object[0]);
        actual = Lists.newArrayList();
        for (Person person : allByLazy) {
            actual.add(person);
        }
        Assert.assertEquals((long)this.dao.count(), (long)actual.size());
    }

    @Test
    public void iterateOnTopiaDAO() throws TopiaException {
        Person person;
        this.createPersons(1999);
        List excepted = this.dao.findAll();
        ArrayList actual = Lists.newArrayList();
        Iterator i$ = this.dao.iterator();
        while (i$.hasNext()) {
            person = (Person)i$.next();
            Assert.assertThat((Object)excepted, (Matcher)CoreMatchers.hasItem((Object)person));
            actual.add(person);
        }
        Assert.assertEquals((long)excepted.size(), (long)actual.size());
        this.dao.setBatchSize(54);
        actual = Lists.newArrayList();
        i$ = this.dao.iterator();
        while (i$.hasNext()) {
            person = (Person)i$.next();
            Assert.assertThat((Object)excepted, (Matcher)CoreMatchers.hasItem((Object)person));
            actual.add(person);
        }
        Assert.assertEquals((long)excepted.size(), (long)actual.size());
    }

    protected void createPersons(int number) throws TopiaException {
        for (int i = 0; i < number; ++i) {
            this.createPerson("toto" + i);
        }
        this.context.commitTransaction();
    }

    protected Person createPerson(String name) throws TopiaException {
        return (Person)this.dao.create(new Object[]{"name", name});
    }
}

