/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.framework;

import java.io.File;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nuiton.topia.TestHelper;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaContextFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper;
import org.nuiton.topia.test.entities.Person;
import org.nuiton.topia.test.entities.PersonDAO;

public class TopiaConnectionProviderTest {
    private static final Log log = LogFactory.getLog(TopiaConnectionProviderTest.class);
    protected static File testBasedir;
    public static final String TEST_URL = "testURL";
    protected TopiaContext root;

    @BeforeClass
    public static void setUpClass() throws Exception {
        testBasedir = TestHelper.getTestBasedir(TopiaConnectionProviderTest.class);
    }

    @After
    public void tearDown() throws TopiaException {
        if (this.root != null && !this.root.isClosed()) {
            this.root.closeContext();
        }
    }

    @Test
    public void testWithHardcoded() throws Exception {
        Properties dbProperties = TestHelper.loadHibernateConfiguration("/TopiaConnectionProviderHardcoded.properties");
        File directory = new File(TestHelper.getDbName(testBasedir, "testWithHardcoded"));
        String dbPath = new File(directory, "real" + File.separator + "db").getAbsolutePath();
        Assert.assertFalse((boolean)new File(dbPath).getParentFile().exists());
        String dbPathFake = new File(directory, "fake" + File.separator + "db").getAbsolutePath();
        Assert.assertFalse((boolean)new File(dbPathFake).getParentFile().exists());
        dbProperties.setProperty(TEST_URL, "jdbc:h2:file:" + dbPath);
        dbProperties.setProperty("hibernate.connection.url", "jdbc:h2:file:" + dbPathFake);
        this.root = TopiaContextFactory.getContext((Properties)dbProperties);
        Locale.setDefault(Locale.FRANCE);
        this.doStuffOnDb();
        Assert.assertTrue((boolean)new File(dbPath).getParentFile().exists());
        Assert.assertFalse((boolean)new File(dbPathFake).getParentFile().exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStuffOnDb() throws TopiaException {
        TopiaContext transaction = this.root.beginTransaction();
        try {
            PersonDAO dao = TopiaTestDAOHelper.getPersonDAO(transaction);
            Person personne = (Person)dao.create(new Object[]{"name", "Jack Bauer"});
            transaction.commitTransaction();
            String idPersonne = personne.getTopiaId();
            Assert.assertNotNull((Object)idPersonne);
            transaction.commitTransaction();
        }
        finally {
            transaction.closeContext();
        }
    }
}

