/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topiatest;

import java.io.File;
import java.io.IOException;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nuiton.topia.TestHelper;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.TopiaTestDAOHelper;
import org.nuiton.topiatest.Gender;
import org.nuiton.topiatest.PersonneDAO;
import org.nuiton.topiatest.PersonneImpl;

public class EnumTest {
    private static final Log log = LogFactory.getLog(EnumTest.class);
    protected static File testBasedir;

    @BeforeClass
    public static void setUpClass() throws Exception {
        testBasedir = TestHelper.getTestBasedir(EnumTest.class);
    }

    protected TopiaContext initTopiaContext(String testName) throws IOException, TopiaNotFoundException {
        TopiaContext root = TestHelper.initTopiaContext(testBasedir, "/TopiaContextImpl.properties", testName);
        return root;
    }

    @Test
    public void storeEntityWithEnumValue() throws Exception {
        TopiaContext root = this.initTopiaContext("storeEntityWithEnumValue");
        TopiaContext transaction = root.beginTransaction();
        PersonneDAO dao = TopiaTestDAOHelper.getPersonneDAO(transaction);
        PersonneImpl personne = new PersonneImpl();
        personne.setGender(Gender.FEMALE);
        personne.setOtherGender(Gender.MALE);
        dao.create(personne);
        String topiaId = personne.getTopiaId();
        transaction.commitTransaction();
        transaction.closeContext();
        transaction = root.beginTransaction();
        dao = TopiaTestDAOHelper.getPersonneDAO(transaction);
        dao.findByTopiaId(topiaId);
        Assert.assertEquals((Object)((Object)Gender.FEMALE), (Object)((Object)personne.getGender()));
        Assert.assertEquals((Object)((Object)Gender.MALE), (Object)((Object)personne.getOtherGender()));
        Assert.assertNotNull(dao.findByGender(Gender.FEMALE));
        Assert.assertNotNull(dao.findByOtherGender(Gender.MALE));
        transaction.closeContext();
    }
}

