package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public  abstract class DepartmentDAOAbstract<E extends Department> extends TopiaDAOImpl<E> implements TopiaDAO<E> {


     /**
      * getEntityClass :
      * @return Class<E> 
      */
    public Class<E> getEntityClass() {
        return (Class<E>)Department.class;
    }

     /**
      * delete :
      * @param entity 
      * @throws TopiaException
      */
    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

     /**
      * findByName :
      * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
      * @param v 
      * @return E 
      * @throws TopiaException
      */
    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Department.PROPERTY_NAME, v);
        return result;
    }

     /**
      * findAllByName :
      * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
      * @param v 
      * @return List<E> 
      * @throws TopiaException
      */
    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Department.PROPERTY_NAME, v);
        return result;
    }

     /**
      * findByLeader :
      * Retourne le premier élément trouvé ayant comme valeur pour l'attribut leader le paramètre.
      * @param v 
      * @return E 
      * @throws TopiaException
      */
    public E findByLeader(Employe v) throws TopiaException {
        E result = findByProperty(Department.PROPERTY_LEADER, v);
        return result;
    }

     /**
      * findAllByLeader :
      * Retourne les éléments ayant comme valeur pour l'attribut leader le paramètre.
      * @param v 
      * @return List<E> 
      * @throws TopiaException
      */
    public List<E> findAllByLeader(Employe v) throws TopiaException {
        List<E> result = findAllByProperty(Department.PROPERTY_LEADER, v);
        return result;
    }

     /**
      * findByCompany :
      * Retourne le premier élément trouvé ayant comme valeur pour l'attribut company le paramètre.
      * @param v 
      * @return E 
      * @throws TopiaException
      */
    public E findByCompany(Company v) throws TopiaException {
        E result = findByProperty(Department.PROPERTY_COMPANY, v);
        return result;
    }

     /**
      * findAllByCompany :
      * Retourne les éléments ayant comme valeur pour l'attribut company le paramètre.
      * @param v 
      * @return List<E> 
      * @throws TopiaException
      */
    public List<E> findAllByCompany(Company v) throws TopiaException {
        List<E> result = findAllByProperty(Department.PROPERTY_COMPANY, v);
        return result;
    }

     /**
      * findContainsProduct :
      * Retourne le premier élément ayant comme valeur pour l'attribut product le paramètre.
      * @param v 
      * @return E 
      * @throws TopiaException
      */
    public E findContainsProduct(Product v) throws TopiaException {
        E result = findContains(Department.PROPERTY_PRODUCT, v);
        return result;
    }

     /**
      * findAllContainsProduct :
      * Retourne les éléments ayant comme valeur pour l'attribut product le paramètre.
      * @param v 
      * @return List<E> 
      * @throws TopiaException
      */
    public List<E> findAllContainsProduct(Product v) throws TopiaException {
        List<E> result = findAllContains(Department.PROPERTY_PRODUCT, v);
        return result;
    }

     /**
      * findUsages :
      * @param type 
      * @param entity 
      * @return <U extends TopiaEntity> List<U> 
      * @throws TopiaException
      */

    @Override    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Company.class) {
            CompanyDAO dao = (CompanyDAO)
                getContext().getDAO(Company.class);
            tmp = dao.findAllContainsDepartment(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

     /**
      * findAllUsages :
      * @param entity 
      * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
      * @throws TopiaException
      */

    @Override    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Company.class, entity);
        if (!list.isEmpty()) {
            result.put(Company.class, list);
        }

        return result;
    }


} //DepartmentDAOAbstract<E extends Department>
