package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public  abstract class DepartmentAbstract extends TopiaEntityAbstract implements Department {

    /**
     * Nom de l'attribut en BD : name

     */
    protected String name;
    /**
     * Nom de l'attribut en BD : leader

     */
    protected Employe leader;
    /**
     * Nom de l'attribut en BD : company

     */
    protected Company company;
    /**
     * Nom de l'attribut en BD : product

     */
    protected Collection<Product> product;
    private static final long serialVersionUID = 4120851041491432033L;

static {
    
        I18n.n_("topia.test.common.department");
        I18n.n_("topia.test.common.name");
        I18n.n_("topia.test.common.leader");
        I18n.n_("topia.test.common.company");
        I18n.n_("topia.test.common.product");
    }
     /**
      * accept :
      * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
      * @param visitor le visiteur de l'entite.
      * @throws TopiaException
      */
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_LEADER, Employe.class, leader);
        visitor.visit(this, PROPERTY_COMPANY, Company.class, company);
        visitor.visit(this, PROPERTY_PRODUCT, Collection.class, Product.class, product);
        visitor.end(this);
}

     /**
      * setName :
      * @param name 
      */

    @Override    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(PROPERTY_NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(PROPERTY_NAME, oldValue, name);
}

     /**
      * getName :
      * @return String 
      */

    @Override    public String getName() {
        fireOnPreRead(PROPERTY_NAME, name);
        String result = this.name;
        fireOnPostRead(PROPERTY_NAME, name);
        return result;
}

     /**
      * setLeader :
      * @param leader 
      */

    @Override    public void setLeader(Employe leader) {
        Employe oldValue = this.leader;
        fireOnPreWrite(PROPERTY_LEADER, oldValue, leader);
        this.leader = leader;
        fireOnPostWrite(PROPERTY_LEADER, oldValue, leader);
}

     /**
      * getLeader :
      * @return Employe 
      */

    @Override    public Employe getLeader() {
        fireOnPreRead(PROPERTY_LEADER, leader);
        Employe result = this.leader;
        fireOnPostRead(PROPERTY_LEADER, leader);
        return result;
}

     /**
      * setCompany :
      * @param company 
      */

    @Override    public void setCompany(Company company) {
        Company oldValue = this.company;
        fireOnPreWrite(PROPERTY_COMPANY, oldValue, company);
        this.company = company;
        fireOnPostWrite(PROPERTY_COMPANY, oldValue, company);
}

     /**
      * getCompany :
      * @return Company 
      */

    @Override    public Company getCompany() {
        fireOnPreRead(PROPERTY_COMPANY, company);
        Company result = this.company;
        fireOnPostRead(PROPERTY_COMPANY, company);
        return result;
}

     /**
      * addProduct :
      * @param product 
      */

    @Override    public void addProduct(Product product) {
        fireOnPreWrite(PROPERTY_PRODUCT, null, product);
        if (this.product == null) {
            this.product = new ArrayList<Product>();
        }

        this.product.add(product);
        fireOnPostWrite(PROPERTY_PRODUCT, this.product.size(), null, product);
}

     /**
      * addAllProduct :
      * @param product 
      */

    @Override    public void addAllProduct(Collection<Product> product) {
        if (product == null) {
            return;
        }
        for (Product item : product) {
            addProduct(item);
        }
}

     /**
      * setProduct :
      * @param product 
      */

    @Override    public void setProduct(Collection<Product> product) {
        // Copy elements to keep data for fire with new reference
        Collection<Product> oldValue = this.product != null ? new ArrayList<Product>(this.product) : null;
        fireOnPreWrite(PROPERTY_PRODUCT, oldValue, product);
        this.product = product;
        fireOnPostWrite(PROPERTY_PRODUCT, oldValue, product);
}

     /**
      * removeProduct :
      * @param product 
      */

    @Override    public void removeProduct(Product product) {
        fireOnPreWrite(PROPERTY_PRODUCT, product, null);
        if ((this.product == null) || (!this.product.remove(product))) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_PRODUCT, this.product.size() + 1, product, null);
}

     /**
      * clearProduct :
      */

    @Override    public void clearProduct() {
        if (this.product == null) {
            return;
        }
        Collection<Product> oldValue = new ArrayList<Product>(this.product);
        fireOnPreWrite(PROPERTY_PRODUCT, oldValue, this.product);
        this.product.clear();
        fireOnPostWrite(PROPERTY_PRODUCT, oldValue, this.product);
}

     /**
      * getProduct :
      * @return Collection<Product> 
      */

    @Override    public Collection<Product> getProduct() {
        return product;
}

     /**
      * getProductByTopiaId :
      * @param topiaId 
      * @return Product 
      */

    @Override    public Product getProductByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(product, topiaId);
 }

     /**
      * sizeProduct :
      * @return int 
      */

    @Override    public int sizeProduct() {
        if (product == null) {
            return 0;
        }
        return product.size();
}

     /**
      * isProductEmpty :
      * @return boolean 
      */

    @Override    public boolean isProductEmpty() {
        int size = sizeProduct();
        return size == 0;
}

     /**
      * getAggregate :
      * @return List<TopiaEntity> 
      * @throws TopiaException
      */

    @Override    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

     /**
      * getComposite :
      * @return List<TopiaEntity> 
      * @throws TopiaException
      */

    @Override    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
    }

     /**
      * toString :
      * @return String 
      */

    @Override    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_NAME, this.name).
            append(PROPERTY_LEADER, this.leader).
            append(PROPERTY_PRODUCT, this.product).
         toString();
        return result;
}


} //DepartmentAbstract
