/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.framework.TopiaQuery;
import org.nuiton.util.PagerUtil;

public class TopiaFilterPagerUtil
extends PagerUtil {
    protected TopiaFilterPagerUtil() {
    }

    public static TopiaQuery addPagerToQuery(TopiaQuery query, FilterPagerBean pager) {
        PagerUtil.computeRecordIndexesAndPagesNumber((PagerUtil.PagerBean)pager);
        query.setLimit(pager.getRecordStartIndex(), pager.getRecordEndIndex() - 1);
        if (StringUtils.isNotEmpty((CharSequence)pager.getSortColumn())) {
            if (pager.isSortAscendant()) {
                query.addOrder(pager.getSortColumn());
            } else {
                query.addOrderDesc(pager.getSortColumn());
            }
        }
        return query;
    }

    public static <E> List<E> getPageFromList(List<E> elements, FilterPagerBean pager) {
        PagerUtil.computeRecordIndexesAndPagesNumber((PagerUtil.PagerBean)pager);
        List subList = TopiaFilterPagerUtil.getPage(elements, (int)pager.getPageIndex(), (int)pager.getPageSize());
        ArrayList result = new ArrayList(subList);
        return result;
    }

    public static FilterPagerBean newFilterPagerBean() {
        return new FilterPagerBean();
    }

    public static FilterPagerBeanBuilder newFilterPagerBeanBuilder(String operationGroup) {
        FilterOperationGroup operationGroup1 = FilterOperationGroup.valueOf(operationGroup);
        FilterPagerBeanBuilder builder = new FilterPagerBeanBuilder(operationGroup1);
        return builder;
    }

    public static class FilterPagerBeanBuilder {
        protected final FilterOperationGroup groupOp;
        protected final List<FilterRule> rules;

        public FilterPagerBeanBuilder(FilterOperationGroup groupOp) {
            this.groupOp = groupOp;
            this.rules = new LinkedList<FilterRule>();
        }

        public FilterPagerBeanBuilder addOperations(Collection<Map<String, String>> operations) {
            for (Map<String, String> operation : operations) {
                this.addRule(operation);
            }
            return this;
        }

        public FilterPagerBeanBuilder addRule(Map<String, String> ruleMap) {
            String op = ruleMap.get("op");
            String property = ruleMap.get("field");
            String value = ruleMap.get("data");
            FilterOperation operator = FilterOperation.valueOf(op);
            return this.addRule(new FilterRule(operator, property, value));
        }

        public FilterPagerBeanBuilder addRule(FilterRule rule) {
            this.rules.add(rule);
            return this;
        }

        public void flush(FilterPagerBean bean) {
            bean.setGroupOp(this.groupOp);
            bean.setRules(this.rules);
        }
    }

    public static enum FilterOperation {
        eq{

            @Override
            public String toHql(String paramName, String propertyName, Object data, Map<String, Object> filterParams) {
                String ruleFilter = propertyName + " = :" + paramName;
                filterParams.put(paramName, data);
                return ruleFilter;
            }
        }
        ,
        ne{

            @Override
            public String toHql(String paramName, String propertyName, Object data, Map<String, Object> filterParams) {
                String ruleFilter = propertyName + " != :" + paramName;
                filterParams.put(paramName, data);
                return ruleFilter;
            }
        }
        ,
        cn{

            @Override
            public String toHql(String paramName, String propertyName, Object data, Map<String, Object> filterParams) {
                String ruleFilter = propertyName + " like :" + paramName;
                filterParams.put(paramName, "%" + data + "%");
                return ruleFilter;
            }
        }
        ,
        nc{

            @Override
            public String toHql(String paramName, String propertyName, Object data, Map<String, Object> filterParams) {
                String ruleFilter = propertyName + " not like :" + paramName;
                filterParams.put(paramName, "%" + data + "%");
                return ruleFilter;
            }
        }
        ,
        bw{

            @Override
            public String toHql(String paramName, String propertyName, Object data, Map<String, Object> filterParams) {
                String ruleFilter = propertyName + " like :" + paramName;
                filterParams.put(paramName, data + "%");
                return ruleFilter;
            }
        }
        ,
        bn{

            @Override
            public String toHql(String paramName, String propertyName, Object data, Map<String, Object> filterParams) {
                String ruleFilter = propertyName + " not like :" + paramName;
                filterParams.put(paramName, data + "%");
                return ruleFilter;
            }
        }
        ,
        ew{

            @Override
            public String toHql(String paramName, String propertyName, Object data, Map<String, Object> filterParams) {
                String ruleFilter = propertyName + " like :" + paramName;
                filterParams.put(paramName, "%" + data);
                return ruleFilter;
            }
        }
        ,
        en{

            @Override
            public String toHql(String paramName, String propertyName, Object data, Map<String, Object> filterParams) {
                String ruleFilter = propertyName + " not like :" + paramName;
                filterParams.put(paramName, "%" + data);
                return ruleFilter;
            }
        }
        ,
        lt{

            @Override
            public String toHql(String paramName, String propertyName, Object data, Map<String, Object> filterParams) {
                String ruleFilter = propertyName + " < :" + paramName;
                filterParams.put(paramName, data);
                return ruleFilter;
            }
        }
        ,
        le{

            @Override
            public String toHql(String paramName, String propertyName, Object data, Map<String, Object> filterParams) {
                String ruleFilter = propertyName + " <= :" + paramName;
                filterParams.put(paramName, data);
                return ruleFilter;
            }
        }
        ,
        gt{

            @Override
            public String toHql(String paramName, String propertyName, Object data, Map<String, Object> filterParams) {
                String ruleFilter = propertyName + " > :" + paramName;
                filterParams.put(paramName, data);
                return ruleFilter;
            }
        }
        ,
        ge{

            @Override
            public String toHql(String paramName, String propertyName, Object data, Map<String, Object> filterParams) {
                String ruleFilter = propertyName + " >= :" + paramName;
                filterParams.put(paramName, data);
                return ruleFilter;
            }
        }
        ,
        nu{

            @Override
            public String toHql(String paramName, String propertyName, Object data, Map<String, Object> filterParams) {
                String ruleFilter = propertyName + " is null";
                return ruleFilter;
            }
        }
        ,
        nn{

            @Override
            public String toHql(String paramName, String propertyName, Object data, Map<String, Object> filterParams) {
                String ruleFilter = propertyName + " is not null";
                return ruleFilter;
            }
        }
        ,
        in{

            @Override
            public String toHql(String paramName, String propertyName, Object data, Map<String, Object> filterParams) {
                throw new UnsupportedOperationException();
            }
        }
        ,
        ni{

            @Override
            public String toHql(String paramName, String propertyName, Object data, Map<String, Object> filterParams) {
                throw new UnsupportedOperationException();
            }
        };


        public abstract String toHql(String var1, String var2, Object var3, Map<String, Object> var4);
    }

    public static enum FilterOperationGroup {
        OR,
        AND;

    }

    public static class FilterRule
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final FilterOperation op;
        protected final String field;
        protected final String data;

        public FilterRule(FilterOperation op, String field, String data) {
            this.op = op;
            this.field = field;
            this.data = data;
        }

        public FilterOperation getOp() {
            return this.op;
        }

        public String getField() {
            return this.field;
        }

        public String getData() {
            return this.data;
        }
    }

    public static class FilterPagerBean
    extends PagerUtil.PagerBean {
        private static final long serialVersionUID = 1L;
        protected boolean sortAscendant;
        protected String sortColumn;
        protected FilterOperationGroup groupOp;
        private List<FilterRule> rules;

        public boolean canFilter() {
            return this.groupOp != null && CollectionUtils.isNotEmpty(this.rules);
        }

        public FilterOperationGroup getGroupOp() {
            return this.groupOp;
        }

        public void setGroupOp(FilterOperationGroup groupOp) {
            this.groupOp = groupOp;
        }

        public List<FilterRule> getRules() {
            return this.rules;
        }

        public void setRules(List<FilterRule> rules) {
            this.rules = rules;
        }

        public boolean isSortAscendant() {
            return this.sortAscendant;
        }

        public void setSortAscendant(boolean sortAscendant) {
            this.sortAscendant = sortAscendant;
        }

        public String getSortColumn() {
            return this.sortColumn;
        }

        public void setSortColumn(String sortColumn) {
            this.sortColumn = sortColumn;
        }
    }
}

