/*
 * #%L
 * ToPIA :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2004 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.topiatest.deletetest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper.TopiaTestEntityEnum;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class Party2DAOAbstract<E extends Party2> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Party2.class;
    }

    @Override
    public TopiaTestEntityEnum getTopiaEntityEnum() {
        return TopiaTestEntityEnum.Party2;
    }

    @Override
    public void delete(E entity) throws TopiaException {
        {
            List<Contact2> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from contact2 main, contacts_party2 secondary " +
                    "where main.topiaid=secondary.contacts" +
                    " and secondary.party2='" + entity.getTopiaId() + "'")
                    .addEntity("main", org.nuiton.topia.TopiaTestDAOHelper.getImplementationClass(Contact2.class)).list();

            for (Contact2 item : list) {
                item.removeParty2(entity);
            }
        }

        super.delete(entity);
    }

    public E findContainsContacts(Contact2 v) throws TopiaException {
        E result = findContains(Party2.PROPERTY_CONTACTS, v);
        return result;
    }

    public List<E> findAllContainsContacts(Contact2 v) throws TopiaException {
        List<E> result = findAllContains(Party2.PROPERTY_CONTACTS, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Contact2.class) {
            Contact2DAO dao = (Contact2DAO)
                getContext().getDAO(Contact2.class);
            tmp = dao.findAllContainsParty2(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Contact2.class, entity);
        if (!list.isEmpty()) {
            result.put(Contact2.class, list);
        }

        return result;
    }

} //Party2DAOAbstract<E extends Party2>
