/*
 * #%L
 * ToPIA :: Persistence
 * 
 * $Id: TopiaEntityIdsMap.java 2245 2011-04-14 12:47:09Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.6.11/topia-persistence/src/main/java/org/nuiton/topia/persistence/util/TopiaEntityIdsMap.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.topia.persistence.util;

import org.nuiton.topia.persistence.TopiaEntity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * A map of ids of entities grouped by their type.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.4.3
 */
public class TopiaEntityIdsMap extends HashMap<Class<? extends TopiaEntity>, List<String>> {
    private static final long serialVersionUID = 1L;

    public void addIds(Class<? extends TopiaEntity> type, Iterable<String> ids) {
        List<String> list = get(type);
        if (list == null) {
            list = new ArrayList<String>();
            put(type, list);
        }
        for (String id : ids) {
            if (!list.contains(id)) {
                list.add(id);
            }
        }
    }
}
