package org.nuiton.topia.test.entities;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import org.apache.commons.lang.builder.ToStringBuilder;


public  class PersonDTO implements Serializable {

    public String name;
    public String firstname;
    public PetDTO[] pet;
    protected final PropertyChangeSupport p = new PropertyChangeSupport(this);
    /**
     * addPropertyChangeListener :
     * @param listener 
     */

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        p.addPropertyChangeListener(listener);
    }

    /**
     * addPropertyChangeListener :
     * @param propertyName 
     * @param listener 
     */

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.addPropertyChangeListener(propertyName, listener);
    }

    /**
     * removePropertyChangeListener :
     * @param listener 
     */

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        p.removePropertyChangeListener(listener);
    }

    /**
     * removePropertyChangeListener :
     * @param propertyName 
     * @param listener 
     */

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.removePropertyChangeListener(propertyName, listener);
    }

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        java.lang.String oldValue = this.name;
        this.name = value;
        p.firePropertyChange("name", oldValue, value);
    }

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        return name;
    }

    /**
     * setFirstname :
     * @param value 
     */

    public void setFirstname(String value) {
        java.lang.String oldValue = this.firstname;
        this.firstname = value;
        p.firePropertyChange("firstname", oldValue, value);
    }

    /**
     * getFirstname :
     * @return String 
     */

    public String getFirstname() {
        return firstname;
    }

    /**
     * setPet :
     * @param values 
     */

    public void setPet(PetDTO[] values) {
        org.nuiton.topia.test.entities.PetDTO[] oldValues = this.pet;
        this.pet = values;
        p.firePropertyChange("pet", oldValues, values);
    }

    /**
     * getPet :
     * @return PetDTO[] 
     */

    public PetDTO[] getPet() {
        return pet;
    }

    /**
     * toString :
     * @return String 
     */

    public String toString() {
        String result = new ToStringBuilder(this).
            append("name", this.name).
            append("firstname", this.firstname).
         toString();
        return result;
}


} //PersonDTO
