/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelDependency;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.topia.generator.TopiaGeneratorUtil;

public class DAOImplTransformer
extends ObjectModelTransformerToJava {
    static Log log = LogFactory.getLog(DAOImplTransformer.class);
    List<String> noGenerationNeeded = new ArrayList<String>();

    public void transformFromInterface(ObjectModelInterface interfacez) {
        if (!TopiaGeneratorUtil.hasDaoStereotype((ObjectModelClassifier)interfacez)) {
            return;
        }
        ObjectModelDependency dependency = interfacez.getDependency("dao");
        if (dependency == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Could not find dependency dao but DAO stereotype was placed on the interface " + interfacez.getName()));
            }
            return;
        }
        ObjectModelClassifier classifier = dependency.getSupplier();
        if (TopiaGeneratorUtil.hasEntityStereotype(classifier)) {
            this.noGenerationNeeded.add(classifier.getQualifiedName());
        }
    }

    public void transformFromClass(ObjectModelClass clazz) {
        if (!TopiaGeneratorUtil.hasEntityStereotype((ObjectModelClassifier)clazz) || this.hasDAOOperations(clazz)) {
            return;
        }
        String clazzName = clazz.getName();
        String clazzFQN = clazz.getQualifiedName();
        ObjectModelClass result = this.createClass(clazzName + "DAOImpl<E extends " + clazzName + ">", clazz.getPackageName());
        this.setDocumentation((ObjectModelElement)result, "/**\n Implantation du DAO pour l'entit\u00e9 " + clazzName + ".\n" + " * L'utilisateur peut remplacer cette classe par la sienne en la mettant \n" + " * simplement dans ces sources. Cette classe g\u00e9n\u00e9r\u00e9e sera alors simplement\n" + " * \u00e9cras\u00e9e\n" + " */");
        this.setSuperClass(result, clazzFQN + "DAOAbstract<E>");
    }

    public boolean hasDAOOperations(ObjectModelClass clazz) {
        for (ObjectModelOperation op : clazz.getOperations()) {
            if (!TopiaGeneratorUtil.hasDaoStereotype(op)) continue;
            return true;
        }
        return this.noGenerationNeeded.contains(clazz.getQualifiedName());
    }
}

