/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelEnumeration;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelType;
import org.nuiton.eugene.models.object.xml.ObjectModelAttributeImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelEnumerationImpl;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.generator.TopiaGeneratorUtil;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.util.EntityOperator;
import org.nuiton.topia.persistence.util.EntityOperatorStore;

public class DAOHelperTransformer
extends ObjectModelTransformerToJava {
    private static final Log log = LogFactory.getLog(DAOHelperTransformer.class);

    public void transformFromModel(ObjectModel model) {
        ObjectModelEnumeration entityEnum;
        String packageName = this.getOutputProperties().getProperty("defaultPackage");
        String modelName = model.getName();
        String daoHelperClazzName = modelName + "DAOHelper";
        String entityEnumName = modelName + "EntityEnum";
        List<ObjectModelClass> classes = TopiaGeneratorUtil.getEntityClasses(model, true);
        boolean generateOperator = TopiaGeneratorUtil.shouldGenerateOperatorForDAOHelper(model);
        boolean generateStandaloneEnum = TopiaGeneratorUtil.shouldGenerateStandaloneEnumForDAOHelper(model);
        ObjectModelClass daoHelper = this.createClass(daoHelperClazzName, packageName);
        if (generateStandaloneEnum) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will generate standalone " + entityEnumName + " in package " + packageName));
            }
            entityEnum = this.createEnumeration(entityEnumName, packageName);
            this.addImport((ObjectModelClassifier)entityEnum, TopiaEntity.class);
            this.addImport((ObjectModelClassifier)entityEnum, EntityOperatorStore.class);
            this.addImport((ObjectModelClassifier)entityEnum, Arrays.class);
        } else {
            entityEnum = (ObjectModelEnumerationImpl)this.addInnerClassifier(daoHelper, ObjectModelType.OBJECT_MODEL_ENUMERATION, entityEnumName, new ObjectModelModifier[0]);
            this.addImport((ObjectModelClassifier)daoHelper, TopiaEntityEnum.class);
            this.addImport((ObjectModelClassifier)daoHelper, EntityOperatorStore.class);
            this.addImport((ObjectModelClassifier)daoHelper, Arrays.class);
        }
        this.createDAOHelper(model, daoHelper, daoHelperClazzName, entityEnumName, generateOperator, classes);
        this.createEntityEnum(entityEnum, daoHelperClazzName, entityEnumName, generateOperator, generateStandaloneEnum, classes);
    }

    protected void createDAOHelper(ObjectModel model, ObjectModelClass daoHelper, String daoHelperClazzName, String entityEnumName, boolean generateOperator, List<ObjectModelClass> classes) {
        String modelName = model.getName();
        String modelVersion = model.getVersion();
        this.addImport((ObjectModelClassifier)daoHelper, TopiaContextImplementor.class);
        this.addImport((ObjectModelClassifier)daoHelper, TopiaDAO.class);
        this.addImport((ObjectModelClassifier)daoHelper, TopiaEntity.class);
        this.addImport((ObjectModelClassifier)daoHelper, TopiaContext.class);
        this.addImport((ObjectModelClassifier)daoHelper, Array.class);
        if (generateOperator) {
            this.addImport((ObjectModelClassifier)daoHelper, EntityOperator.class);
            this.addImport((ObjectModelClassifier)daoHelper, EntityOperatorStore.class);
        }
        ObjectModelOperation constructor = this.addConstructor(daoHelper, ObjectModelModifier.PROTECTED);
        this.setOperationBody(constructor, " ");
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)daoHelper, "getModelVersion", "String", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
        this.setOperationBody(op, "\n     return \"" + modelVersion + "\";\n" + " ");
        op = this.addOperation((ObjectModelClassifier)daoHelper, "getModelName", "String", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
        this.setOperationBody(op, "\n     return \"" + modelName + "\";\n" + " ");
        for (ObjectModelClass clazz : classes) {
            String clazzName = clazz.getName();
            String daoClazzName = clazzName + "DAO";
            op = this.addOperation((ObjectModelClassifier)daoHelper, "get" + daoClazzName, clazz.getPackageName() + '.' + daoClazzName, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
            this.addParameter(op, TopiaContext.class, "context");
            this.addImport((ObjectModelClassifier)daoHelper, clazz);
            this.addException(op, TopiaException.class);
            this.setOperationBody(op, "\n     TopiaContextImplementor ci = (TopiaContextImplementor) context;\n     " + daoClazzName + " result = ci.getDAO(" + clazzName + ".class, " + daoClazzName + ".class);\n" + "     return result;\n" + " ");
        }
        op = this.addOperation((ObjectModelClassifier)daoHelper, "getDAO", "<T extends TopiaEntity, D extends TopiaDAO<? super T>> D", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
        this.addParameter(op, TopiaContext.class, "context");
        this.addParameter(op, "Class<T>", "klass");
        this.addException(op, TopiaException.class);
        this.setOperationBody(op, "\n     TopiaContextImplementor ci = (TopiaContextImplementor) context;\n     " + entityEnumName + " constant = " + entityEnumName + ".valueOf(klass);\n" + "     D dao = (D) ci.getDAO(constant.getContract());\n" + "     return dao;\n" + " ");
        op = this.addOperation((ObjectModelClassifier)daoHelper, "getDAO", "<T extends TopiaEntity, D extends TopiaDAO<? super T>> D", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
        this.addParameter(op, TopiaContext.class, "context");
        this.addParameter(op, "T", "entity");
        this.addException(op, TopiaException.class);
        this.setOperationBody(op, "\n     TopiaContextImplementor ci = (TopiaContextImplementor) context;\n     " + entityEnumName + " constant = " + entityEnumName + ".valueOf(entity);\n" + "     D dao = (D) ci.getDAO(constant.getContract());\n" + "     return dao;\n" + " ");
        op = this.addOperation((ObjectModelClassifier)daoHelper, "getContractClass", "<T extends TopiaEntity> Class<T>", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
        this.addParameter(op, "Class<T>", "klass");
        this.setOperationBody(op, "\n     " + entityEnumName + " constant = " + entityEnumName + ".valueOf(klass);\n" + "     return (Class<T>) constant.getContract();\n" + " ");
        op = this.addOperation((ObjectModelClassifier)daoHelper, "getImplementationClass", "<T extends TopiaEntity> Class<T>", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
        this.addParameter(op, "Class<T>", "klass");
        this.setOperationBody(op, "\n     " + entityEnumName + " constant = " + entityEnumName + ".valueOf(klass);\n" + "     return (Class<T>) constant.getImplementation();\n" + " ");
        op = this.addOperation((ObjectModelClassifier)daoHelper, "getContractClasses", "Class<? extends TopiaEntity>[]", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
        this.setOperationBody(op, "\n     " + entityEnumName + "[] values = " + entityEnumName + ".values();\n" + "     Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);\n" + "     for (int i = 0; i < values.length; i++) {\n" + "         result[i] = values[i].getContract();\n" + "     }\n" + "     return result;\n" + " ");
        op = this.addOperation((ObjectModelClassifier)daoHelper, "getImplementationClasses", "Class<? extends TopiaEntity>[]", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
        this.setOperationBody(op, "\n     " + entityEnumName + "[] values = " + entityEnumName + ".values();\n" + "     Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);\n" + "     for (int i = 0; i < values.length; i++) {\n" + "         result[i] = values[i].getImplementation();\n" + "     }\n" + "     return result;\n" + " ");
        op = this.addOperation((ObjectModelClassifier)daoHelper, "getImplementationClassesAsString", "String", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
        this.setOperationBody(op, "\n     StringBuilder buffer = new StringBuilder();\n     for (Class<? extends TopiaEntity> aClass : getImplementationClasses()) {\n         buffer.append(',').append(aClass.getName());\n     }\n     return buffer.substring(1);\n ");
        op = this.addOperation((ObjectModelClassifier)daoHelper, "getContracts", entityEnumName + "[]", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
        this.setOperationBody(op, "\n     return " + entityEnumName + ".values();\n" + " ");
        if (generateOperator) {
            op = this.addOperation((ObjectModelClassifier)daoHelper, "getOperator", "<T extends TopiaEntity> EntityOperator<T>", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
            this.addParameter(op, "Class<T>", "klass");
            this.setOperationBody(op, "\n     " + entityEnumName + " constant = " + entityEnumName + ".valueOf(klass);\n" + "     return (EntityOperator<T>) EntityOperatorStore.getOperator(constant);\n" + " ");
        }
    }

    protected void createEntityEnum(ObjectModelEnumeration entityEnum, String daoHelperClazzName, String entityEnumName, boolean generateOperator, boolean generateStandaloneEnum, List<ObjectModelClass> classes) {
        this.addInterface((ObjectModelClassifier)entityEnum, TopiaEntityEnum.class);
        for (ObjectModelClass clazz : classes) {
            String clazzName = clazz.getName();
            Collection attributes = clazz.getAttributes();
            boolean withNatural = false;
            StringBuilder sb = new StringBuilder();
            for (ObjectModelAttribute attr2 : attributes) {
                if (!TopiaGeneratorUtil.isNaturalId(attr2)) continue;
                withNatural = true;
                sb.append(", \"").append(attr2.getName()).append("\"");
            }
            if (withNatural) {
                String naturalIds = sb.substring(2);
                this.addLiteral(entityEnum, clazzName + '(' + clazzName + ".class, " + naturalIds + ")");
            } else {
                this.addLiteral(entityEnum, clazzName + '(' + clazzName + ".class)");
            }
            if (!generateStandaloneEnum) continue;
            this.addImport((ObjectModelClassifier)entityEnum, clazz);
        }
        ObjectModelAttributeImpl attr = (ObjectModelAttributeImpl)this.addAttribute((ObjectModelClassifier)entityEnum, "contract", "Class<? extends TopiaEntity>");
        attr.setDocumentation("the contract of the entity");
        attr = (ObjectModelAttributeImpl)this.addAttribute((ObjectModelClassifier)entityEnum, "implementationFQN", "String");
        attr.setDocumentation("the fully qualified name of the implementation of the entity");
        attr = (ObjectModelAttributeImpl)this.addAttribute((ObjectModelClassifier)entityEnum, "implementation", "Class<? extends TopiaEntity>");
        attr.setDocumentation("the implementation class of the entity (will be lazy computed at runtime)");
        attr = (ObjectModelAttributeImpl)this.addAttribute((ObjectModelClassifier)entityEnum, "naturalIds", "String[]");
        attr.setDocumentation("the array of property involved in the natural key of the entity.");
        ObjectModelOperation op = this.addConstructor(entityEnum, ObjectModelModifier.PACKAGE);
        this.addParameter(op, "Class<? extends TopiaEntity >", "contract");
        this.addParameter(op, "String...", "naturalIds");
        this.setOperationBody(op, "\n    this.contract = contract;\n    this.naturalIds = naturalIds;\n    this.implementationFQN = contract.getName()+\"Impl\";\n");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "getContract", "Class<? extends TopiaEntity>", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)entityEnum, (ObjectModelElement)op, "Override");
        this.setOperationBody(op, "\n    return contract;\n");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "getNaturalIds", "String[]", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)entityEnum, (ObjectModelElement)op, "Override");
        this.setOperationBody(op, "\n    return naturalIds;\n");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "getImplementationFQN", "String", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)entityEnum, (ObjectModelElement)op, "Override");
        this.setOperationBody(op, "\n    return implementationFQN;\n");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "setImplementationFQN", "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)entityEnum, (ObjectModelElement)op, "Override");
        this.addParameter(op, "String", "implementationFQN");
        if (generateOperator) {
            this.setOperationBody(op, "\n    this.implementationFQN = implementationFQN;\n    this.implementation = null;\n    // on reinitialise le magasin d'operators\n   EntityOperatorStore.clear();\n");
        } else {
            this.setOperationBody(op, "\n    this.implementationFQN = implementationFQN;\n    this.implementation = null;\n");
        }
        op = this.addOperation((ObjectModelClassifier)entityEnum, "accept", "boolean", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)entityEnum, (ObjectModelElement)op, "Override");
        this.addParameter(op, "Class<? extends TopiaEntity>", "klass");
        this.setOperationBody(op, "\n     return " + daoHelperClazzName + ".getContractClass(klass) == contract;\n" + "");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "getImplementation", "Class<? extends TopiaEntity>", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)entityEnum, (ObjectModelElement)op, "Override");
        this.setOperationBody(op, "\n if (implementation == null) {\n    try {\n            implementation = (Class<? extends TopiaEntity>) Class.forName(implementationFQN);\n        } catch (ClassNotFoundException e) {\n            throw new RuntimeException(\"could not find class \" + implementationFQN);\n        }\n }\n return implementation;\n");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "valueOf", entityEnumName, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
        this.addParameter(op, "TopiaEntity", "entity");
        this.setOperationBody(op, "\n     return valueOf(entity.getClass());\n ");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "valueOf", entityEnumName, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
        this.addParameter(op, "Class<?>", "klass");
        this.setOperationBody(op, "\n     if (klass.isInterface()) {\n        return " + entityEnumName + ".valueOf(klass.getSimpleName());\n" + "     }\n" + "     for (" + entityEnumName + " entityEnum : " + entityEnumName + ".values()) {\n" + "         if (entityEnum.getContract().isAssignableFrom(klass)) {\n" + "             //todo check it works for inheritance\n" + "             return entityEnum;\n" + "         }\n" + "     }\n" + "     throw new IllegalArgumentException(\"no entity defined for the class \" + klass + \" in : \" + Arrays.toString(" + entityEnumName + ".values()));\n" + " ");
    }
}

