/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topiatest.Address;
import org.nuiton.topiatest.Personne;
import org.nuiton.topiatest.deletetest.Party2Impl;

public abstract class PersonneAbstract
extends Party2Impl
implements Personne {
    protected String name;
    protected Collection<String> otherNames;
    protected boolean gender;
    protected Address address;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        visitor.visit((TopiaEntity)this, "name", String.class, (Object)this.name);
        visitor.visit((TopiaEntity)this, "otherNames", Collection.class, String.class, this.otherNames);
        visitor.visit((TopiaEntity)this, "gender", Boolean.TYPE, (Object)this.gender);
        visitor.visit((TopiaEntity)this, "address", Address.class, (Object)this.address);
        visitor.end((TopiaEntity)this);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        this.fireOnPreWrite("name", oldValue, name);
        this.name = name;
        this.fireOnPostWrite("name", oldValue, name);
    }

    @Override
    public String getName() {
        this.fireOnPreRead("name", this.name);
        String result = this.name;
        this.fireOnPostRead("name", this.name);
        return result;
    }

    @Override
    public void addOtherNames(String otherNames) {
        this.fireOnPreWrite("otherNames", null, otherNames);
        if (this.otherNames == null) {
            this.otherNames = new ArrayList<String>();
        }
        this.otherNames.add(otherNames);
        this.fireOnPostWrite("otherNames", this.otherNames.size(), null, otherNames);
    }

    @Override
    public void addAllOtherNames(Collection<String> otherNames) {
        if (otherNames == null) {
            return;
        }
        for (String item : otherNames) {
            this.addOtherNames(item);
        }
    }

    @Override
    public void setOtherNames(Collection<String> otherNames) {
        ArrayList<String> oldValue = this.otherNames != null ? new ArrayList<String>(this.otherNames) : null;
        this.fireOnPreWrite("otherNames", oldValue, otherNames);
        this.otherNames = otherNames;
        this.fireOnPostWrite("otherNames", oldValue, otherNames);
    }

    @Override
    public void removeOtherNames(String otherNames) {
        this.fireOnPreWrite("otherNames", otherNames, null);
        if (this.otherNames == null || !this.otherNames.remove(otherNames)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        this.fireOnPostWrite("otherNames", this.otherNames.size() + 1, otherNames, null);
    }

    @Override
    public void clearOtherNames() {
        if (this.otherNames == null) {
            return;
        }
        ArrayList<String> oldValue = new ArrayList<String>(this.otherNames);
        this.fireOnPreWrite("otherNames", oldValue, this.otherNames);
        this.otherNames.clear();
        this.fireOnPostWrite("otherNames", oldValue, this.otherNames);
    }

    @Override
    public Collection<String> getOtherNames() {
        return this.otherNames;
    }

    @Override
    public int sizeOtherNames() {
        if (this.otherNames == null) {
            return 0;
        }
        return this.otherNames.size();
    }

    @Override
    public boolean isOtherNamesEmpty() {
        int size = this.sizeOtherNames();
        return size == 0;
    }

    @Override
    public void setGender(boolean gender) {
        boolean oldValue = this.gender;
        this.fireOnPreWrite("gender", oldValue, gender);
        this.gender = gender;
        this.fireOnPostWrite("gender", oldValue, gender);
    }

    @Override
    public boolean getGender() {
        this.fireOnPreRead("gender", this.gender);
        boolean result = this.gender;
        this.fireOnPostRead("gender", this.gender);
        return result;
    }

    @Override
    public boolean isGender() {
        this.fireOnPreRead("gender", this.gender);
        boolean result = this.gender;
        this.fireOnPostRead("gender", this.gender);
        return result;
    }

    @Override
    public void setAddress(Address address) {
        Address oldValue = this.address;
        this.fireOnPreWrite("address", oldValue, address);
        this.address = address;
        this.fireOnPostWrite("address", oldValue, address);
    }

    @Override
    public Address getAddress() {
        this.fireOnPreRead("address", this.address);
        Address result = this.address;
        this.fireOnPostRead("address", this.address);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity == null) continue;
            result.add(entity);
            result.addAll(entity.getComposite());
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder((Object)this).append("name", (Object)this.name).append("otherNames", this.otherNames).append("gender", this.gender).append("address", (Object)this.address).toString();
        return result;
    }

    static {
        I18n.n_((String)"topia.test.common.personne", (Object[])new Object[0]);
        I18n.n_((String)"topia.test.common.name", (Object[])new Object[0]);
        I18n.n_((String)"topia.test.common.otherNames", (Object[])new Object[0]);
        I18n.n_((String)"topia.test.common.gender", (Object[])new Object[0]);
        I18n.n_((String)"topia.test.common.address", (Object[])new Object[0]);
    }
}

