/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.framework;

import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.hibernate.EntityMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.ReplicationMode;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostLoadEventListener;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.event.PreDeleteEventListener;
import org.hibernate.event.PreInsertEventListener;
import org.hibernate.event.PreLoadEventListener;
import org.hibernate.event.PreUpdateEventListener;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaContextFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.event.TopiaContextListener;
import org.nuiton.topia.event.TopiaEntitiesVetoable;
import org.nuiton.topia.event.TopiaEntityListener;
import org.nuiton.topia.event.TopiaEntityVetoable;
import org.nuiton.topia.event.TopiaTransactionListener;
import org.nuiton.topia.event.TopiaTransactionVetoable;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.framework.TopiaFiresSupport;
import org.nuiton.topia.framework.TopiaQuery;
import org.nuiton.topia.framework.TopiaService;
import org.nuiton.topia.framework.TopiaUtil;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaId;
import org.nuiton.util.ArrayUtil;

public class TopiaContextImpl
implements TopiaContextImplementor {
    private static final Log log = LogFactory.getLog(TopiaContextImpl.class);
    public static final String TOPIA_PERSISTENCE_DIRECTORIES = "topia.persistence.directories";
    public static final String TOPIA_PERSISTENCE_CLASSES = "topia.persistence.classes";
    public static final String TOPIA_PERSISTENCE_PROPERTIES_FILE = "topia.persistence.properties.file";
    protected TopiaContextImplementor parentContext;
    protected Configuration hibernateConfiguration;
    protected SessionFactory hibernateFactory;
    protected Session hibernate;
    protected boolean closed;
    protected boolean useFlushMode = true;
    protected Properties config;
    protected Map<Class<? extends TopiaEntity>, TopiaDAO<? extends TopiaEntity>> daoCache = new HashMap<Class<? extends TopiaEntity>, TopiaDAO<? extends TopiaEntity>>();
    protected final Set<TopiaContextImplementor> childContext = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    protected Map<String, TopiaService> services;
    protected TopiaFiresSupport firesSupport = new TopiaFiresSupport();
    protected List<Class<?>> persistenceClasses = new ArrayList();

    protected TopiaContextImpl() {
    }

    public TopiaContextImpl(Properties config) throws TopiaNotFoundException {
        this.config = config;
        this.services = this.loadServices(config);
        this.preInitServices(this.services);
        this.getHibernateConfiguration();
        this.postInitServices(this.services);
    }

    protected String getProperExceptionMessage(Throwable eee) {
        return eee.getClass().getSimpleName() + " : " + eee.getMessage();
    }

    protected Map<String, TopiaService> loadServices(Properties config) {
        HashMap<String, TopiaService> result = new HashMap<String, TopiaService>();
        Enumeration<?> e = config.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.matches("^topia\\.service\\.\\w+$")) continue;
            String classService = config.getProperty(key);
            try {
                Class<?> forName = Class.forName(classService);
                Object newInstance = forName.newInstance();
                TopiaService service = (TopiaService)newInstance;
                if (key.equals("topia.service." + service.getServiceName())) {
                    result.put(service.getServiceName(), service);
                    log.info((Object)I18n._((String)"topia.persistence.service.loaded", (Object[])new Object[]{key, classService}));
                    continue;
                }
                log.warn((Object)I18n._((String)"topia.persistence.warn.service.not.loaded", (Object[])new Object[]{key, service.getServiceName()}));
            }
            catch (Throwable eee) {
                String message = I18n._((String)"topia.persistence.error.service.unknown", (Object[])new Object[]{key, classService});
                if (log.isDebugEnabled()) {
                    log.debug((Object)message, eee);
                    continue;
                }
                if (!log.isErrorEnabled()) continue;
                log.error((Object)message);
            }
        }
        return result;
    }

    protected void preInitServices(Map<String, TopiaService> services) {
        for (TopiaService service : services.values()) {
            if (service.preInit(this)) continue;
            log.warn((Object)I18n._((String)"topia.persistence.warn.service.not.preInit", (Object[])new Object[]{service.getServiceName()}));
        }
    }

    protected void postInitServices(Map<String, TopiaService> services) {
        for (TopiaService service : services.values()) {
            if (service.postInit(this)) continue;
            log.warn((Object)I18n._((String)"topia.persistence.warn.service.not.postInit", (Object[])new Object[]{service.getServiceName()}));
        }
    }

    protected TopiaService getService(String name) {
        TopiaService result = this.getServices().get(name);
        return result;
    }

    protected boolean serviceEnabled(String name) {
        boolean result = this.getServices().containsKey(name);
        return result;
    }

    protected <E extends TopiaService> String getServiceName(Class<E> interfaceService) throws IllegalAccessException, NoSuchFieldException {
        Field f = interfaceService.getField("SERVICE_NAME");
        String name = (String)f.get(null);
        return name;
    }

    @Override
    public Map<String, TopiaService> getServices() {
        TopiaContextImplementor parent = this.getParentContext();
        Map<String, TopiaService> result = parent != null ? parent.getServices() : this.services;
        return result;
    }

    @Override
    public <E extends TopiaService> E getService(Class<E> interfaceService) throws TopiaNotFoundException {
        TopiaService result;
        try {
            String name = this.getServiceName(interfaceService);
            result = this.getService(name);
        }
        catch (Exception eee) {
            throw new TopiaNotFoundException(I18n._((String)"topia.persistence.error.service.not.retreaved", (Object[])new Object[]{interfaceService, this.getProperExceptionMessage(eee)}), eee);
        }
        if (result == null) {
            throw new TopiaNotFoundException(I18n._((String)"topia.persistence.error.service.not.found", (Object[])new Object[]{interfaceService}));
        }
        return (E)result;
    }

    @Override
    public <E extends TopiaService> boolean serviceEnabled(Class<E> interfaceService) {
        boolean result;
        block3: {
            result = false;
            try {
                String name = this.getServiceName(interfaceService);
                result = this.serviceEnabled(name);
            }
            catch (Exception eee) {
                String message = I18n._((String)"topia.persistence.warn.service.not.found", (Object[])new Object[]{interfaceService, this.getProperExceptionMessage(eee)});
                if (log.isDebugEnabled()) {
                    log.debug((Object)message, (Throwable)eee);
                }
                if (!log.isWarnEnabled()) break block3;
                log.warn((Object)message);
            }
        }
        return result;
    }

    @Override
    public Collection<TopiaService> getAllServices() {
        Collection<TopiaService> result = this.getServices().values();
        return result;
    }

    protected TopiaContextImpl(TopiaContextImplementor parentContext) {
        this.parentContext = parentContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<TopiaContextImplementor> getChildContext() {
        HashSet<TopiaContextImplementor> values;
        Set<TopiaContextImplementor> set = this.childContext;
        synchronized (set) {
            values = new HashSet<TopiaContextImplementor>(this.childContext);
        }
        return values;
    }

    protected void addChildContext(TopiaContextImplementor child) {
        this.childContext.add(child);
    }

    @Override
    public void removeChildContext(TopiaContextImplementor child) {
        if (!this.closed) {
            this.childContext.remove(child);
        }
    }

    @Override
    public TopiaContextImplementor getParentContext() {
        return this.parentContext;
    }

    @Override
    public TopiaContextImplementor getRootContext() {
        TopiaContextImplementor result = this;
        if (this.getParentContext() != null) {
            result = this.getParentContext().getRootContext();
        }
        return result;
    }

    @Override
    public Properties getConfig() {
        if (this.config == null && this.getParentContext() != null) {
            this.config = this.getParentContext().getConfig();
        }
        return this.config;
    }

    @Override
    public void setUseFlushMode(boolean useFlushMode) {
        this.useFlushMode = useFlushMode;
    }

    @Override
    public void createSchema() throws TopiaException {
        try {
            boolean showSchema = false;
            if (log.isDebugEnabled()) {
                showSchema = true;
            }
            this.getFiresSupport().firePreCreateSchema(this);
            new SchemaExport(this.getHibernateConfiguration()).create(showSchema, true);
            this.getFiresSupport().firePostCreateSchema(this);
        }
        catch (HibernateException eee) {
            throw new TopiaException(I18n._((String)"topia.persistence.error.create.schema", (Object[])new Object[]{eee.getMessage()}), eee);
        }
    }

    @Override
    public void showCreateSchema() throws TopiaException {
        try {
            new SchemaExport(this.getHibernateConfiguration()).execute(true, false, false, true);
        }
        catch (HibernateException eee) {
            throw new TopiaException(I18n._((String)"topia.persistence.error.create.schema", (Object[])new Object[]{eee.getMessage()}), eee);
        }
    }

    @Override
    public void updateSchema() throws TopiaException {
        try {
            boolean showSchema = false;
            if (log.isDebugEnabled()) {
                showSchema = true;
            }
            this.getFiresSupport().firePreUpdateSchema(this);
            new SchemaUpdate(this.getHibernateConfiguration()).execute(showSchema, true);
            this.getFiresSupport().firePostUpdateSchema(this);
        }
        catch (HibernateException eee) {
            throw new TopiaException(I18n._((String)"topia.persistence.error.update.schema", (Object[])new Object[]{eee.getMessage()}), eee);
        }
    }

    @Override
    public Session getHibernate() throws TopiaException {
        if (this.hibernate == null) {
            throw new TopiaException(I18n._((String)"topia.persistence.error.no.hibernate.session", (Object[])new Object[0]));
        }
        return this.hibernate;
    }

    @Override
    public SessionFactory getHibernateFactory() throws TopiaNotFoundException {
        if (this.hibernateFactory == null) {
            this.hibernateFactory = this.getParentContext() != null ? this.getParentContext().getHibernateFactory() : this.getHibernateConfiguration().buildSessionFactory();
        }
        return this.hibernateFactory;
    }

    @Override
    public Configuration getHibernateConfiguration() throws TopiaNotFoundException {
        if (this.hibernateConfiguration == null) {
            if (this.getParentContext() != null) {
                this.hibernateConfiguration = this.getParentContext().getHibernateConfiguration();
            } else {
                String[] classes;
                String[] dirs;
                this.hibernateConfiguration = new Configuration();
                TopiaFiresSupport.TopiaHibernateEvent listener = new TopiaFiresSupport.TopiaHibernateEvent(this);
                Object[] preInsertEventListeners = this.hibernateConfiguration.getEventListeners().getPreInsertEventListeners();
                preInsertEventListeners = (PreInsertEventListener[])ArrayUtil.concatElems((Object[])preInsertEventListeners, (Object[])new TopiaFiresSupport.TopiaHibernateEvent[]{listener});
                Object[] preLoadEventListeners = this.hibernateConfiguration.getEventListeners().getPreLoadEventListeners();
                preLoadEventListeners = (PreLoadEventListener[])ArrayUtil.concatElems((Object[])preLoadEventListeners, (Object[])new TopiaFiresSupport.TopiaHibernateEvent[]{listener});
                Object[] preUpdateEventListeners = this.hibernateConfiguration.getEventListeners().getPreUpdateEventListeners();
                preUpdateEventListeners = (PreUpdateEventListener[])ArrayUtil.concatElems((Object[])preUpdateEventListeners, (Object[])new TopiaFiresSupport.TopiaHibernateEvent[]{listener});
                Object[] preDeleteEventListeners = this.hibernateConfiguration.getEventListeners().getPreDeleteEventListeners();
                preDeleteEventListeners = (PreDeleteEventListener[])ArrayUtil.concatElems((Object[])preDeleteEventListeners, (Object[])new TopiaFiresSupport.TopiaHibernateEvent[]{listener});
                Object[] postInsertEventListeners = this.hibernateConfiguration.getEventListeners().getPostInsertEventListeners();
                postInsertEventListeners = (PostInsertEventListener[])ArrayUtil.concatElems((Object[])postInsertEventListeners, (Object[])new TopiaFiresSupport.TopiaHibernateEvent[]{listener});
                Object[] postLoadEventListeners = this.hibernateConfiguration.getEventListeners().getPostLoadEventListeners();
                postLoadEventListeners = (PostLoadEventListener[])ArrayUtil.concatElems((Object[])postLoadEventListeners, (Object[])new TopiaFiresSupport.TopiaHibernateEvent[]{listener});
                Object[] postUpdateEventListeners = this.hibernateConfiguration.getEventListeners().getPostUpdateEventListeners();
                postUpdateEventListeners = (PostUpdateEventListener[])ArrayUtil.concatElems((Object[])postUpdateEventListeners, (Object[])new TopiaFiresSupport.TopiaHibernateEvent[]{listener});
                Object[] postDeleteEventListeners = this.hibernateConfiguration.getEventListeners().getPostDeleteEventListeners();
                postDeleteEventListeners = (PostDeleteEventListener[])ArrayUtil.concatElems((Object[])postDeleteEventListeners, (Object[])new TopiaFiresSupport.TopiaHibernateEvent[]{listener});
                this.hibernateConfiguration.getEventListeners().setPreInsertEventListeners((PreInsertEventListener[])preInsertEventListeners);
                this.hibernateConfiguration.getEventListeners().setPreLoadEventListeners((PreLoadEventListener[])preLoadEventListeners);
                this.hibernateConfiguration.getEventListeners().setPreUpdateEventListeners((PreUpdateEventListener[])preUpdateEventListeners);
                this.hibernateConfiguration.getEventListeners().setPreDeleteEventListeners((PreDeleteEventListener[])preDeleteEventListeners);
                this.hibernateConfiguration.getEventListeners().setPostInsertEventListeners((PostInsertEventListener[])postInsertEventListeners);
                this.hibernateConfiguration.getEventListeners().setPostLoadEventListeners((PostLoadEventListener[])postLoadEventListeners);
                this.hibernateConfiguration.getEventListeners().setPostUpdateEventListeners((PostUpdateEventListener[])postUpdateEventListeners);
                this.hibernateConfiguration.getEventListeners().setPostDeleteEventListeners((PostDeleteEventListener[])postDeleteEventListeners);
                for (String dir : dirs = this.getConfig().getProperty(TOPIA_PERSISTENCE_DIRECTORIES, "").split(",")) {
                    if (!StringUtils.isNotEmpty((String)(dir = dir.trim()))) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Load persistence from dir : " + dir));
                    }
                    this.hibernateConfiguration.addDirectory(new File(dir));
                }
                for (TopiaService service : this.getServices().values()) {
                    Class<?>[] classes2 = service.getPersistenceClasses();
                    if (classes2 == null) continue;
                    for (Class<?> clazz : classes2) {
                        this.hibernateConfiguration.addClass(clazz);
                    }
                }
                String listPersistenceClasses = this.getConfig().getProperty(TOPIA_PERSISTENCE_CLASSES, "");
                for (String classname : classes = listPersistenceClasses.split(",")) {
                    Class<?> clazz;
                    if (!StringUtils.isNotEmpty((String)(classname = classname.trim()))) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Load persistent class : " + classname));
                    }
                    try {
                        clazz = Class.forName(classname);
                    }
                    catch (ClassNotFoundException eee) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Class " + classname + " not found"));
                        }
                        throw new TopiaNotFoundException(I18n._((String)"topia.persistence.error.class.not.found", (Object[])new Object[]{classname}));
                    }
                    this.persistenceClasses.add(clazz);
                    this.hibernateConfiguration.addClass(clazz);
                }
                Properties prop = new Properties();
                prop.putAll((Map<?, ?>)this.hibernateConfiguration.getProperties());
                prop.putAll((Map<?, ?>)this.getConfig());
                Properties propertiesFromClasspath = TopiaUtil.getProperties(this.getConfig().getProperty(TOPIA_PERSISTENCE_PROPERTIES_FILE));
                if (!propertiesFromClasspath.isEmpty()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Load properties from file : " + propertiesFromClasspath));
                    }
                    prop.putAll((Map<?, ?>)propertiesFromClasspath);
                }
                this.hibernateConfiguration.setProperties(prop);
            }
        }
        return this.hibernateConfiguration;
    }

    @Override
    public <E extends TopiaEntity> TopiaDAO<E> getDAO(Class<E> entityClass) throws TopiaException {
        if (entityClass == null) {
            throw new IllegalArgumentException(I18n._((String)"topia.persistence.error.null.param", (Object[])new Object[]{"entityClass", "getDAO"}));
        }
        if (this == this.getRootContext()) {
            throw new TopiaException(I18n._((String)"topia.persistence.error.rootContext.access", (Object[])new Object[0]));
        }
        if (this.getHibernateFactory().getClassMetadata(entityClass) == null && this.getHibernateFactory().getClassMetadata(entityClass.getName() + "Impl") == null && this.getHibernateFactory().getClassMetadata(entityClass.getName() + "Abstract") == null) {
            log.info((Object)I18n._((String)"topia.persistence.supported.classes.for.context", (Object[])new Object[]{this.getHibernateFactory().getAllClassMetadata().keySet()}));
            throw new TopiaException(I18n._((String)"topia.persistence.error.unsupported.class", (Object[])new Object[]{entityClass.getName()}));
        }
        TopiaDAOImpl<E> result = this.daoCache.get(entityClass);
        if (result == null) {
            String daoClassname = entityClass.getName() + "DAO";
            try {
                TopiaDAOImpl<E> spe;
                Class<?> daoClass = Class.forName(daoClassname);
                result = spe = (TopiaDAOImpl<E>)daoClass.newInstance();
            }
            catch (Exception eee) {
                log.warn((Object)("specialized DAO " + daoClassname + " not found, use default TopiaDAOHibernate"));
                result = new TopiaDAOImpl<E>();
            }
            result.init(this, entityClass);
            this.daoCache.put(entityClass, result);
        }
        return result;
    }

    @Override
    public <E extends TopiaEntity, D extends TopiaDAO<E>> D getDAO(Class<E> entityClass, Class<D> daoClass) throws TopiaException {
        return (D)this.getDAO(entityClass);
    }

    @Override
    public TopiaContext beginTransaction() throws TopiaException {
        this.checkClosed(I18n._((String)"topia.persistence.error.context.is.closed", (Object[])new Object[0]));
        TopiaContextImpl result = new TopiaContextImpl(this);
        SessionFactory factory = this.getHibernateFactory();
        result.hibernate = factory.openSession();
        result.hibernate.setFlushMode(FlushMode.MANUAL);
        result.useFlushMode = this.useFlushMode;
        try {
            result.hibernate.beginTransaction();
        }
        catch (Exception eee) {
            block4: {
                try {
                    result.hibernate.close();
                }
                catch (HibernateException e1) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)"Could not close hibernate session", (Throwable)e1);
                }
            }
            throw new TopiaException(I18n._((String)"topia.persistence.error.open.transaction.failed", (Object[])new Object[]{eee.getMessage()}), eee);
        }
        this.addChildContext(result);
        this.getFiresSupport().fireOnBeginTransaction(result);
        return result;
    }

    @Override
    public void commitTransaction() throws TopiaException {
        if (this.getRootContext() == this) {
            throw new TopiaException(I18n._((String)"topia.persistence.error.unsupported.operation.on.root.context", (Object[])new Object[]{"commit"}));
        }
        this.checkClosed(I18n._((String)"topia.persistence.error.unsupported.operation.on.closed.context", (Object[])new Object[]{"commit"}));
        try {
            Transaction tx = this.hibernate.getTransaction();
            this.hibernate.flush();
            tx.commit();
            this.getFiresSupport().fireOnPostCommit(this);
            TopiaContextImplementor parent = this.getParentContext();
            if (parent != null) {
                parent.getFiresSupport().fireOnPostCommit(this);
            }
            this.hibernate.beginTransaction();
        }
        catch (Exception eee) {
            throw new TopiaException(I18n._((String)"topia.persistence.error.on.commit", (Object[])new Object[]{eee.getMessage()}), eee);
        }
    }

    @Override
    public void rollbackTransaction() throws TopiaException {
        if (this.equals(this.getRootContext())) {
            throw new TopiaException(I18n._((String)"topia.persistence.error.unsupported.operation.on.root.context", (Object[])new Object[]{"rollback"}));
        }
        this.checkClosed(I18n._((String)"topia.persistence.error.unsupported.operation.on.closed.context", (Object[])new Object[]{"rollback"}));
        try {
            Transaction tx = this.hibernate.getTransaction();
            this.hibernate.clear();
            tx.rollback();
            this.hibernate.close();
            this.hibernate = this.getHibernateFactory().openSession();
            this.hibernate.setFlushMode(FlushMode.MANUAL);
            this.hibernate.beginTransaction();
            this.getFiresSupport().fireOnPostRollback(this);
            TopiaContextImplementor parent = this.getParentContext();
            if (parent != null) {
                parent.getFiresSupport().fireOnPostRollback(this);
            }
        }
        catch (HibernateException eee) {
            throw new TopiaException(I18n._((String)"topia.persistence.error.on.rollback", (Object[])new Object[]{eee.getMessage()}), eee);
        }
    }

    @Override
    public void closeContext() throws TopiaException {
        this.checkClosed(I18n._((String)"topia.persistence.error.context.already.closed", (Object[])new Object[0]));
        for (TopiaContextImplementor child : this.getChildContext()) {
            if (child.isClosed()) continue;
            child.closeContext();
        }
        if (!this.equals(this.getRootContext())) {
            this.closed = true;
            this.hibernate.close();
            this.getParentContext().removeChildContext(this);
        } else if (this.hibernateFactory != null) {
            this.hibernateFactory.close();
            this.closed = true;
            TopiaContextFactory.removeContext(this);
            log.debug((Object)"TopiaContext removed");
        }
    }

    protected void finalize() throws Throwable {
        if (this.hibernateFactory != null) {
            this.closeContext();
            this.hibernateFactory.close();
            this.closed = true;
            log.debug((Object)"TopiaContext finalized");
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    protected void checkClosed(String message) throws TopiaException {
        if (this.closed) {
            throw new TopiaException(message);
        }
    }

    @Override
    public TopiaEntity findByTopiaId(String id) throws TopiaException {
        this.checkClosed(I18n._((String)"topia.persistence.error.unsupported.operation.on.closed.context", (Object[])new Object[]{"findById"}));
        Class entityClass = TopiaId.getClassName(id);
        TopiaDAO dao = this.getDAO(entityClass);
        Object result = dao.findByTopiaId(id);
        return result;
    }

    @Override
    public List findByQuery(TopiaQuery query) throws TopiaException {
        return query.execute(this);
    }

    @Override
    public TopiaQuery createQuery(Class<?> entityClass, String alias) {
        return new TopiaQuery(entityClass, alias);
    }

    @Override
    public List find(String hql, Object ... args) throws TopiaException {
        this.checkClosed(I18n._((String)"topia.persistence.error.unsupported.operation.on.closed.context", (Object[])new Object[]{"find"}));
        try {
            Query query = this.getHibernate().createQuery(hql);
            for (int j = 0; j < args.length; j += 2) {
                String name = (String)args[j];
                Object value = args[j + 1];
                if (value.getClass().isArray()) {
                    query.setParameterList(name, (Object[])value);
                    continue;
                }
                query.setParameter(name, value);
            }
            if (this.useFlushMode) {
                query.setFlushMode(FlushMode.AUTO);
            }
            List result = query.list();
            result = this.firesSupport.fireEntitiesLoad(this, result);
            return result;
        }
        catch (HibernateException eee) {
            throw new TopiaException(I18n._((String)"topia.persistence.error.on.query", (Object[])new Object[]{hql, eee.getMessage()}), eee);
        }
    }

    @Override
    public List<?> find(String hql, int startIndex, int endIndex, Object ... args) throws TopiaException {
        this.checkClosed(I18n._((String)"topia.persistence.error.unsupported.operation.on.closed.context", (Object[])new Object[]{"find"}));
        try {
            Query query = this.getHibernate().createQuery(hql);
            for (int j = 0; j < args.length; j += 2) {
                String name = (String)args[j];
                Object value = args[j + 1];
                if (value.getClass().isArray()) {
                    query.setParameterList(name, (Object[])value);
                    continue;
                }
                query.setParameter(name, value);
            }
            query.setFirstResult(startIndex);
            query.setMaxResults(endIndex - startIndex + 1);
            if (this.useFlushMode) {
                query.setFlushMode(FlushMode.AUTO);
            }
            List result = query.list();
            result = this.firesSupport.fireEntitiesLoad(this, result);
            return result;
        }
        catch (HibernateException eee) {
            throw new TopiaException(I18n._((String)"topia.persistence.error.on.query", (Object[])new Object[]{hql, eee.getMessage()}), eee);
        }
    }

    @Override
    public int execute(String hql, Object ... args) throws TopiaException {
        this.checkClosed(I18n._((String)"topia.persistence.error.unsupported.operation.on.closed.context", (Object[])new Object[]{"find"}));
        try {
            Query query = this.getHibernate().createQuery(hql);
            for (int j = 0; j < args.length; j += 2) {
                query.setParameter((String)args[j], args[j + 1]);
            }
            int result = query.executeUpdate();
            return result;
        }
        catch (HibernateException eee) {
            throw new TopiaException(I18n._((String)"topia.persistence.error.on.query", (Object[])new Object[]{hql, eee.getMessage()}), eee);
        }
    }

    @Override
    public void add(TopiaEntity e) throws TopiaException {
        this.checkClosed(I18n._((String)"topia.persistence.error.unsupported.operation.on.closed.context", (Object[])new Object[]{"add"}));
        String id = e.getTopiaId();
        Class entityClass = TopiaId.getClassName(id);
        TopiaDAO<TopiaEntity> dao = this.getDAO(entityClass);
        dao.update(e);
    }

    @Override
    public void importXML(Reader xml) throws TopiaException {
        Session sessionDom4j;
        Document doc;
        this.checkClosed(I18n._((String)"topia.persistence.error.unsupported.operation.on.closed.context", (Object[])new Object[]{"importXML"}));
        SAXReader xmlReader = new SAXReader();
        try {
            doc = xmlReader.read(xml);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Lecture du document terminee");
            }
        }
        catch (DocumentException de) {
            throw new TopiaException(I18n._((String)"topia.persistence.error.on.loding.xml.doc", (Object[])new Object[]{de.getMessage()}), de);
        }
        if (doc != null) {
            sessionDom4j = this.getHibernate().getSession(EntityMode.DOM4J);
            Element rootElement = doc.getRootElement();
            Iterator it = rootElement.elementIterator();
            while (it.hasNext()) {
                Element entity = (Element)it.next();
                try {
                    sessionDom4j.replicate((Object)entity, ReplicationMode.EXCEPTION);
                }
                catch (HibernateException he) {
                    log.warn((Object)I18n._((String)"topia.persistence.error.replicate.entity", (Object[])new Object[]{entity, he.getMessage()}), (Throwable)he);
                }
            }
        } else {
            throw new TopiaException(I18n._((String)"topia.persistence.error.empty.doc", (Object[])new Object[0]));
        }
        sessionDom4j.flush();
    }

    @Override
    public void exportXML(Writer xml, Object ... entityAndcondition) throws TopiaException {
        this.checkClosed(I18n._((String)"topia.persistence.error.unsupported.operation.on.closed.context", (Object[])new Object[]{"exportXML"}));
        String[] queries = this.buildQueries(entityAndcondition);
        try {
            Session sessionDom4j = this.getHibernate().getSession(EntityMode.DOM4J);
            Document doc = DocumentFactory.getInstance().createDocument();
            Element rootElement = doc.addElement("topiaExport");
            SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            String date = format.format(new Date(System.currentTimeMillis()));
            rootElement.addAttribute("date", date);
            for (String query : queries) {
                List list = sessionDom4j.createQuery(query).list();
                for (Object o : list) {
                    rootElement.add((Element)o);
                }
            }
            XMLWriter result = new XMLWriter(xml, OutputFormat.createPrettyPrint());
            result.write(doc);
            result.close();
        }
        catch (HibernateException eee) {
            throw new TopiaException(I18n._((String)"topia.persistence.error.on.export", (Object[])new Object[]{eee.getMessage()}), eee);
        }
        catch (IOException eee) {
            throw new TopiaException(I18n._((String)"topia.persistence.error.on.export", (Object[])new Object[]{eee.getMessage()}), eee);
        }
    }

    @Override
    public void replicate(TopiaContext dstCtxt, Object ... entityAndCondition) throws TopiaException, IllegalArgumentException {
        this.checkClosed(I18n._((String)"topia.persistence.error.unsupported.operation.on.closed.context", (Object[])new Object[]{"replicate"}));
        TopiaContextImpl dstContextImpl = (TopiaContextImpl)dstCtxt;
        dstContextImpl.checkClosed(I18n._((String)"topia.persistence.error.unsupported.operation.on.closed.context", (Object[])new Object[]{"replicate"}));
        if (this.getRootContext().equals(dstContextImpl.getRootContext())) {
            throw new IllegalArgumentException(I18n._((String)"topia.persistence.error.replicate.on.same.context", (Object[])new Object[0]));
        }
        String[] queries = this.buildQueries(entityAndCondition);
        try {
            for (String query : queries) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("acquire entities " + query));
                }
                List entities = this.find(query, new Object[0]);
                this.replicate0(dstContextImpl, entities.toArray());
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("replication of entities " + query + " was sucessfully done."));
            }
        }
        catch (HibernateException eee) {
            throw new TopiaException(I18n._((String)"topia.persistence.error.on.replicate", (Object[])new Object[]{eee.getMessage()}), eee);
        }
    }

    @Override
    public <T extends TopiaEntity> void replicateEntity(TopiaContext dstCtxt, T entity) throws TopiaException, IllegalArgumentException {
        this.checkClosed(I18n._((String)"topia.persistence.error.unsupported.operation.on.closed.context", (Object[])new Object[]{"replicateEntity"}));
        TopiaContextImpl dstContextImpl = (TopiaContextImpl)dstCtxt;
        dstContextImpl.checkClosed(I18n._((String)"topia.persistence.error.unsupported.operation.on.closed.context", (Object[])new Object[]{"replicateEntity"}));
        if (this.getRootContext().equals(dstContextImpl.getRootContext())) {
            throw new IllegalArgumentException(I18n._((String)"topia.persistence.error.replicate.on.same.context", (Object[])new Object[0]));
        }
        this.replicate0(dstContextImpl, entity);
    }

    @Override
    public <T extends TopiaEntity> void replicateEntities(TopiaContext dstCtxt, List<T> entities) throws TopiaException, IllegalArgumentException {
        this.checkClosed(I18n._((String)"topia.persistence.error.unsupported.operation.on.closed.context", (Object[])new Object[]{"replicateEntities"}));
        TopiaContextImpl dstContextImpl = (TopiaContextImpl)dstCtxt;
        dstContextImpl.checkClosed(I18n._((String)"topia.persistence.error.unsupported.operation.on.closed.context", (Object[])new Object[]{"replicateEntities"}));
        if (this.getRootContext().equals(dstContextImpl.getRootContext())) {
            throw new IllegalArgumentException(I18n._((String)"topia.persistence.error.replicate.on.same.context", (Object[])new Object[0]));
        }
        this.replicate0(dstContextImpl, entities.toArray());
    }

    @Override
    public TopiaFiresSupport getFiresSupport() {
        return this.firesSupport;
    }

    @Override
    public void backup(File file, boolean compress) throws TopiaException {
        this.checkClosed(I18n._((String)"topia.persistence.error.unsupported.operation.on.closed.context", (Object[])new Object[]{"backup"}));
        try {
            String options = "";
            if (compress) {
                options = options + " COMPRESSION GZIP";
            }
            SQLQuery query = this.getHibernate().createSQLQuery("SCRIPT TO '" + file.getAbsolutePath() + "'" + options);
            query.list();
        }
        catch (Exception eee) {
            throw new TopiaException(I18n._((String)"topia.persistence.error.on.backup", (Object[])new Object[]{eee.getMessage()}), eee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restore(File file) throws TopiaException {
        this.getFiresSupport().firePreRestoreSchema(this);
        this.checkClosed(I18n._((String)"topia.persistence.error.unsupported.operation.on.closed.context", (Object[])new Object[]{"restore"}));
        Object sql = null;
        String options = "";
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            try {
                ((InputStream)in).mark(2);
                int b = ((InputStream)in).read();
                int magic = ((InputStream)in).read() << 8 | b;
                ((InputStream)in).reset();
                if (magic == 35615) {
                    options = options + " COMPRESSION GZIP";
                }
            }
            finally {
                ((InputStream)in).close();
            }
            SQLQuery query = this.getHibernate().createSQLQuery("RUNSCRIPT FROM '" + file.getAbsolutePath() + "'" + options);
            query.executeUpdate();
            this.getFiresSupport().firePostRestoreSchema(this);
        }
        catch (Exception eee) {
            throw new TopiaException(I18n._((String)"topia.persistence.error.on.restore", (Object[])new Object[]{sql, eee.getMessage()}), eee);
        }
    }

    @Override
    public void clear(boolean dropDatabase) throws TopiaException {
        try {
            TopiaContextImpl root = (TopiaContextImpl)this.getRootContext();
            TopiaContextImpl tx = (TopiaContextImpl)root.beginTransaction();
            String sql = "DROP ALL OBJECTS";
            if (dropDatabase) {
                sql = sql + " DELETE FILES";
            }
            SQLQuery query = tx.getHibernate().createSQLQuery(sql);
            query.executeUpdate();
            tx.closeContext();
            root.finalize();
        }
        catch (Throwable eee) {
            throw new TopiaException(I18n._((String)"topia.persistence.error.on.clear", (Object[])new Object[]{eee.getMessage()}), eee);
        }
    }

    @Override
    public List<Class<?>> getPersistenceClasses() {
        return this.persistenceClasses;
    }

    @Override
    public boolean isSchemaExist(Class<?> clazz) throws TopiaException {
        this.checkClosed(I18n._((String)"topia.persistence.error.unsupported.operation.on.closed.context", (Object[])new Object[]{"replicateEntity"}));
        boolean result = TopiaUtil.isSchemaExist(this.hibernateConfiguration, clazz.getName());
        return result;
    }

    @Override
    public void addTopiaEntityListener(TopiaEntityListener listener) {
        this.getFiresSupport().addTopiaEntityListener(listener);
    }

    @Override
    public void addTopiaEntityListener(Class<? extends TopiaEntity> entityClass, TopiaEntityListener listener) {
        this.getFiresSupport().addTopiaEntityListener(entityClass, listener);
    }

    @Override
    public void addTopiaEntityVetoable(TopiaEntityVetoable vetoable) {
        this.getFiresSupport().addTopiaEntityVetoable(TopiaEntity.class, vetoable);
    }

    @Override
    public void addTopiaEntityVetoable(Class<? extends TopiaEntity> entityClass, TopiaEntityVetoable vetoable) {
        this.getFiresSupport().addTopiaEntityVetoable(entityClass, vetoable);
    }

    @Override
    public void addTopiaTransactionListener(TopiaTransactionListener listener) {
        this.getFiresSupport().addTopiaTransactionListener(listener);
    }

    @Override
    public void addTopiaTransactionVetoable(TopiaTransactionVetoable vetoable) {
        this.getFiresSupport().addTopiaTransactionVetoable(vetoable);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getFiresSupport().addPropertyChangeListener(listener);
    }

    @Override
    public void addTopiaContextListener(TopiaContextListener listener) {
        this.getFiresSupport().addTopiaContextListener(listener);
    }

    @Override
    public void removeTopiaEntityListener(TopiaEntityListener listener) {
        this.getFiresSupport().removeTopiaEntityListener(TopiaEntity.class, listener);
    }

    @Override
    public void removeTopiaEntityListener(Class<? extends TopiaEntity> entityClass, TopiaEntityListener listener) {
        this.getFiresSupport().removeTopiaEntityListener(entityClass, listener);
    }

    @Override
    public void removeTopiaEntityVetoable(TopiaEntityVetoable vetoable) {
        this.getFiresSupport().removeTopiaEntityVetoable(TopiaEntity.class, vetoable);
    }

    @Override
    public void removeTopiaEntityVetoable(Class<? extends TopiaEntity> entityClass, TopiaEntityVetoable vetoable) {
        this.getFiresSupport().removeTopiaEntityVetoable(entityClass, vetoable);
    }

    @Override
    public void removeTopiaTransactionListener(TopiaTransactionListener listener) {
        this.getFiresSupport().removeTopiaTransactionListener(listener);
    }

    @Override
    public void removeTopiaTransactionVetoable(TopiaTransactionVetoable vetoable) {
        this.getFiresSupport().removeTopiaTransactionVetoable(vetoable);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getFiresSupport().removePropertyChangeListener(listener);
    }

    @Override
    public void removeTopiaContextListener(TopiaContextListener listener) {
        this.getFiresSupport().removeTopiaContextListener(listener);
    }

    @Override
    public void addTopiaEntitiesVetoable(TopiaEntitiesVetoable vetoable) {
        this.getFiresSupport().addTopiaEntitiesVetoable(vetoable);
    }

    @Override
    public void removeTopiaEntitiesVetoable(TopiaEntitiesVetoable vetoable) {
        this.getFiresSupport().removeTopiaEntitiesVetoable(vetoable);
    }

    protected String[] buildQueries(Object ... entityAndCondition) throws TopiaException, IllegalArgumentException {
        int i;
        if (entityAndCondition.length == 0) {
            Map classMetadata = this.getHibernateFactory().getAllClassMetadata();
            entityAndCondition = new Object[classMetadata.size() * 2];
            i = 0;
            for (Object className : classMetadata.keySet()) {
                try {
                    entityAndCondition[i++] = Class.forName((String)className);
                }
                catch (ClassNotFoundException e) {
                    throw new TopiaException("class cast exception for entity " + className);
                }
                entityAndCondition[i++] = null;
            }
        }
        if (entityAndCondition.length % 2 != 0) {
            throw new IllegalArgumentException("entityAndCondition must be a couple of (Class, String)");
        }
        String[] queries = new String[entityAndCondition.length / 2];
        i = 0;
        while (i < entityAndCondition.length) {
            try {
                Class entityClass = (Class)entityAndCondition[i++];
                String condition = (String)entityAndCondition[i++];
                String query = "from " + entityClass.getName();
                if (condition != null && !condition.isEmpty()) {
                    query = query + " where " + condition;
                }
                queries[(i - 1) / 2] = query;
            }
            catch (ClassCastException e) {
                if (i % 2 == 0) {
                    throw new IllegalArgumentException("Others arguement must be String not " + entityAndCondition[i - 1], e);
                }
                throw new IllegalArgumentException("Others arguement must be Class not " + entityAndCondition[i - 1], e);
            }
        }
        return queries;
    }

    protected void replicate0(TopiaContextImpl dstContextImpl, Object ... entities) throws TopiaException {
        try {
            for (Object entity : entities) {
                this.getHibernate().evict(entity);
                dstContextImpl.getHibernate().replicate(entity, ReplicationMode.EXCEPTION);
            }
        }
        catch (HibernateException eee) {
            throw new TopiaException(I18n._((String)"topia.persistence.error.on.replicate", (Object[])new Object[]{eee.getMessage()}), eee);
        }
    }
}

