/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.java.JavaBuilder;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelType;
import org.nuiton.topia.framework.TopiaQuery;
import org.nuiton.topia.generator.TopiaGeneratorUtil;
import org.nuiton.topia.persistence.TopiaEntity;

public class QueryHelperTransformer
extends ObjectModelTransformerToJava {
    private static final Log log = LogFactory.getLog(QueryHelperTransformer.class);
    protected ObjectModelClass helperClass;
    protected ObjectModelClass abstractEntityPropertyClass;
    protected static final String ENTITY_PROPERTY_CLASS_NAME = "EntityProperty";
    protected static final String ENTITY_PROPERTY_SUFFIX = "Property";
    protected static final String ENTITY_PROPERTY_GENERIC_TYPE = "<E>";
    protected String mainException;
    protected Map<String, String> aliases;
    public static final String CONSTANT_PREFIX = "ALIAS_";

    public void transformFromModel(ObjectModel model) {
        this.aliases = new HashMap<String, String>();
        String modelName = StringUtils.capitalize((String)model.getName());
        String packageName = this.getOutputProperties().getProperty("defaultPackage");
        this.helperClass = this.createClass(modelName + "QueryHelper", packageName);
        this.addImport((ObjectModelClassifier)this.helperClass, TopiaQuery.class);
        this.addImport((ObjectModelClassifier)this.helperClass, TopiaEntity.class);
        String exception = model.getTagValue("exceptionClass");
        if (exception != null) {
            this.addImport((ObjectModelClassifier)this.helperClass, exception);
            this.mainException = TopiaGeneratorUtil.getSimpleName((String)exception);
        }
        this.initConstantPrefixFromModel();
        this.createInnerAbstractEntityPropertyClass();
        this.createUtilOperations();
    }

    protected void createInnerAbstractEntityPropertyClass() {
        this.abstractEntityPropertyClass = (ObjectModelClass)this.addInnerClassifier(this.helperClass, ObjectModelType.OBJECT_MODEL_CLASS, "EntityProperty<E>", new ObjectModelModifier[]{ObjectModelModifier.ABSTRACT, ObjectModelModifier.STATIC});
        this.addImport((ObjectModelClassifier)this.helperClass, HashMap.class);
        this.addImport((ObjectModelClassifier)this.helperClass, Map.class);
        this.addAttribute((ObjectModelClassifier)this.abstractEntityPropertyClass, "alias", String.class, null, new ObjectModelModifier[]{ObjectModelModifier.PROTECTED});
        this.addAttribute((ObjectModelClassifier)this.abstractEntityPropertyClass, "propertiesCache", "Map<String, String>", null, new ObjectModelModifier[]{ObjectModelModifier.PROTECTED});
        ObjectModelOperation constructor = this.builder.addOperation((ObjectModelClassifier)this.abstractEntityPropertyClass, ENTITY_PROPERTY_CLASS_NAME, null, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.setOperationBody(constructor, "\n            propertiesCache = new HashMap<String, String>();\n    ");
        ObjectModelOperation setAlias = this.addOperation((ObjectModelClassifier)this.abstractEntityPropertyClass, "setAlias", "void", new ObjectModelModifier[]{ObjectModelModifier.PROTECTED});
        this.addParameter(setAlias, String.class, "alias");
        this.setOperationBody(setAlias, "\n            this.alias = alias;\n    ");
        ObjectModelOperation getAlias = this.addOperation((ObjectModelClassifier)this.abstractEntityPropertyClass, "$alias", String.class, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.setOperationBody(getAlias, "\n            return alias;\n    ");
        ObjectModelOperation getProperty = this.addOperation((ObjectModelClassifier)this.abstractEntityPropertyClass, "$property", String.class, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addParameter(getProperty, String.class, "propertyName");
        this.setOperationBody(getProperty, "\n            String result = propertiesCache.get(propertyName);\n            if (result == null) {\n                result = TopiaQuery.getProperty(alias, propertyName);\n                propertiesCache.put(propertyName, result);\n            }\n            return result;\n    ");
        ObjectModelOperation topiaCreateDate = this.addOperation((ObjectModelClassifier)this.abstractEntityPropertyClass, "topiaCreateDate", String.class, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.setOperationBody(topiaCreateDate, "\n            return $property(TopiaEntity.TOPIA_CREATE_DATE);\n    ");
        ObjectModelOperation topiaId = this.addOperation((ObjectModelClassifier)this.abstractEntityPropertyClass, "topiaId", String.class, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.setOperationBody(topiaId, "\n            return $property(TopiaEntity.TOPIA_ID);\n    ");
        ObjectModelOperation topiaVersion = this.addOperation((ObjectModelClassifier)this.abstractEntityPropertyClass, "topiaVersion", String.class, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.setOperationBody(topiaVersion, "\n            return $property(TopiaEntity.TOPIA_VERSION);\n    ");
        this.addOperation((ObjectModelClassifier)this.abstractEntityPropertyClass, "getEntityClass", "Class<E>", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.ABSTRACT});
        this.addOperation((ObjectModelClassifier)this.abstractEntityPropertyClass, "defaultAlias", String.class, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.ABSTRACT});
    }

    protected void createUtilOperations() {
        ObjectModelOperation createQuery = this.addOperation((ObjectModelClassifier)this.helperClass, "createQuery", TopiaQuery.class, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
        this.addParameter(createQuery, ENTITY_PROPERTY_CLASS_NAME, "property");
        this.setOperationBody(createQuery, "\n        return new TopiaQuery((Class<? extends TopiaEntity>)property.getEntityClass(), property.$alias());\n    ");
        ObjectModelOperation format = this.addOperation((ObjectModelClassifier)this.helperClass, "format", String.class, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
        this.addParameter(format, String.class, "statement");
        this.addParameter(format, "String...", "propertyNames");
        this.setOperationBody(format, "\n        for (int i = 1; i <= propertyNames.length; i++) {\n           statement = statement.replace(\"$\" + i, propertyNames[i-1]);\n        }\n        return statement;\n    ");
        String genericType = "<P extends EntityProperty> P";
        ObjectModelOperation newEntityProperty1 = this.addOperation((ObjectModelClassifier)this.helperClass, "newEntityProperty", genericType, new ObjectModelModifier[]{ObjectModelModifier.PRIVATE, ObjectModelModifier.STATIC});
        this.addParameter(newEntityProperty1, "Class<P>", "propertyClass");
        this.setOperationBody(newEntityProperty1, "\n        return newEntityProperty(propertyClass, null);\n    ");
        ObjectModelOperation newEntityProperty2 = this.addOperation((ObjectModelClassifier)this.helperClass, "newEntityProperty", genericType, new ObjectModelModifier[]{ObjectModelModifier.PRIVATE, ObjectModelModifier.STATIC});
        this.addParameter(newEntityProperty2, "Class<P>", "propertyClass");
        this.addParameter(newEntityProperty2, String.class, "alias");
        StringBuilder buffer = new StringBuilder("\n        try {\n            P property = propertyClass.newInstance();\n            if (alias == null) {\n                alias = property.defaultAlias();\n            }\n            property.setAlias(alias);\n            return property;\n        } catch (Exception eee) {\n    ");
        if (this.mainException != null) {
            this.addException(newEntityProperty1, this.mainException);
            this.addException(newEntityProperty2, this.mainException);
            buffer.append("\n            throw new " + this.mainException + "(\"Error instantiate \" + propertyClass.getName(), eee);\n" + "    ");
        } else {
            buffer.append("\n            throw new Error(\"Error instantiate \" + propertyClass.getName(), eee);\n    ");
        }
        buffer.append("\n        }\n    ");
        this.setOperationBody(newEntityProperty2, buffer.toString());
    }

    public void transformFromClass(ObjectModelClass clazz) {
        if (!TopiaGeneratorUtil.hasStereotype((ObjectModelElement)clazz, (String)"entity")) {
            return;
        }
        String aliasConstant = this.createAliasConstant(clazz.getName());
        ObjectModelClass entityPropertyClass = this.createInnerClass(clazz, aliasConstant);
        this.createNewOperations(entityPropertyClass);
        this.addExtraForSubEntity(clazz);
    }

    protected String createAliasConstant(String entityName) {
        String constantName = TopiaGeneratorUtil.convertVariableNameToConstantName((String)entityName);
        String[] words = constantName.split("_");
        String alias = "";
        for (String word : words) {
            alias = alias + word.substring(0, 1);
        }
        String lastWord = words[words.length - 1];
        while (this.aliases.containsKey(alias)) {
            if (!(lastWord = lastWord.substring(1, lastWord.length())).isEmpty()) {
                alias = alias + lastWord.charAt(0);
                continue;
            }
            alias = alias + StringUtils.upperCase((String)RandomStringUtils.randomAlphabetic((int)1));
        }
        String aliasPropertyName = CONSTANT_PREFIX + constantName;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add alias '" + alias + "' named " + aliasPropertyName));
        }
        this.aliases.put(alias, aliasPropertyName);
        this.addAttribute((ObjectModelClassifier)this.helperClass, aliasPropertyName, String.class, "\"" + alias + "\"", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC, ObjectModelModifier.FINAL});
        return aliasPropertyName;
    }

    protected ObjectModelClass createInnerClass(ObjectModelClass input, String aliasConstant) {
        String className = this.getPropertyClassName((ObjectModelClassifier)input);
        ObjectModelClass propertyClass = (ObjectModelClass)this.addInnerClassifier(this.helperClass, ObjectModelType.OBJECT_MODEL_CLASS, className, new ObjectModelModifier[]{ObjectModelModifier.STATIC});
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate for entity : " + input.getQualifiedName()));
        }
        this.addImport((ObjectModelClassifier)this.helperClass, input.getQualifiedName());
        String superClassQualifiedName = this.abstractEntityPropertyClass.getQualifiedName().replace(ENTITY_PROPERTY_GENERIC_TYPE, "<" + input.getName() + ">");
        this.setSuperClass(propertyClass, superClassQualifiedName);
        ObjectModelOperation constructor = this.addConstructor(propertyClass, ObjectModelModifier.PROTECTED);
        this.setOperationBody(constructor, "\n    ");
        ObjectModelOperation getEntityClass = this.addOperation((ObjectModelClassifier)propertyClass, "getEntityClass", "Class<" + input.getName() + ">", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)propertyClass, (ObjectModelElement)getEntityClass, "Override");
        this.setOperationBody(getEntityClass, "\n            return " + input.getName() + ".class;\n" + "    ");
        ObjectModelOperation defaultAlias = this.addOperation((ObjectModelClassifier)propertyClass, "defaultAlias", String.class, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)propertyClass, (ObjectModelElement)defaultAlias, "Override");
        this.setOperationBody(defaultAlias, "\n            return " + aliasConstant + ";\n" + "    ");
        this.createGetterOperations(input, propertyClass);
        return propertyClass;
    }

    protected void createGetterOperations(ObjectModelClass input, ObjectModelClass propertyClass) {
        ObjectModelOperation propertyNameOperation;
        for (ObjectModelAttribute attr : input.getAttributes()) {
            if (!attr.isNavigable()) continue;
            String attrName = this.getReferenceAttributeName(attr);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity property : name=" + attrName + " _ navigable=" + attr.isNavigable() + " _ maxMultiplicity=" + attr.getMaxMultiplicity() + " _ associationClass=" + attr.hasAssociationClass() + " _ referenceClassifier=" + attr.referenceClassifier()));
            }
            propertyNameOperation = this.createGetPropertyNameOperation(propertyClass, attrName, input.getName());
            this.createGetPropertyObjectOperation(propertyClass, attr, propertyNameOperation);
        }
        if (input instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass)input;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                propertyNameOperation = this.createGetPropertyNameOperation(propertyClass, attr.getName(), input.getName());
                this.createGetPropertyObjectOperation(propertyClass, attr, propertyNameOperation);
            }
        }
    }

    protected ObjectModelOperation createGetPropertyNameOperation(ObjectModelClass output, String attrName, String entityClassName) {
        ObjectModelOperation result = this.addOperation((ObjectModelClassifier)output, attrName, String.class, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        String constantName = entityClassName + "." + this.getConstantName(attrName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add getter for property : " + attrName + " _ constantName = " + constantName + " _ constantPrefix = " + this.getConstantPrefix()));
        }
        this.setOperationBody(result, "\n            return $property(" + constantName + ");\n" + "    ");
        return result;
    }

    protected ObjectModelOperation createGetPropertyObjectOperation(ObjectModelClass output, ObjectModelAttribute attrReference, ObjectModelOperation propertyNameOperation) {
        ObjectModelClassifier referenceClass = this.getReferenceAttributeClassifier(attrReference);
        if (referenceClass == null) {
            return null;
        }
        String operationName = this.getReferenceAttributeName(attrReference) + ENTITY_PROPERTY_SUFFIX;
        String referencePropertyClassName = this.getPropertyClassName(referenceClass);
        ObjectModelOperation result = this.addOperation((ObjectModelClassifier)output, operationName, referencePropertyClassName, new ObjectModelModifier[0]);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Extra operation : " + operationName + " _ className = " + referencePropertyClassName));
        }
        this.setOperationBody(result, "\n            return new" + referencePropertyClassName + "(" + propertyNameOperation.getName() + "());\n" + "    ");
        return result;
    }

    protected void createNewOperations(ObjectModelClass entityProperty) {
        String className = entityProperty.getName();
        String methodName = "new" + className;
        ObjectModelOperation newEntityProperty1 = this.addOperation((ObjectModelClassifier)this.helperClass, "new" + className, className, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
        this.setOperationBody(newEntityProperty1, "\n        return " + methodName + "(null);\n" + "    ");
        ObjectModelOperation newEntityProperty2 = this.addOperation((ObjectModelClassifier)this.helperClass, "new" + className, className, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
        this.addParameter(newEntityProperty2, String.class, "alias");
        this.setOperationBody(newEntityProperty2, "\n        return newEntityProperty(" + className + ".class, alias);\n" + "    ");
    }

    protected void addExtraForSubEntity(ObjectModelClass entityClass) {
        for (ObjectModelAttribute attr : entityClass.getAttributes()) {
            if (!attr.isNavigable() || !attr.referenceClassifier() || !attr.getClassifier().getName().equals(entityClass.getName())) continue;
            String propertyClassName = this.getPropertyClassName((ObjectModelClassifier)entityClass);
            String subEntityName = entityClass.getName() + StringUtils.capitalize((String)attr.getName());
            String aliasConstant = this.createAliasConstant(subEntityName);
            ObjectModelOperation newEntityProperty = this.addOperation((ObjectModelClassifier)this.helperClass, "new" + subEntityName + ENTITY_PROPERTY_SUFFIX, propertyClassName, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
            String callMethodName = "new" + propertyClassName;
            this.setOperationBody(newEntityProperty, "\n        return " + callMethodName + "(" + aliasConstant + ");\n" + "    ");
        }
    }

    protected String getPropertyClassName(ObjectModelClassifier entityClass) {
        return entityClass.getName() + ENTITY_PROPERTY_SUFFIX;
    }

    protected String getReferenceAttributeName(ObjectModelAttribute attrReference) {
        String attrName = attrReference.getName();
        if (attrReference.hasAssociationClass()) {
            attrName = GeneratorUtil.getAssocAttrName((ObjectModelAttribute)attrReference);
        }
        return attrName;
    }

    protected ObjectModelClassifier getReferenceAttributeClassifier(ObjectModelAttribute attrReference) {
        ObjectModelClass referenceClass = null;
        if (attrReference.referenceClassifier() && attrReference.getMaxMultiplicity() == 1) {
            referenceClass = attrReference.getClassifier();
        } else if (attrReference.hasAssociationClass()) {
            referenceClass = attrReference.getAssociationClass();
        }
        return referenceClass;
    }

    protected void setBuilder(JavaBuilder builder) {
        this.builder = builder;
    }
}

