package org.nuiton.topiatest.beangen;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;


public  abstract class Siege implements Serializable {

    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_NO_SERIE = "noSerie";
    public static final String PROPERTY_VOITURE = "voiture";
    protected int noSerie;
    protected Voiture voiture;
    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);;
    /**
     * getNoSerie :
     * @return int 
     */

    public int getNoSerie() {
        return noSerie;
    }

    /**
     * setNoSerie :
     * @param noSerie 
     */

    public void setNoSerie(int noSerie) {
        int oldValue = getNoSerie();
        this.noSerie = noSerie;
        firePropertyChange(PROPERTY_NO_SERIE, oldValue, noSerie);
    }

    /**
     * getVoiture :
     * @return Voiture 
     */

    public Voiture getVoiture() {
        return voiture;
    }

    /**
     * setVoiture :
     * @param voiture 
     */

    public void setVoiture(Voiture voiture) {
        Voiture oldValue = getVoiture();
        this.voiture = voiture;
        firePropertyChange(PROPERTY_VOITURE, oldValue, voiture);
    }

    /**
     * addPropertyChangeListener :
     * @param listener 
     */

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    /**
     * addPropertyChangeListener :
     * @param propertyName 
     * @param listener 
     */

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(propertyName, listener);
    }

    /**
     * removePropertyChangeListener :
     * @param listener 
     */

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

    /**
     * removePropertyChangeListener :
     * @param propertyName 
     * @param listener 
     */

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(propertyName, listener);
    }

    /**
     * firePropertyChange :
     * @param propertyName 
     * @param oldValue 
     * @param newValue 
     */

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    /**
     * firePropertyChange :
     * @param propertyName 
     * @param newValue 
     */

    protected void firePropertyChange(String propertyName, Object newValue) {
        firePropertyChange(propertyName, null, newValue);
    }


} //Siege
