/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.framework;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.nuiton.topia.framework.EntityFilter;
import org.nuiton.topia.framework.TopiaFilter;
import org.nuiton.topia.framework.TopiaQuery;
import org.nuiton.topiatest.QueriedEntity;

public class TopiaQueryTest {
    private static final Log log = LogFactory.getLog(TopiaQueryTest.class);

    @Test
    public void testAdd() {
        String value = "topia";
        TopiaQuery query = new TopiaQuery(QueriedEntity.class);
        query.addEquals("testAdd", new Object[]{value});
        Assert.assertEquals((Object)"FROM org.nuiton.topiatest.QueriedEntity WHERE testAdd = :testAdd", (Object)query.fullQuery());
        query = new TopiaQuery(QueriedEntity.class);
        query.addEquals("testAdd", null);
        Assert.assertEquals((Object)"FROM org.nuiton.topiatest.QueriedEntity WHERE testAdd IS NULL", (Object)query.fullQuery());
        String value2 = "eugene";
        query = new TopiaQuery(QueriedEntity.class);
        query.addEquals("testAdd", new Object[]{value, value2});
        Assert.assertEquals((Object)"FROM org.nuiton.topiatest.QueriedEntity WHERE testAdd IN (:testAdd1, :testAdd2)", (Object)query.fullQuery());
        query = new TopiaQuery(QueriedEntity.class);
        query.addEquals("testAdd", new Object[]{value, value2, null});
        Assert.assertEquals((Object)"FROM org.nuiton.topiatest.QueriedEntity WHERE (testAdd IN (:testAdd1, :testAdd2) OR testAdd IS NULL)", (Object)query.fullQuery());
    }

    @Test
    public void testAddSubQuery() {
        TopiaQuery query = new TopiaQuery(QueriedEntity.class).addEquals("testAdd", new Object[]{"value1"});
        Assert.assertEquals((long)2L, (long)query.getParams().size());
        TopiaQuery subquery = new TopiaQuery(QueriedEntity.class).addEquals("testAdd", new Object[]{"value2"});
        query.addSubQuery("Q1 = (?)", subquery);
        log.debug((Object)query);
        Assert.assertEquals((long)4L, (long)query.getParams().size());
        query = new TopiaQuery(QueriedEntity.class).addWhere("testAdd", TopiaQuery.Op.EQ, null);
        Assert.assertEquals((long)0L, (long)query.getParams().size());
        subquery = new TopiaQuery(QueriedEntity.class).addEquals("testAdd", new Object[]{"value1"});
        query.addSubQuery("Q1 = (?)", subquery);
        log.debug((Object)query);
        Assert.assertEquals((long)2L, (long)query.getParams().size());
        query = new TopiaQuery(QueriedEntity.class, "Q1").addEquals("testAdd", new Object[]{"value1"});
        Assert.assertEquals((long)2L, (long)query.getParams().size());
        subquery = new TopiaQuery(QueriedEntity.class, "Q2").addEquals("testAdd", new Object[]{"value1"});
        query.addSubQuery("Q1 = (?)", subquery);
        log.debug((Object)query);
        Assert.assertEquals((long)2L, (long)query.getParams().size());
    }

    @Test
    public void testAddFilter() {
        log.info((Object)"testAddFilter");
        TopiaFilter filter = new TopiaFilter();
        filter.setStartIndex(Integer.valueOf(1));
        filter.setEndIndex(Integer.valueOf(40));
        filter.setOrderBy("testAdd");
        TopiaQuery query = new TopiaQuery(QueriedEntity.class).addFilter((EntityFilter)filter);
        log.debug((Object)("Query : " + query));
        Assert.assertEquals((Object)query.fullQuery(), (Object)("FROM " + QueriedEntity.class.getName() + " ORDER BY " + "testAdd"));
        filter.setOrderBy(null);
        query = new TopiaQuery(QueriedEntity.class).addFilter((EntityFilter)filter);
        log.debug((Object)("Query : " + query));
        Assert.assertEquals((Object)query.fullQuery(), (Object)("FROM " + QueriedEntity.class.getName() + " ORDER BY " + "topiaCreateDate" + " DESC"));
    }
}

