/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class ServiceTransformer
extends ObjectModelTransformerToJava {
    protected String modelName;
    protected String defaultPackageName;

    protected String getContextInterfaceName() {
        return this.modelName + "Context";
    }

    protected String getContextImplementorInterfaceName() {
        return this.getContextInterfaceName() + "Implementor";
    }

    protected String getExceptionClassName() {
        return this.modelName + "Exception";
    }

    protected String getServiceAbstractClassName(String serviceName) {
        return serviceName + "Abstract";
    }

    public void transformFromModel(ObjectModel model) {
        this.modelName = model.getName();
        this.defaultPackageName = this.getOutputProperties().getProperty("defaultPackage");
        ObjectModelInterface contextImplementor = model.getInterface(this.defaultPackageName + "." + this.getContextImplementorInterfaceName());
        ObjectModelInterface context = model.getInterface(this.defaultPackageName + "." + this.getContextInterfaceName());
        ObjectModelClass exception = this.createExceptionClass();
        ObjectModelInterface newContextImplementor = this.createInterface(this.getContextImplementorInterfaceName(), this.defaultPackageName);
        ObjectModelInterface newContext = this.createInterface(this.getContextInterfaceName(), this.defaultPackageName);
        this.addInterface((ObjectModelClassifier)newContextImplementor, newContext.getQualifiedName());
        if (contextImplementor != null) {
            this.copyInterfaceOperations(contextImplementor, newContextImplementor);
        }
        if (context != null) {
            this.copyInterfaceOperations(context, newContext);
        }
        ObjectModelOperation beginTransaction = this.addOperation((ObjectModelClassifier)newContextImplementor, "beginTransaction", TopiaContext.class, new ObjectModelModifier[0]);
        this.addException(beginTransaction, TopiaException.class);
        ObjectModelOperation doCatch1 = this.addOperation((ObjectModelClassifier)newContextImplementor, "doCatch", "void", new ObjectModelModifier[0]);
        this.addParameter(doCatch1, Exception.class, "eee");
        this.addParameter(doCatch1, String.class, "message");
        this.addParameter(doCatch1, "Object...", "args");
        this.addException(doCatch1, exception.getQualifiedName());
        ObjectModelOperation doCatch2 = this.addOperation((ObjectModelClassifier)newContextImplementor, "doCatch", "void", new ObjectModelModifier[0]);
        this.addParameter(doCatch2, TopiaContext.class, "transaction");
        this.addParameter(doCatch2, Exception.class, "eee");
        this.addParameter(doCatch2, String.class, "message");
        this.addParameter(doCatch2, "Object...", "args");
        this.addException(doCatch2, exception.getQualifiedName());
        ObjectModelOperation doFinally = this.addOperation((ObjectModelClassifier)newContextImplementor, "doFinally", "void", new ObjectModelModifier[0]);
        this.addParameter(doFinally, TopiaContext.class, "transaction");
    }

    protected ObjectModelClass createExceptionClass() {
        ObjectModelClass exception = this.createClass(this.getExceptionClassName(), this.defaultPackageName);
        this.setSuperClass(exception, RuntimeException.class);
        this.addAttribute((ObjectModelClassifier)exception, "args", "Object[]", null, new ObjectModelModifier[]{ObjectModelModifier.PROTECTED});
        ObjectModelOperation constructor = this.addConstructor(exception, ObjectModelModifier.PUBLIC);
        this.addParameter(constructor, Throwable.class, "eee");
        this.addParameter(constructor, String.class, "message");
        this.addParameter(constructor, "Object...", "args");
        this.setOperationBody(constructor, "\n        super(message, eee);\n        this.args = args;\n    ");
        ObjectModelOperation getArgs = this.addOperation((ObjectModelClassifier)exception, "getArgs", "Object[]", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.setOperationBody(getArgs, "\n        return args;\n    ");
        ObjectModelOperation hasArgs = this.addOperation((ObjectModelClassifier)exception, "hasArgs", "boolean", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.setOperationBody(hasArgs, "\n        return args.length > 0;\n    ");
        return exception;
    }

    protected void copyInterfaceOperations(ObjectModelInterface source, ObjectModelInterface dest) {
        this.setDocumentation((ObjectModelElement)dest, source.getDocumentation());
        for (ObjectModelOperation op : source.getOperations()) {
            ObjectModelOperation newOp = this.addOperation((ObjectModelClassifier)dest, op.getName(), op.getReturnType(), new ObjectModelModifier[0]);
            this.setDocumentation((ObjectModelElement)newOp.getReturnParameter(), op.getReturnParameter().getDocumentation());
            for (ObjectModelParameter param : op.getParameters()) {
                ObjectModelParameter newParam = this.addParameter(newOp, param.getType(), param.getName());
                this.setDocumentation((ObjectModelElement)newParam, param.getDocumentation());
            }
            for (String ex : op.getExceptions()) {
                this.addException(newOp, ex);
            }
            this.setDocumentation((ObjectModelElement)newOp, op.getDocumentation());
        }
    }

    public void transformFromInterface(ObjectModelInterface interfacez) {
        if (!interfacez.hasStereotype("service")) {
            return;
        }
        ObjectModelInterface serviceInterface = this.createInterface(interfacez.getName(), interfacez.getPackageName());
        this.copyInterfaceOperations(interfacez, serviceInterface);
        ObjectModelClass service = this.createAbstractClass(this.getServiceAbstractClassName(interfacez.getName()), interfacez.getPackageName());
        this.addInterface((ObjectModelClassifier)service, serviceInterface.getQualifiedName());
        this.addAttribute((ObjectModelClassifier)service, "log", Log.class, null, new ObjectModelModifier[]{ObjectModelModifier.PRIVATE, ObjectModelModifier.FINAL});
        this.addImport((ObjectModelClassifier)service, Log.class);
        this.addImport((ObjectModelClassifier)service, LogFactory.class);
        String contextFqn = this.defaultPackageName + "." + this.getContextImplementorInterfaceName();
        this.addAttribute((ObjectModelClassifier)service, "context", contextFqn, null, new ObjectModelModifier[]{ObjectModelModifier.PROTECTED});
        ObjectModelOperation constructor = this.addConstructor(service, ObjectModelModifier.PUBLIC);
        this.setOperationBody(constructor, "\n        //this.context = context;\n        // FIXME : must be fixed attribute value in EUGene\n        this.log = LogFactory.getLog(" + interfacez.getName() + ".class);\n" + "    ");
        ObjectModelOperation setContext = this.addOperation((ObjectModelClassifier)service, "setContext", "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addParameter(setContext, contextFqn, "context");
        this.setOperationBody(setContext, "\n        this.context = context;\n    ");
        String first = this.modelName.substring(0, 1);
        String serviceName = GeneratorUtil.toLowerCaseFirstLetter((String)interfacez.getName());
        this.addImport((ObjectModelClassifier)service, TopiaContext.class);
        this.addImport((ObjectModelClassifier)service, I18n.class);
        this.addImport((ObjectModelClassifier)service, ArrayList.class);
        for (ObjectModelOperation op : interfacez.getOperations()) {
            boolean needTransaction = true;
            String transactionTag = op.getTagValue("transaction");
            if (transactionTag != null) {
                needTransaction = Boolean.parseBoolean(transactionTag);
            }
            boolean needErrorArgs = true;
            String errorArgsTag = op.getTagValue("errorArgs");
            if (errorArgsTag != null) {
                needErrorArgs = Boolean.parseBoolean(errorArgsTag);
            }
            ObjectModelOperation implOp = this.addOperation((ObjectModelClassifier)service, op.getName(), op.getReturnType(), new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
            this.addAnnotation((ObjectModelClassifier)service, (ObjectModelElement)implOp, Override.class.getSimpleName());
            String opName = StringUtils.capitalize((String)op.getName());
            ObjectModelOperation abstOp = this.addOperation((ObjectModelClassifier)service, "execute" + opName, op.getReturnType(), new ObjectModelModifier[]{ObjectModelModifier.ABSTRACT, ObjectModelModifier.PROTECTED});
            this.addException(abstOp, Exception.class);
            if (needTransaction) {
                this.addParameter(abstOp, TopiaContext.class, "transaction");
                this.addException(abstOp, TopiaException.class);
            }
            String toStringAppend = "";
            String separatorLog = " : ";
            String opParams = "";
            String separatorParams = "";
            if (needErrorArgs) {
                opParams = opParams + "errorArgs";
                separatorParams = ", ";
                this.addParameter(abstOp, "java.util.List<Object>", "errorArgs");
            }
            for (ObjectModelParameter param : op.getParameters()) {
                String paramName = param.getName();
                this.addParameter(implOp, param.getType(), param.getName());
                this.addParameter(abstOp, param.getType(), param.getName());
                toStringAppend = toStringAppend + "\n\t\t\t.append(\"" + separatorLog + paramName + " = \")" + ".append(" + paramName + ")";
                separatorLog = " _ ";
                opParams = opParams + separatorParams + param.getName();
                separatorParams = ", ";
            }
            StringBuilder buffer = new StringBuilder();
            String errorKey = StringUtils.lowerCase((String)this.modelName) + ".error." + serviceName + "." + op.getName();
            String doCatchParams = "eee, I18n.n_(\"" + errorKey + "\")";
            doCatchParams = doCatchParams + (needErrorArgs ? ", errorArgs.toArray()" : "");
            String opReturn = "";
            String finalReturn = "";
            if (!op.getReturnType().equals("void")) {
                opReturn = "return ";
                finalReturn = "return null;";
            }
            if (needErrorArgs) {
                buffer.append("\n        List<Object> errorArgs = new ArrayList<Object>();\n    ");
            }
            if (needTransaction) {
                buffer.append("\n        TopiaContext transaction = null;\n        try {\n            transaction = context.beginTransaction();\n    ");
                opParams = "transaction, " + opParams;
                doCatchParams = "transaction, " + doCatchParams;
            } else {
                buffer.append("\n        try {\n    ");
            }
            buffer.append("\n            if (log.isDebugEnabled()) {\n                String message = new StringBuilder(\"" + first + ":[ " + opName + " ]\")" + toStringAppend + ".\n" + "                    toString();\n" + "                log.debug(message);\n" + "            }\n" + "\n" + "            " + opReturn + "execute" + opName + "(" + opParams + "); ");
            for (String ex : op.getExceptions()) {
                this.addException(implOp, ex);
                this.addException(abstOp, ex);
                String exName = GeneratorUtil.getSimpleName((String)ex);
                buffer.append("\n        } catch (" + exName + " eee) {\n" + "            throw eee; ");
            }
            buffer.append("\n        } catch (Exception eee) {\n            context.doCatch(" + doCatchParams + "); ");
            if (needTransaction) {
                buffer.append("\n        } finally {\n            context.doFinally(transaction); ");
            }
            buffer.append("\n        }\n        " + finalReturn + " \n" + "    ");
            this.setOperationBody(implOp, buffer.toString());
        }
    }
}

