/*
 * *##%
 * ToPIA :: Persistence
 * Copyright (C) 2004 - 2010 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.topia.generator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.Template;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.*;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.util.beans.BinderBuilder;
import org.nuiton.util.beans.BinderProvider;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;


/*{generator option: parentheses = false}*/

/*{generator option: writeString = +}*/

/**
 * A template to generate a helper for {@link TopiaEntityBinder}.
 * 
 * @author tchemit <chemit@codelutin.com>
 * @plexus.component role="org.nuiton.eugene.Template" role-hint="org.nuiton.topia.generator.BinderHelperTransformer"
 * @since 2.3.1
 */
public class BinderHelperTransformer extends ObjectModelTransformerToJava {

    private static final Log log =
            LogFactory.getLog(BinderHelperTransformer.class);

    @Override
    public void transformFromModel(ObjectModel model) {
        ObjectModelClass resultClass;
        String packageName = getOutputProperties().getProperty(Template.PROP_DEFAULT_PACKAGE);
        String modelName = model.getName();
        String binderHelperClazzName = modelName + "BinderHelper";
        String daoHelperClazzName = modelName + "DAOHelper";

        resultClass = createClass(binderHelperClazzName, packageName);

        setSuperClass(resultClass, BinderProvider.class);

        List<ObjectModelClass> classes = TopiaGeneratorUtil.getEntityClasses(model, true);

        addImport(resultClass, TopiaEntityBinder.class);
        addImport(resultClass, TopiaEntityHelper.class);
        addImport(resultClass, TopiaEntity.class);
        addImport(resultClass, BinderBuilder.class);

        ObjectModelOperation op;

        op = addOperation(resultClass,
                          "getTopiaBinder",
                          "<E extends TopiaEntity> TopiaEntityBinder<E>",
                          ObjectModelModifier.PUBLIC,
                          ObjectModelModifier.STATIC);
        addParameter(op, "Class<E>", "entityClass");
        addParameter(op, "String", "contextName");
        setOperationBody(op, ""
/*{
        return (TopiaEntityBinder<E>) getBinder(entityClass, contextName);
    }*/
        );

        op = addOperation(resultClass,
                          "getSimpleTopiaBinder",
                          "<E extends TopiaEntity> TopiaEntityBinder<E>",
                          ObjectModelModifier.PUBLIC,
                          ObjectModelModifier.STATIC);
        addParameter(op, "Class<E>", "entityClass");
        setOperationBody(op, ""
/*{
        return getTopiaBinder(entityClass, "<%=modelName%>");
    }*/
        );

        op = addOperation(resultClass,
                          "registerTopiaBinder",
                          "void",
                          ObjectModelModifier.PUBLIC,
                          ObjectModelModifier.STATIC);
        addParameter(op, "BinderBuilder", "builder");
        addParameter(op, "String", "contextName");
        setOperationBody(op, ""
/*{
       BinderProvider.registerBinder(builder, TopiaEntityBinder.class, contextName);
    }*/
        );

        op = addOperation(resultClass,
                          "copy",
                          "<E extends TopiaEntity> void",
                          ObjectModelModifier.PUBLIC,
                          ObjectModelModifier.STATIC);
        addParameter(op, "String", "contextName");
        addParameter(op, "E", "source");
        addParameter(op, "E", "target");
        addParameter(op, "boolean", "tech");
        setOperationBody(op, ""
/*{
        Class<E> entityClass = (Class<E>) TopiaEntityHelper.getContractClass(<%=daoHelperClazzName%>.getContracts(), target.getClass());
        TopiaEntityBinder<E> binder = getTopiaBinder(entityClass, contextName);
        if (binder == null) {
            throw new NullPointerException("could not find a simple topia binder of type : " + target.getClass());
        }
        binder.load(source, target, tech);
    }*/
        );

        op = addOperation(resultClass,
                          "simpleCopy",
                          "<E extends TopiaEntity> void",
                          ObjectModelModifier.PUBLIC,
                          ObjectModelModifier.STATIC);
        addParameter(op, "E", "source");
        addParameter(op, "E", "target");
        addParameter(op, "boolean", "tech");
        setOperationBody(op, ""
/*{
        Class<E> entityClass = (Class<E>) TopiaEntityHelper.getContractClass(<%=daoHelperClazzName%>.getContracts(), target.getClass());
        TopiaEntityBinder<E> binder = getSimpleTopiaBinder(entityClass);
        if (binder == null) {
            throw new NullPointerException("could not find a simple topia binder of type : " + target.getClass());
        }
        binder.load(source, target, tech);
    }*/
        );

        StringBuilder initCode = new StringBuilder();

        initCode.append(""
/*{
         BinderBuilder builder = new BinderBuilder();
}*/
        );
        for (ObjectModelClass clazz : classes) {

            generateBinder(modelName, clazz, resultClass, initCode);

        }

        op = addOperation(resultClass, "initBinders", "void", ObjectModelModifier.PROTECTED, ObjectModelModifier.STATIC);
        setOperationBody(op, initCode.toString());

        op = addOperation(resultClass, null, (String) null, ObjectModelModifier.STATIC);
        setOperationBody(op, ""
 /*{
    initBinders();
}*/
        );
    }

    protected void generateBinder(String modelName, ObjectModelClass clazz, ObjectModelClass resultClass, StringBuilder initCode) {

        List<ObjectModelAttribute> list = new ArrayList<ObjectModelAttribute>();
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.isNavigable()) {
                continue;
            }

            if (GeneratorUtil.isNMultiplicity(attr)) {
                // not dealing with association
                continue;
            }

            list.add(attr);
        }

        String clazzName = clazz.getName();

        if (list.isEmpty()) {
            // no attribute, do nothing
            if (log.isDebugEnabled()) {
                log.debug("no attribute to add in a binder for " + clazzName +
                          ", will not generate it.");
            }
            return;
        }


        if (log.isDebugEnabled()) {
            log.debug("generate simple binder for " + clazzName);
        }
        addImport(resultClass, clazz);
        initCode.append(""
/*{
        builder.createBinderModel(<%=clazzName%>.class);
        builder.addSimpleProperties(
}*/
        );
        Iterator<ObjectModelAttribute> itr = list.iterator();
        while (itr.hasNext()) {
            ObjectModelAttribute attr = itr.next();
            String attrName = attr.getName();
            boolean hasNext = itr.hasNext();
            initCode.append(""
/*{            <%=clazzName%>.<%=getConstantName(attrName)%><%=(hasNext?",\n":"")%>}*/
            );
        }
        initCode.append(""
/*{
        );
        registerTopiaBinder(builder, "<%=modelName%>");
    }*/
        );
    }
}

