package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class CompanyDAOAbstract<E extends Company> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Company.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
                {
                List<Department> list = getContext()
                            .getDAO(Department.class)
                            .findAllByProperties(Department.COMPANY, entity);
//                            .findAllByProperties("company", entity);
                    for (Department item : list) {
                        item.setCompany(null);

                    }
                }

        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Company.NAME, v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Company.NAME, v);
        return result;
    }

    /**
     * findBySiret :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut siret le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findBySiret(int v) throws TopiaException {
        E result = findByProperty(Company.SIRET, v);
        return result;
    }

    /**
     * findAllBySiret :
     * Retourne les éléments ayant comme valeur pour l'attribut siret le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllBySiret(int v) throws TopiaException {
        List<E> result = findAllByProperty(Company.SIRET, v);
        return result;
    }

    /**
     * findContainsEmploye :
     * Retourne le premier élément trouvé dont l'attribut employe contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsEmploye(Employe... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //E  result = findContainsProperties(Company.EMPLOYE, Arrays.asList(v));
        E result = findContainsProperties("employe", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsEmploye :
     * Retourne les éléments trouvé dont l'attribut employe contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsEmploye(Employe... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //List<E> results = findAllContainsProperties(Company.EMPLOYE, Arrays.asList(v));
        List<E> results = findAllContainsProperties("employe", Arrays.asList(v));
        return results;
    }

    /**
     * findContainsStore :
     * Retourne le premier élément trouvé dont l'attribut store contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsStore(Store... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //E  result = findContainsProperties(Company.STORE, Arrays.asList(v));
        E result = findContainsProperties("store", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsStore :
     * Retourne les éléments trouvé dont l'attribut store contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsStore(Store... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //List<E> results = findAllContainsProperties(Company.STORE, Arrays.asList(v));
        List<E> results = findAllContainsProperties("store", Arrays.asList(v));
        return results;
    }

    /**
     * findContainsDepartment :
     * Retourne le premier élément trouvé dont l'attribut department contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsDepartment(Department... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //E  result = findContainsProperties(Company.DEPARTMENT, Arrays.asList(v));
        E result = findContainsProperties("department", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsDepartment :
     * Retourne les éléments trouvé dont l'attribut department contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsDepartment(Department... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //List<E> results = findAllContainsProperties(Company.DEPARTMENT, Arrays.asList(v));
        List<E> results = findAllContainsProperties("department", Arrays.asList(v));
        return results;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Department.class) {
            DepartmentDAO dao = (DepartmentDAO)
                getContext().getDAO(Department.class);
            tmp = dao.findAllByCompany(entity);
//            tmp = dao.findAllByProperties(Department.COMPANY, entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<?>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<?>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<?>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<?>, List<? extends TopiaEntity>>(1);
        
        List<? extends TopiaEntity> list;

        list = findUsages(Department.class, entity);
        if (!list.isEmpty()) {
            result.put(Department.class, list);
        }

        return result;
    }


} //CompanyDAOAbstract<E extends Company>
