/* *##% 
 * ToPIA :: Persistence
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*/




/* *
* EntityAbstractGenerator.java
*
* Created: 12 déc. 2005
*
* @author Arnaud Thimel <thimel@codelutin.com>
* @version $Revision: 1732 $
*
* Mise a jour: $Date: 2009-12-20 17:29:38 +0100 (dim., 20 déc. 2009) $
* par : $Author: tchemit $
*/

package org.nuiton.topia.generator;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.models.object.ObjectModelGenerator;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import static org.nuiton.topia.generator.TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType;
import static org.nuiton.topia.generator.TopiaGeneratorUtil.shouldBeAbstract;
import static org.nuiton.topia.generator.TopiaGeneratorUtil.isPrimitiveType;
import static org.nuiton.topia.generator.TopiaGeneratorUtil.isDateType;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;


/**
 * Generateur d'entites abstraites. Il s'agit de l'implatation par defaut d'une
 * entite. Les classes generees sont surchargees par un XXXImpl lorsque l'entite
 * n'est pas abstraite. La surcharge peut etre ecrite par l'utilisateur.
 *
 * @deprecated since 2.3.0, prefer use the corresponding {@link org.nuiton.eugene.Transformer} :
 * {@link EntityAbstractTransformer}.
 * @plexus.component role="org.nuiton.eugene.Template" role-hint="org.nuiton.topia.generator.EntityAbstractGenerator" 
 */
@Deprecated
public class EntityAbstractGenerator extends ObjectModelGenerator {

    /** Logger for this class */
    private static final Log log = LogFactory.getLog(EntityAbstractGenerator.class);

    // TODO THIMEL : Je pense qu'il faudrait que l'EntityInterfaceGenerator 
    // hérite de ce générateur, avec generateBody qui renvoie false, et que dans
    // ce générateur, on ne génère pas les corps de méthode, etc ... quand 
    // generateBoody() renvoie false 
    protected boolean generateBody() {
    	return true;
    }

    @Override
    public String getFilenameForClass(ObjectModelClass clazz) {
        return clazz.getQualifiedName().replace('.', File.separatorChar) + "Abstract.java";
    }

    @Override
    public void generateFromClass(Writer output, ObjectModelClass clazz) throws IOException {
        if (!clazz.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY)) {
            return;
        }
        String copyright = TopiaGeneratorUtil.getCopyright(model);
        if (TopiaGeneratorUtil.notEmpty(copyright)) {
output.write(""+copyright+"\n");
output.write("");
        }
        String clazzName = clazz.getName();
        String clazzFQN = TopiaGeneratorUtil.getSimpleName(clazz.getQualifiedName());
output.write("package "+clazz.getPackageName()+";\n");
output.write("");
        List<String> imports = TopiaGeneratorUtil.getImports(clazz,
                org.apache.commons.lang.builder.ToStringBuilder.class.getName(),
                org.nuiton.topia.TopiaException.class.getName(),
                org.nuiton.topia.framework.TopiaContextImplementor.class.getName(),
                org.nuiton.topia.persistence.TopiaEntity.class.getName(),
                TopiaEntityAbstract.class.getName(),
                org.nuiton.topia.persistence.EntityVisitor.class.getName(),
                java.util.List.class.getName(),
                java.util.ArrayList.class.getName(),
                java.io.Serializable.class.getName()
        );
        if (log.isDebugEnabled()) {
            log.debug("imports for class <" + clazzFQN + ">");
        }
        for (String anImport : imports) {
            if (log.isDebugEnabled()) {
                log.debug("import " + anImport);
            }
output.write("import "+anImport+";\n");
output.write("");
        }
output.write("\n");
output.write("/**\n");
output.write(" * Implantation POJO pour l'entité {@link "+StringUtils.capitalize(clazzFQN)+"}.\n");
output.write("");
        {
            String dbName = clazz.getTagValue(TopiaGeneratorUtil.TAG_DB_NAME);
            if (dbName != null) {
output.write(" *\n");
output.write(" * <p>Nom de l'entité en BD : "+dbName+".</p>               \n");
output.write("");
            }
        }
output.write(" */\n");
output.write("");
        String extendClass = "";
        for (Iterator<ObjectModelClass> i = clazz.getSuperclasses().iterator(); i.hasNext();) {
            ObjectModelClass parent = i.next();
            extendClass += parent.getQualifiedName();
            //Si une des classes parentes définies des méthodes abstraites, son
            // impl ne sera pas créé
            boolean abstractParent = false;
            if (parent instanceof ObjectModelClass) {
                abstractParent = shouldBeAbstract(parent);
            }
            if (parent.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY)) {
                if (abstractParent) {
                    extendClass += "Abstract";
                } else {
                    extendClass += "Impl";
                }
            }
            if (i.hasNext()) {
                extendClass += ", ";
            }
        }
        if (extendClass.length() == 0) {
            extendClass += TopiaEntityAbstract.class.getSimpleName();
        }

output.write("public abstract class "+clazzName+"Abstract extends "+extendClass+" implements "+clazzName+" {\n");
output.write("\n");
output.write("");

        String svUID = TopiaGeneratorUtil.findTagValue("serialVersionUID", clazz, model);
        if (svUID != null) {
output.write("    public static final long serialVersionUID = "+svUID+";\n");
output.write("\n");
output.write("");
        }
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            ObjectModelAttribute reverse = attr.getReverseAttribute();

            // pour les asso quoi qu'il arrive il faut les lier des 2 cotes
            // pour pouvoir supprimer en cascade l'asso lors de la suppression
            // d'un des cotes
            if (!(attr.isNavigable()
                    || hasUnidirectionalRelationOnAbstractType(reverse, model)
                    || attr.hasAssociationClass())) {
                continue;
            }
            if (TopiaGeneratorUtil.hasDocumentation(attr) || attr.hasTagValue(TopiaGeneratorUtil.TAG_DB_NAME)) {
output.write("    /**\n");
output.write("");
                if (TopiaGeneratorUtil.hasDocumentation(attr)) {
                	String attrDocumentation = attr.getDocumentation();
output.write("     * "+attrDocumentation+"\n");
output.write("");
                }
                if (attr.hasTagValue(TopiaGeneratorUtil.TAG_DB_NAME)) {
                	String dbName = attr.getTagValue(TopiaGeneratorUtil.TAG_DB_NAME);
output.write("     * Nom de l'attribut en BD : "+dbName+".\n");
output.write("");
                }
output.write("    */\n");
output.write("");
            }
            if (attr.hasTagValue(TopiaGeneratorUtil.TAG_ANNOTATION)) {
            	String annotation = attr.getTagValue(TopiaGeneratorUtil.TAG_ANNOTATION);
output.write("    "+annotation+"\n");
output.write("");
            }

            String attrVisibility = attr.getVisibility();

            // In case attribute is NMultiplicity
            String collectionType = TopiaGeneratorUtil.getSimpleName(TopiaGeneratorUtil.getNMultiplicityInterfaceType(attr));

            if (!attr.hasAssociationClass()) {
                String attrName = attr.getName();
                String attrType = TopiaGeneratorUtil.getSimpleName(attr.getType());
                if (!GeneratorUtil.isNMultiplicity(attr)) {
output.write("    "+attrVisibility+" "+attrType+" "+attrName+";\n");
output.write("\n");
output.write("");
                } else {
output.write("    "+attrVisibility+" "+collectionType+"<"+attrType+"> "+attrName+";\n");
output.write("\n");
output.write("");
                }
            } else {
                String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                String assocClassFQN = TopiaGeneratorUtil.getSimpleName(attr.getAssociationClass().getQualifiedName());
                if (!GeneratorUtil.isNMultiplicity(attr)) {
                	//TODO THIMEL : Je pense que les GeneratorUtil.toLowerCaseFirstLetter sont inutiles ici, ou alors il faudrait le faire partout
output.write("    "+attrVisibility+" "+assocClassFQN+" "+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+";\n");
output.write("\n");
output.write("");
                } else {
output.write("    "+attrVisibility+" "+collectionType+"<"+assocClassFQN+"> "+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+";\n");
output.write("\n");
output.write("");
                }
            }
        }

        //Déclaration des attributs d'une classe d'associations
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass) clazz;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr != null) {
                    String attrVisibility = attr.getVisibility();
                    String attrType = TopiaGeneratorUtil.getSimpleName(attr.getType());
                    String attrName = attr.getName();
output.write("    "+attrVisibility+" "+attrType+" "+GeneratorUtil.toLowerCaseFirstLetter(attrName)+";\n");
output.write("\n");
output.write("");
                }
            }
        }

output.write("    /**\n");
output.write("     * Constructeur de "+clazzName+"Abstract par défaut.\n");
output.write("     */\n");
output.write("    public "+clazzName+"Abstract() {\n");
output.write("    }\n");
output.write("\n");
output.write("    @Override\n");
output.write("    public void update() throws TopiaException {\n");
output.write("        ((TopiaContextImplementor)getTopiaContext()).getDAO("+clazzName+".class).update(this);\n");
output.write("    }\n");
output.write("\n");
output.write("    @Override\n");
output.write("    public void delete() throws TopiaException {\n");
output.write("        ((TopiaContextImplementor)getTopiaContext()).getDAO("+clazzName+".class).delete(this);\n");
output.write("    }\n");
output.write("\n");
output.write("    /**\n");
output.write("     * Envoi via les methodes du visitor l'ensemble des champs de l'entity\n");
output.write("     * avec leur nom, type et valeur.\n");
output.write("     *\n");
output.write("     * @param visitor le visiteur de l'entite.\n");
output.write("     *\n");
output.write("     * @throws TopiaException if any pb while visit \n");
output.write("     */\n");
output.write("    @Override\n");
output.write("    public void accept(EntityVisitor visitor) throws TopiaException {\n");
output.write("        visitor.start(this);\n");
output.write("");

        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            ObjectModelAttribute reverse = attr.getReverseAttribute();

            // pour les asso quoi qu'il arrive il faut les lier des 2 cotes
            // pour pouvoir supprimer en cascade l'asso lors de la suppression
            // d'un des cotes
            if (!(attr.isNavigable()
                    || hasUnidirectionalRelationOnAbstractType(reverse, model)
                    || attr.hasAssociationClass())) {
                continue;
            }

            if (!attr.hasAssociationClass()) {
            	String attrType = TopiaGeneratorUtil.getSimpleName(attr.getType());
            	String attrName = attr.getName();
                if (!GeneratorUtil.isNMultiplicity(attr)) {
output.write("        visitor.visit(this, \""+attrName+"\", "+attrType+".class, "+attrName+");\n");
output.write("");
                } else {
                    String collectionType = TopiaGeneratorUtil.getSimpleName(TopiaGeneratorUtil.getNMultiplicityInterfaceType(attr));
output.write("        visitor.visit(this, \""+attrName+"\", "+collectionType+".class, "+attrType+".class, "+attrName+");\n");
output.write("");
                }
            } else {
                String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                assocAttrName = GeneratorUtil.toLowerCaseFirstLetter(assocAttrName);
                String assocClassFQN = TopiaGeneratorUtil.getSimpleName(attr.getAssociationClass().getQualifiedName());
                if (!GeneratorUtil.isNMultiplicity(attr)) {
output.write("        visitor.visit(this, \""+assocAttrName+"\", "+assocClassFQN+".class, "+assocAttrName+");\n");
output.write("");
                } else {
                    String collectionType = TopiaGeneratorUtil.getNMultiplicityInterfaceType(attr);
output.write("        visitor.visit(this, \""+assocAttrName+"\", "+collectionType+".class, "+assocClassFQN+".class, "+assocAttrName+");\n");
output.write("");
                }
            }
        }

        //Déclaration des attributs d'une classe d'associations
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass) clazz;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr != null) {
                	String attrType = TopiaGeneratorUtil.getSimpleName(attr.getType());
                	String attrName = attr.getName();
                        attrName = GeneratorUtil.toLowerCaseFirstLetter(attrName);
output.write("        visitor.visit(this, \""+attrName+"\", "+attrType+".class, "+attrName+");\n");
output.write("");
                }
            }
        }
output.write("        visitor.end(this);\n");
output.write("    }\n");
output.write("\n");
output.write("    @Override\n");
output.write("    public List<TopiaEntity> getAggregate() throws TopiaException {\n");
output.write("        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();\n");
output.write("\n");
output.write("        // pour tous les attributs rechecher les composites et les class d'asso\n");
output.write("        // on les ajoute dans tmp\n");
output.write("");
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (attr.referenceClassifier() && attr.getClassifier().hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY)) {
                if (attr.isAggregate()) {
                	String attrName = attr.getName();
                        String getterName  = "get" + StringUtils.capitalize(attrName);
                    if (GeneratorUtil.isNMultiplicity(attr)) {
output.write("        tmp.addAll("+getterName+"());\n");
output.write("");
                    } else {
output.write("        tmp.add("+getterName+"());\n");
output.write("");
                    }
                }
            }
        }
output.write("\n");
output.write("        // on refait un tour sur chaque entity de tmp pour recuperer leur \n");
output.write("        // composite\n");
output.write("        List<TopiaEntity> result = new ArrayList<TopiaEntity>();\n");
output.write("        for (TopiaEntity entity : tmp) {\n");
output.write("            result.add(entity);\n");
output.write("            result.addAll(entity.getAggregate());\n");
output.write("        }\n");
output.write("\n");
output.write("        return result;\n");
output.write("    }\n");
output.write("\n");
output.write("    @Override\n");
output.write("    public List<TopiaEntity> getComposite() throws TopiaException {\n");
output.write("        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();\n");
output.write("\n");
output.write("        // pour tous les attributs rechecher les composites et les class d'asso\n");
output.write("        // on les ajoute dans tmp\n");
output.write("");
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (attr.referenceClassifier() && attr.getClassifier().hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY)) {
                if (attr.isComposite()) {
                    String attrName = attr.getName();
                    String getterName  = "get" + StringUtils.capitalize(attrName);
                    if (GeneratorUtil.isNMultiplicity(attr)) {
output.write("        if ("+getterName+"() != null) {\n");
output.write("              tmp.addAll("+getterName+"());\n");
output.write("           }\n");
output.write("");
                    } else {
output.write("        tmp.add("+getterName+"());\n");
output.write("");
                    }
                } else if (attr.hasAssociationClass()) {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                    String assocClassFQN = TopiaGeneratorUtil.getSimpleName(attr.getAssociationClass().getQualifiedName());
                    String ref = "this." + GeneratorUtil.toLowerCaseFirstLetter(assocAttrName);
                    if (!GeneratorUtil.isNMultiplicity(attr)) {
output.write("\n");
output.write("        if ("+ref+" != null) {\n");
output.write("            tmp.add("+ref+");\n");
output.write("        }\n");
output.write("");
                    } else {
                    	ObjectModelAttribute reverse = attr.getReverseAttribute();
                    	String reverseAttrName = reverse.getName();
                        // On utilise pas l'attribut car il est potentiellement
                        // pas a jour, car  pour les asso avec cardinalité
                        // personne ne fait de add. Ce qui est normal, mais
                        // pour pouvoir faire tout de meme des delete en cascade
                        // sur les asso, le champs est dans le mapping
                        // hibernate et donc il le faut aussi dans la classe
                        // sinon hibernate rale lorsqu'il charge l'objet
//                        if (<%=ref%> != null) {
//                            tmp.addAll(<%=ref%>);
//                        }
output.write("\n");
output.write("        {\n");
output.write("            org.nuiton.topia.persistence.TopiaDAO<"+assocClassFQN+"> dao = ((TopiaContextImplementor) getTopiaContext()).getDAO("+assocClassFQN+".class);\n");
output.write("            List<"+assocClassFQN+"> findAllByProperties = dao.findAllByProperties(\""+reverseAttrName+"\", this);\n");
output.write("            if (findAllByProperties != null) {\n");
output.write("                tmp.addAll(findAllByProperties);\n");
output.write("            }\n");
output.write("        }\n");
output.write("");
                    }
                }
            }
        }
output.write("\n");
output.write("        // on refait un tour sur chaque entity de tmp pour recuperer leur \n");
output.write("        // composite\n");
output.write("        List<TopiaEntity> result = new ArrayList<TopiaEntity>();\n");
output.write("        for (TopiaEntity entity : tmp) {\n");
output.write("            if (entity != null) { \n");
output.write("                result.add(entity);\n");
output.write("                result.addAll(entity.getComposite());\n");
output.write("            }\n");
output.write("        }\n");
output.write("        \n");
output.write("        return result;\n");
output.write("    }\n");
output.write("\n");
output.write("");

        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            ObjectModelAttribute reverse = attr.getReverseAttribute();

            String attrName = attr.getName();
            String attrType = TopiaGeneratorUtil.getSimpleName(attr.getType());

            if (!(attr.isNavigable()
                    || hasUnidirectionalRelationOnAbstractType(reverse, model))) {
                continue;
            }
            if (!GeneratorUtil.isNMultiplicity(attr)) {
                if (!attr.hasAssociationClass()) {
output.write("    /* (non-Javadoc)\n");
output.write("     * @see "+clazzFQN+"#set"+StringUtils.capitalize(attrName)+"("+attrType+")\n");
output.write("     */\n");
output.write("    @Override\n");
output.write("    public void set"+StringUtils.capitalize(attrName)+"("+attrType+" value) {\n");
output.write("        "+attrType+" _oldValue = this."+attrName+";\n");
output.write("        fireOnPreWrite(\""+attrName+"\", _oldValue, value);\n");
output.write("        this."+attrName+" = value;\n");
output.write("        fireOnPostWrite(\""+attrName+"\", _oldValue, value);\n");
output.write("    }\n");
output.write("\n");
output.write("    /* (non-Javadoc)\n");
output.write("     * @see "+clazzFQN+"#get"+StringUtils.capitalize(attrName)+"()\n");
output.write("     */\n");
output.write("    @Override\n");
output.write("    public "+attrType+" get"+StringUtils.capitalize(attrName)+"() {\n");
output.write("        fireOnPreRead(\""+attrName+"\", "+attrName+");\n");
output.write("        "+attrType+" result = this."+attrName+";\n");
output.write("        fireOnPostRead(\""+attrName+"\", "+attrName+");\n");
output.write("        return result;\n");
output.write("    }\n");
output.write("\n");
output.write("");
                } else {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                    String assocClassFQN = TopiaGeneratorUtil.getSimpleName(attr.getAssociationClass().getQualifiedName());
output.write("    /* (non-Javadoc)\n");
output.write("     * @see "+clazzFQN+"#set"+StringUtils.capitalize(assocAttrName)+"("+assocClassFQN+")\n");
output.write("     */\n");
output.write("    @Override\n");
output.write("    public void set"+StringUtils.capitalize(assocAttrName)+"("+assocClassFQN+" association) {\n");
output.write("        "+assocClassFQN+" _oldValue = this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+";\n");
output.write("        fireOnPreWrite(\""+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+"\", _oldValue, association);\n");
output.write("        this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+" = association;\n");
output.write("        fireOnPostWrite(\""+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+"\", _oldValue, association);\n");
output.write("    }\n");
output.write("\n");
output.write("    /* (non-Javadoc)\n");
output.write("     * @see "+clazzFQN+"#get"+StringUtils.capitalize(assocAttrName)+"()\n");
output.write("     */\n");
output.write("    @Override\n");
output.write("    public "+assocClassFQN+" get"+StringUtils.capitalize(assocAttrName)+"() {\n");
output.write("        return "+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+";\n");
output.write("    }\n");
output.write("\n");
output.write("");
                }
            } else { //NMultiplicity
                String collectionInterface = TopiaGeneratorUtil.getSimpleName(TopiaGeneratorUtil.getNMultiplicityInterfaceType(attr));
                String collectionObject = TopiaGeneratorUtil.getSimpleName(TopiaGeneratorUtil.getNMultiplicityObjectType(attr));
                if (!attr.hasAssociationClass()) { //Méthodes remplacées par des accesseurs sur les classes d'assoc
output.write("    /* (non-Javadoc)\n");
output.write("     * @see "+clazzFQN+"#add"+StringUtils.capitalize(attrName)+"("+attrType+")\n");
output.write("     */\n");
output.write("    @Override\n");
output.write("    public void add"+StringUtils.capitalize(attrName)+"("+attrType+" "+attrName+") {\n");
output.write("        fireOnPreWrite(\""+attrName+"\", null, "+attrName+");\n");
output.write("        if (this."+attrName+" == null) {\n");
output.write("            this."+attrName+" = new "+collectionObject+"<"+attrType+">();\n");
output.write("        }\n");
output.write("");
                    if (reverse != null && (reverse.isNavigable() ||
                            hasUnidirectionalRelationOnAbstractType(attr, model))) {
                    	String reverseAttrName = reverse.getName();
                    	String reverseAttrType = TopiaGeneratorUtil.getSimpleName(reverse.getType());
                        if (!GeneratorUtil.isNMultiplicity(reverse)) {
output.write("        "+attrName+".set"+StringUtils.capitalize(reverseAttrName)+"(this);\n");
output.write("");
                        } else {
output.write("        if ("+attrName+".get"+StringUtils.capitalize(reverseAttrName)+"() == null) {\n");
output.write("            "+attrName+".set"+StringUtils.capitalize(reverseAttrName)+"(new "+collectionObject+"<"+reverseAttrType+">());\n");
output.write("        }\n");
output.write("        "+attrName+".get"+StringUtils.capitalize(reverseAttrName)+"().add(this);\n");
output.write("");
                        }
                    }
output.write("        this."+attrName+".add("+attrName+");\n");
output.write("        fireOnPostWrite(\""+attrName+"\", this."+attrName+".size(), null, "+attrName+");\n");
output.write("    }\n");
output.write("\n");
output.write("    /* (non-Javadoc)\n");
output.write("     * @see "+clazzFQN+"#addAll"+StringUtils.capitalize(attrName)+"("+collectionInterface+"<"+attrType+">)\n");
output.write("     */\n");
output.write("    @Override\n");
output.write("    public void addAll"+StringUtils.capitalize(attrName)+"("+collectionInterface+"<"+attrType+"> values) {\n");
output.write("        if (values == null) {\n");
output.write("            return;\n");
output.write("        }\n");
output.write("        for ("+attrType+" item : values) {\n");
output.write("            add"+StringUtils.capitalize(attrName)+"(item);\n");
output.write("        }\n");
output.write("    }\n");
output.write("");
                    if (!isPrimitiveType(attr) && !isDateType(attr)) {
output.write("\n");
output.write("    /* (non-Javadoc)\n");
output.write("     * @see "+clazzFQN+"#get"+StringUtils.capitalize(attrName)+"ByTopiaId(String)\n");
output.write("     */\n");
output.write("    @Override\n");
output.write("    public "+attrType+" get"+StringUtils.capitalize(attrName)+"ByTopiaId(String topiaId) {\n");
output.write("        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId("+attrName+", topiaId);\n");
output.write("    }\n");
output.write(" ");
                    }
output.write("\n");
output.write("    /* (non-Javadoc)\n");
output.write("     * @see "+clazzFQN+"#set"+StringUtils.capitalize(attrName)+"("+collectionInterface+"<"+attrType+">)\n");
output.write("     */\n");
output.write("    @Override\n");
output.write("    public void set"+StringUtils.capitalize(attrName)+"("+collectionInterface+"<"+attrType+"> values) {\n");
output.write("        "+collectionInterface+"<"+attrType+"> _oldValue = "+attrName+";\n");
output.write("        fireOnPreWrite(\""+attrName+"\", _oldValue, values);\n");
output.write("        "+attrName+" = values;\n");
output.write("        fireOnPostWrite(\""+attrName+"\", _oldValue, values);\n");
output.write("    }\n");
output.write("\n");
output.write("    /* (non-Javadoc)\n");
output.write("     * @see "+clazzFQN+"#remove"+StringUtils.capitalize(attrName)+"("+attrType+")\n");
output.write("     */\n");
output.write("    @Override\n");
output.write("    public void remove"+StringUtils.capitalize(attrName)+"("+attrType+" value) {\n");
output.write("        fireOnPreWrite(\""+attrName+"\", value, null);\n");
output.write("        if ((this."+attrName+" == null) || (!this."+attrName+".remove(value))) {\n");
output.write("            throw new IllegalArgumentException(\"List does not contain given element\");\n");
output.write("        }\n");
output.write("");
                    if (reverse != null && (reverse.isNavigable() ||
                            hasUnidirectionalRelationOnAbstractType(attr, model))) {
                    	String reverseAttrName = reverse.getName();
                        if (!GeneratorUtil.isNMultiplicity(reverse)) {
output.write("        value.set"+StringUtils.capitalize(reverseAttrName)+"(null);\n");
output.write("");
                        } else {
output.write("        value.get"+StringUtils.capitalize(reverseAttrName)+"().remove(this);\n");
output.write("");
                        }
                    }
output.write("        fireOnPostWrite(\""+attrName+"\", this."+attrName+".size()+1, value, null);\n");
output.write("    }\n");
output.write("\n");
output.write("    /* (non-Javadoc)\n");
output.write("     * @see "+clazzFQN+"#clear"+StringUtils.capitalize(attrName)+"()\n");
output.write("     */\n");
output.write("    @Override\n");
output.write("    public void clear"+StringUtils.capitalize(attrName)+"() {\n");
output.write("        if (this."+attrName+" == null) {\n");
output.write("            return;\n");
output.write("        }\n");
output.write("");
                    if (reverse != null && (reverse.isNavigable() ||
                            hasUnidirectionalRelationOnAbstractType(attr, model))) {
                    	String reverseAttrName = reverse.getName();
output.write("        for ("+attrType+" item : this."+attrName+") {\n");
output.write("");
                        if (!GeneratorUtil.isNMultiplicity(reverse)) {
output.write("            item.set"+StringUtils.capitalize(reverseAttrName)+"(null);\n");
output.write("");
                        } else {
output.write("            item.get"+StringUtils.capitalize(reverseAttrName)+"().remove(this);\n");
output.write("");
                        }
output.write("        }\n");
output.write("");
                    }
output.write("        "+collectionInterface+"<"+attrType+"> _oldValue = new "+collectionObject+"<"+attrType+">(this."+attrName+");\n");
output.write("        fireOnPreWrite(\""+attrName+"\", _oldValue, this."+attrName+");\n");
output.write("        this."+attrName+".clear();\n");
output.write("        fireOnPostWrite(\""+attrName+"\", _oldValue, this."+attrName+");\n");
output.write("    }\n");
output.write("\n");
output.write("");
                } else {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                    String assocClassFQN = TopiaGeneratorUtil.getSimpleName(attr.getAssociationClass().getQualifiedName());
output.write("    /* (non-Javadoc)\n");
output.write("     * @see "+clazzFQN+"#add"+StringUtils.capitalize(assocAttrName)+"("+assocClassFQN+")\n");
output.write("     */\n");
output.write("    @Override\n");
output.write("    public void add"+StringUtils.capitalize(assocAttrName)+"("+assocClassFQN+" value) {\n");
output.write("        fireOnPreWrite(\""+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+"\", null, value);\n");
output.write("        if (this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+" == null) {\n");
output.write("            this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+" = new "+collectionObject+"<"+assocClassFQN+">();\n");
output.write("        }\n");
output.write("");
                    if (reverse != null && (reverse.isNavigable() ||
                            hasUnidirectionalRelationOnAbstractType(attr, model))) {
                    	String reverseAttrName = reverse.getName();
output.write("        value.set"+StringUtils.capitalize(reverseAttrName)+"(this);\n");
output.write("");
                    }
output.write("        this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+".add(value);\n");
output.write("        fireOnPostWrite(\""+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+"\", this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+".size(), null, value);\n");
output.write("    }\n");
output.write("");
                    if (!isPrimitiveType(attr) && !isDateType(attr)) {
output.write("\n");
output.write("    /* (non-Javadoc)\n");
output.write("     * @see "+clazzFQN+"#get"+StringUtils.capitalize(attrName)+"ByTopiaId(String)\n");
output.write("     */\n");
output.write("    @Override\n");
output.write("    public "+assocClassFQN+" get"+StringUtils.capitalize(assocAttrName)+"ByTopiaId(String topiaId) {\n");
output.write("        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId("+assocAttrName+", topiaId);\n");
output.write("    }\n");
output.write("");
                    }
output.write("\n");
output.write("    /* (non-Javadoc)\n");
output.write("     * @see "+clazzFQN+"#addAll"+StringUtils.capitalize(assocAttrName)+"("+collectionInterface+"<"+assocClassFQN+">()\n");
output.write("     */\n");
output.write("    @Override\n");
output.write("    public void addAll"+StringUtils.capitalize(assocAttrName)+"("+collectionInterface+"<"+assocClassFQN+"> values) {\n");
output.write("        if (values == null) {\n");
output.write("            return;\n");
output.write("        }\n");
output.write("        for ("+assocClassFQN+" item : values) {\n");
output.write("            add"+StringUtils.capitalize(assocAttrName)+"(item);\n");
output.write("        }\n");
output.write("    }\n");
output.write("\n");
output.write("    /* (non-Javadoc)\n");
output.write("     * @see "+clazzFQN+"#set"+StringUtils.capitalize(assocAttrName)+"("+collectionInterface+"<"+assocClassFQN+">()\n");
output.write("     */\n");
output.write("    @Override\n");
output.write("    public void set"+StringUtils.capitalize(assocAttrName)+"("+collectionInterface+"<"+assocClassFQN+"> values) {\n");
output.write("//        clear"+StringUtils.capitalize(assocAttrName)+"();\n");
output.write("//        addAll"+StringUtils.capitalize(assocAttrName)+"(values);\n");
output.write("// FIXME\n");
output.write("        "+collectionInterface+"<"+assocClassFQN+"> _oldValue = "+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+";\n");
output.write("        fireOnPreWrite(\""+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+"\", _oldValue, values);\n");
output.write("        "+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+" = values;\n");
output.write("        fireOnPostWrite(\""+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+"\", _oldValue, values);\n");
output.write("    }\n");
output.write("\n");
output.write("    /* (non-Javadoc)\n");
output.write("     * @see "+clazzFQN+"#remove"+StringUtils.capitalize(assocAttrName)+"("+assocClassFQN+")\n");
output.write("     */\n");
output.write("    @Override\n");
output.write("    public void remove"+StringUtils.capitalize(assocAttrName)+"("+assocClassFQN+" value) {\n");
output.write("        fireOnPreWrite(\""+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+"\", value, null);\n");
output.write("        if ((this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+" == null) || (!this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+".remove(value))) {\n");
output.write("            throw new IllegalArgumentException(\"List does not contain given element\");\n");
output.write("        }\n");
output.write("");
                    if (reverse != null && (reverse.isNavigable() ||
                            hasUnidirectionalRelationOnAbstractType(attr, model))) {
                    	String reverseAttrName = reverse.getName();
output.write("        value.set"+StringUtils.capitalize(reverseAttrName)+"(null);\n");
output.write("");
                    }
output.write("        fireOnPostWrite(\""+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+"\", this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+".size()+1, value, null);\n");
output.write("    }\n");
output.write("\n");
output.write("    /* (non-Javadoc)\n");
output.write("     * @see "+clazzFQN+"#clear"+StringUtils.capitalize(assocAttrName)+"()\n");
output.write("     */\n");
output.write("    @Override\n");
output.write("    public void clear"+StringUtils.capitalize(assocAttrName)+"() {\n");
output.write("        if (this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+" == null) {\n");
output.write("            return;\n");
output.write("        }\n");
output.write("");
                    if (reverse != null && (reverse.isNavigable() ||
                            hasUnidirectionalRelationOnAbstractType(attr, model))) {
                    	String reverseAttrName = reverse.getName();
output.write("        for ("+assocClassFQN+" item : this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+") {\n");
output.write("            item.set"+StringUtils.capitalize(reverseAttrName)+"(null);\n");
output.write("        }\n");
output.write("");
                    }
output.write("        "+collectionInterface+"<"+assocClassFQN+"> _oldValue = new "+collectionObject+"<"+assocClassFQN+">(this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+");\n");
output.write("        fireOnPreWrite(\""+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+"\", _oldValue, null);\n");
output.write("        this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+".clear();\n");
output.write("        fireOnPostWrite(\""+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+"\", _oldValue, null);\n");
output.write("    }\n");
output.write("\n");
output.write("");
                }
                if (!attr.hasAssociationClass()) {
output.write("    /* (non-Javadoc)\n");
output.write("     * @see "+clazzFQN+"#get"+StringUtils.capitalize(attrName)+"()\n");
output.write("     */\n");
output.write("    @Override\n");
output.write("    public "+collectionInterface+"<"+attrType+"> get"+StringUtils.capitalize(attrName)+"() {\n");
output.write("        return "+attrName+";\n");
output.write("    }\n");
output.write("\n");
output.write("    /* (non-Javadoc)\n");
output.write("     * @see "+clazzFQN+"#size"+StringUtils.capitalize(attrName)+"()\n");
output.write("     */\n");
output.write("    @Override\n");
output.write("    public int size"+StringUtils.capitalize(attrName)+"() {\n");
output.write("        if ("+attrName+" == null) {\n");
output.write("            return 0;\n");
output.write("        }\n");
output.write("        return "+attrName+".size();\n");
output.write("    }\n");
output.write("\n");
output.write("    /* (non-Javadoc)\n");
output.write("     * @see "+clazzFQN+"#is"+StringUtils.capitalize(attrName)+"Empty()\n");
output.write("     */\n");
output.write("    @Override\n");
output.write("    public boolean is"+StringUtils.capitalize(attrName)+"Empty() {\n");
output.write("        int size = size"+StringUtils.capitalize(attrName)+"();\n");
output.write("        return size == 0;\n");
output.write("    }\n");
output.write("\n");
output.write("");
                } else {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                    String assocClassFQN = TopiaGeneratorUtil.getSimpleName(attr.getAssociationClass().getQualifiedName());
output.write("    /* (non-Javadoc)\n");
output.write("     * @see "+clazzFQN+"#get"+StringUtils.capitalize(assocAttrName)+"()\n");
output.write("     */\n");
output.write("    @Override\n");
output.write("    public "+collectionInterface+"<"+assocClassFQN+"> get"+StringUtils.capitalize(assocAttrName)+"() {\n");
output.write("        return "+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+";\n");
output.write("    }\n");
output.write("\n");
output.write("    /* (non-Javadoc)\n");
output.write("     * @see "+clazzFQN+"#get"+StringUtils.capitalize(assocAttrName)+"("+attrType+")\n");
output.write("     */\n");
output.write("    @Override\n");
output.write("    public "+assocClassFQN+" get"+StringUtils.capitalize(assocAttrName)+"("+attrType+" value) {\n");
output.write("        if (value == null || "+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+" == null) {\n");
output.write("            return null;\n");
output.write("        }\n");
output.write("        for ("+assocClassFQN+" item : "+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+") {\n");
output.write("            if (value.equals(item.get"+StringUtils.capitalize(attrName)+"())) {\n");
output.write("                return item;\n");
output.write("            }\n");
output.write("        }\n");
output.write("        return null;\n");
output.write("    }\n");
output.write("\n");
output.write("    /* (non-Javadoc)\n");
output.write("     * @see "+clazzFQN+"#size"+StringUtils.capitalize(assocAttrName)+"()\n");
output.write("     */\n");
output.write("    @Override\n");
output.write("    public int size"+StringUtils.capitalize(assocAttrName)+"() {\n");
output.write("        if ("+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+" == null) {\n");
output.write("            return 0;\n");
output.write("        }\n");
output.write("        return "+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+".size();\n");
output.write("    }\n");
output.write("\n");
output.write("    /* (non-Javadoc)\n");
output.write("     * @see "+clazzFQN+"#is"+StringUtils.capitalize(assocAttrName)+"Empty()\n");
output.write("     */\n");
output.write("    @Override\n");
output.write("    public boolean is"+StringUtils.capitalize(assocAttrName)+"Empty() {\n");
output.write("        int size = size"+StringUtils.capitalize(assocAttrName)+"();\n");
output.write("        return size == 0;\n");
output.write("    }\n");
output.write("\n");
output.write("");
                }
            }
        }

        //Méthodes d'accès aux attributs d'une classe d'associations
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass) clazz;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr != null) {
                    String attrType = TopiaGeneratorUtil.getSimpleName(attr.getType());
                    String attrName = attr.getName();
                    generateAssociationAccessors(output, attrName, attrType);
//                   //Ne sert plus à rien normalement avec la navigabilité
//                   ObjectModelAttribute reverse = attr.getReverseAttribute();
//                   if (reverse == null) {
//                       attrType = ((ObjectModelClassifier)attr.getDeclaringElement()).getQualifiedName();
//                       attrName = attr.getDeclaringElement().getName();
//                       generateAssociationAccessors(output, attrName, attrType);
//                   }
                }
            }
        }
        boolean doGenerateToString = TopiaGeneratorUtil.generateToString(clazz, model);
        if (doGenerateToString) {
output.write("    /* (non-Javadoc)\n");
output.write("     * @see java.lang.Object#toString()\n");
output.write("     */\n");
output.write("    @Override\n");
output.write("    public String toString() {\n");
output.write("        String result = new ToStringBuilder(this).\n");
output.write("");
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            //FIXME possibilité de boucles (non directes)
            ObjectModelClass attrEntity = null;
            if (model.hasClass(attr.getType())) {
                attrEntity = model.getClass(attr.getType());
            }
            boolean isEntity = (attrEntity != null && attrEntity.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY));
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if ((isEntity && (reverse == null || !reverse.isNavigable()) && !attr.hasAssociationClass()) || (!isEntity)) {
            	String attrName = attr.getName();
output.write("            append(\""+attrName+"\", this."+attrName+").\n");
output.write("");
            }
        }
output.write("         toString();\n");
output.write("        return result;\n");
output.write("    }\n");
output.write("");
        }
        String i18nPrefix = TopiaGeneratorUtil.getI18nPrefix(clazz, model);
        if (i18nPrefix != null) {
            // generate i18n prefix
            generateI18n(output, i18nPrefix, clazz);
        }
output.write("        \n");
output.write("} //"+clazzName+"Abstract\n");
output.write("");
    }

    private void generateAssociationAccessors(Writer output, String name, String type) throws IOException {
output.write("    /**\n");
output.write("     * @param value La valeur de l'attribut "+name+" à positionner.\n");
output.write("     */\n");
output.write("    @Override\n");
output.write("    public void set"+StringUtils.capitalize(name)+"("+type+" value) {\n");
output.write("        "+type+" _oldValue = this."+GeneratorUtil.toLowerCaseFirstLetter(name)+";\n");
output.write("        fireOnPreWrite(\""+name+"\", _oldValue, value);\n");
output.write("        this."+GeneratorUtil.toLowerCaseFirstLetter(name)+" = value;\n");
output.write("        fireOnPostWrite(\""+name+"\", _oldValue, value);\n");
output.write("    }\n");
output.write("\n");
output.write("    /**\n");
output.write("     * @return La valeur de l'attribut "+name+".\n");
output.write("     */\n");
output.write("    @Override\n");
output.write("    public "+type+" get"+StringUtils.capitalize(name)+"() {\n");
output.write("        return "+GeneratorUtil.toLowerCaseFirstLetter(name)+";\n");
output.write("    }\n");
output.write("\n");
output.write("");
    }

    private void generateI18n(Writer output, String i18nPrefix, ObjectModelClass clazz) throws IOException {
output.write("\n");
output.write("    static {\n");
output.write("");
        StringBuilder buffer = new StringBuilder();
        addI18n(buffer, i18nPrefix, java.beans.Introspector.decapitalize(clazz.getName()));
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            addI18n(buffer, i18nPrefix, java.beans.Introspector.decapitalize(attr.getName()));
        }
output.write(""+buffer.toString()+"}\n");
output.write("");
    }

    private void addI18n(StringBuilder buffer, String i18nPrefix, String suffix) {
        buffer.append("        org.nuiton.i18n.I18n.n_(\"").append(i18nPrefix).append(suffix).append("\");\n");
    }

} //EntityAbstractGenerator
