package org.nuiton.topiatest;

import java.util.Arrays;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topiatest.deletetest.Party2DAOImpl;


public abstract class PersonneDAOAbstract<E extends Personne> extends Party2DAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Personne.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty("name", v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty("name", v);
        return result;
    }

    /**
     * findContainsOtherNames :
     * Retourne le premier élément trouvé dont l'attribut otherNames contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsOtherNames(String... v) throws TopiaException {
        E result = findContainsProperties("otherNames", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsOtherNames :
     * Retourne les éléments trouvé dont l'attribut otherNames contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsOtherNames(String... v) throws TopiaException {
        List<E> results = findAllContainsProperties("otherNames", Arrays.asList(v));
        return results;
    }

    /**
     * findByAddress :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut address le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByAddress(Address v) throws TopiaException {
        E result = findByProperty("address", v);
        return result;
    }

    /**
     * findAllByAddress :
     * Retourne les éléments ayant comme valeur pour l'attribut address le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByAddress(Address v) throws TopiaException {
        List<E> result = findAllByProperty("address", v);
        return result;
    }


} //PersonneDAOAbstract<E extends Personne>
