/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.map.ReferenceMap;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.framework.TopiaContextImpl;
import org.nuiton.topia.framework.TopiaUtil;

public class TopiaContextFactory {
    private static final String DEFAULT_CONFIG_PROPERTIES = "TopiaContextImpl.properties";
    protected static Map<Properties, TopiaContextImpl> contextCache = new ReferenceMap(0, 1);

    public static List<String> getContextOpened() {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<Properties, TopiaContextImpl> e : contextCache.entrySet()) {
            if (e.getValue() == null) continue;
            result.add(e.getKey().getProperty("hibernate.connection.url"));
        }
        return result;
    }

    public static void removeContext(TopiaContext context) {
        Properties key = null;
        for (Map.Entry<Properties, TopiaContextImpl> e : contextCache.entrySet()) {
            if (e.getValue() != context) continue;
            key = e.getKey();
            break;
        }
        if (key != null) {
            contextCache.remove(key);
        }
    }

    public static TopiaContext getContext() throws TopiaNotFoundException {
        Properties config = TopiaUtil.getProperties(DEFAULT_CONFIG_PROPERTIES);
        TopiaContext result = TopiaContextFactory.getContext(config);
        return result;
    }

    public static TopiaContext getContext(Properties config) throws TopiaNotFoundException {
        TopiaContextImpl result = contextCache.get(config);
        if (result == null || result.isClosed()) {
            result = new TopiaContextImpl(config);
            contextCache.put((Properties)config.clone(), result);
        }
        return result;
    }
}

