/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.junit;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.nuiton.topia.persistence.TopiaConfiguration;
import org.nuiton.topia.persistence.TopiaConfigurationBuilder;
import org.nuiton.topia.persistence.TopiaPersistenceContext;
import org.nuiton.topia.persistence.internal.AbstractTopiaApplicationContext;

public abstract class AbstractDatabaseResource<PersistenceContext extends TopiaPersistenceContext, ApplicationContext extends AbstractTopiaApplicationContext<PersistenceContext>>
extends TestWatcher {
    private static final Log log = LogFactory.getLog(AbstractDatabaseResource.class);
    protected ApplicationContext applicationContext;
    protected TopiaConfiguration topiaConfiguration;

    protected abstract ApplicationContext createApplicationContext(TopiaConfiguration var1);

    protected void starting(Description description) {
        TopiaConfigurationBuilder topiaConfigurationBuilder = new TopiaConfigurationBuilder();
        this.topiaConfiguration = topiaConfigurationBuilder.forTest(description.getTestClass(), description.getMethodName());
        this.applicationContext = this.createApplicationContext(this.topiaConfiguration);
    }

    public void finished(Description description) {
        if (this.applicationContext != null && !this.applicationContext.isClosed()) {
            this.applicationContext.close();
        }
        this.applicationContext = null;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public PersistenceContext newPersistenceContext() {
        return (PersistenceContext)this.applicationContext.newPersistenceContext();
    }

    public TopiaConfiguration getTopiaConfiguration() {
        return this.topiaConfiguration;
    }
}

