package org.nuiton.topia.it.mapping.test3;

/*-
 * #%L
 * ToPIA :: IT
 * %%
 * Copyright (C) 2004 - 2024 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.Collection;
import java.util.LinkedList;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class A32Abstract extends AbstractTopiaEntity implements A32 {

    /**
     * Nom de l'attribut en BD : b32
     */
    protected Collection<B32> b32;

    private static final long serialVersionUID = 3618414948179861859L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_B32, Collection.class, B32.class, b32);
    }

    @Override
    public void addB32(B32 b32) {
        if (this.b32 == null) {
            this.b32 = new LinkedList<B32>();
        }
        if (b32.getA32() == null) {
            b32.setA32(new java.util.LinkedList<org.nuiton.topia.it.mapping.test3.A32>());
        }
        b32.getA32().add(this);
        this.b32.add(b32);
    }

    @Override
    public void addAllB32(Iterable<B32> b32) {
        if (b32 == null) {
            return;
        }
        for (B32 item : b32) {
            addB32(item);
        }
    }

    @Override
    public void setB32(Collection<B32> b32) {
        this.b32 = b32;
    }

    @Override
    public void removeB32(B32 b32) {
        if (this.b32 == null || !this.b32.remove(b32)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        b32.getA32().remove(this);
    }

    @Override
    public void clearB32() {
        if (this.b32 == null) {
            return;
        }
        for (B32 item : this.b32) {
            item.getA32().remove(this);
        }
        this.b32.clear();
    }

    @Override
    public Collection<B32> getB32() {
        return b32;
    }

    @Override
    public B32 getB32ByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(b32, topiaId);
    }

    @Override
    public Collection<String> getB32TopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<org.nuiton.topia.it.mapping.test3.B32> tmp = getB32();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeB32() {
        if (b32 == null) {
            return 0;
        }
        return b32.size();
    }

    @Override
    public boolean isB32Empty() {
        int size = sizeB32();
        return size == 0;
    }

    @Override
    public boolean isB32NotEmpty() {
        boolean empty = isB32Empty();
        return ! empty;
    }

    @Override
    public boolean containsB32(B32 b32) {
        boolean contains = this.b32 !=null && this.b32.contains(b32);
        return contains;
    }

} //A32Abstract
