package org.nuiton.topia.it.mapping.test12;

/*-
 * #%L
 * ToPIA :: IT
 * %%
 * Copyright (C) 2004 - 2024 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.it.mapping.AbstractTopiaItMappingTopiaDao;
import org.nuiton.topia.it.mapping.TopiaItMappingEntityEnum;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

public abstract class GeneratedA12ATopiaDao<E extends A12A> extends AbstractTopiaItMappingTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) A12A.class;
    }

    @Override
    public TopiaItMappingEntityEnum getTopiaEntityEnum() {
        return TopiaItMappingEntityEnum.A12A;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        super.delete(entity);
    }

    public E createByNotNull(int integerField, String stringField, Date dateField) {
        return create(A12A.PROPERTY_INTEGER_FIELD, integerField, A12A.PROPERTY_STRING_FIELD, stringField, A12A.PROPERTY_DATE_FIELD, dateField);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forIntegerFieldIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(A12A.PROPERTY_INTEGER_FIELD, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forIntegerFieldEquals(int v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(A12A.PROPERTY_INTEGER_FIELD, v);
        return result;
    }

    @Deprecated
    public E findByIntegerField(int v) {
        return forIntegerFieldEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByIntegerField(int v) {
        return forIntegerFieldEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forStringFieldIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(A12A.PROPERTY_STRING_FIELD, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forStringFieldEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(A12A.PROPERTY_STRING_FIELD, v);
        return result;
    }

    @Deprecated
    public E findByStringField(String v) {
        return forStringFieldEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByStringField(String v) {
        return forStringFieldEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDateFieldIn(Collection<Date> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(A12A.PROPERTY_DATE_FIELD, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDateFieldEquals(Date v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(A12A.PROPERTY_DATE_FIELD, v);
        return result;
    }

    @Deprecated
    public E findByDateField(Date v) {
        return forDateFieldEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByDateField(Date v) {
        return forDateFieldEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        return new LinkedList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedA12ATopiaDao<E extends A12A>
