package org.nuiton.topia.it.mapping.test1;

/*-
 * #%L
 * ToPIA :: IT
 * %%
 * Copyright (C) 2004 - 2024 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;

public abstract class B13Abstract extends AbstractTopiaEntity implements B13 {

    /**
     * Nom de l'attribut en BD : roleA13
     */
    protected A13 roleA13;

    private static final long serialVersionUID = 7219333094740354145L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_ROLE_A13, A13.class, roleA13);
    }

    @Override
    public void setRoleA13(A13 roleA13) {
        this.roleA13 = roleA13;
    }

    @Override
    public A13 getRoleA13() {
        A13 result = this.roleA13;
        return result;
    }

} //B13Abstract
