package org.nuiton.topia.it.legacy.topiatest;

/*-
 * #%L
 * ToPIA :: IT
 * %%
 * Copyright (C) 2004 - 2020 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.Collection;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.event.ListenableTopiaEntity;

public interface Department extends TopiaEntity, ListenableTopiaEntity {

    String PROPERTY_NAME = "name";

    String PROPERTY_LEADER = "leader";

    String PROPERTY_COMPANY = "company";

    String PROPERTY_PRODUCT = "product";

    void setName(String name);

    String getName();

    void setLeader(Employe leader);

    Employe getLeader();

    void setCompany(Company company);

    Company getCompany();

    void addProduct(Product product);

    void addAllProduct(Iterable<Product> product);

    void setProduct(Collection<Product> product);

    void removeProduct(Product product);

    void clearProduct();

    Collection<Product> getProduct();

    Product getProductByTopiaId(String topiaId);

    Collection<String> getProductTopiaIds();

    int sizeProduct();

    boolean isProductEmpty();

    boolean isProductNotEmpty();

    boolean containsProduct(Product product);

} //Department
