/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.FileUtils;

public class JnlpReportMojo
extends AbstractMavenReport {
    private File outputDirectory;
    private Renderer siteRenderer;
    private MavenProject project;
    private File jnlpSourceDirectory;
    private String siteJnlpFile;
    private String outputName;
    private String codebase;

    public void executeReport(Locale locale) throws MavenReportException {
        this.copyJnlpFiles();
        this.fillReport(locale);
    }

    private void copyJnlpFiles() throws MavenReportException {
        if (!this.jnlpSourceDirectory.exists()) {
            throw new MavenReportException("jnlpSourceDirectory does not exist");
        }
        try {
            File destinationDirectory = new File(this.outputDirectory, this.siteJnlpFile).getParentFile();
            List files = FileUtils.getFiles((File)this.jnlpSourceDirectory, (String)"**/*", (String)"");
            Iterator i = files.iterator();
            while (i.hasNext()) {
                File file = (File)i.next();
                this.getLog().debug((CharSequence)("Copying " + file + " to " + destinationDirectory));
                String path = file.getAbsolutePath().substring(this.jnlpSourceDirectory.getAbsolutePath().length() + 1);
                File destDir = new File(destinationDirectory, path);
                this.getLog().debug((CharSequence)("Copying " + file + " to " + destDir));
                if (file.isDirectory()) {
                    destDir.mkdirs();
                    continue;
                }
                FileUtils.copyFileToDirectory((File)file, (File)destDir.getParentFile());
            }
        }
        catch (IOException e) {
            throw new MavenReportException("Failed to copy jnlp files", (Exception)e);
        }
    }

    private void fillReport(Locale locale) {
        this.getSink().head();
        this.getSink().text(this.getBundle(locale).getString("report.jnlp-report.description"));
        this.getSink().head_();
        this.getSink().body();
        this.getSink().sectionTitle1();
        this.getSink().text(this.getBundle(locale).getString("report.jnlp-report.label.installation.header"));
        this.getSink().sectionTitle1_();
        this.getSink().paragraph();
        this.getSink().text(this.getBundle(locale).getString("report.jnlp-report.label.installation.description"));
        this.getSink().paragraph_();
        this.getSink().paragraph();
        if (this.codebase.startsWith("file://")) {
            if (!this.codebase.endsWith(File.separator)) {
                this.codebase = this.codebase + File.separator;
            }
        } else if (!this.codebase.endsWith("/")) {
            this.codebase = this.codebase + "/";
        }
        this.getSink().link(this.codebase + this.siteJnlpFile);
        this.getSink().text(this.getBundle(locale).getString("report.jnlp-report.label.installation.webStartMeNow"));
        this.getSink().link_();
        this.getSink().paragraph_();
        this.getSink().paragraph();
        this.getSink().text(this.getBundle(locale).getString("report.jnlp-report.label.installation.getJava") + " ");
        this.getSink().link("http://java.com");
        this.getSink().text("http://java.com");
        this.getSink().link_();
        this.getSink().paragraph_();
        this.getSink().sectionTitle1();
        this.getSink().text(this.getBundle(locale).getString("report.jnlp-report.label.uninstallation.header"));
        this.getSink().sectionTitle1_();
        this.getSink().paragraph();
        this.getSink().text(this.getBundle(locale).getString("report.jnlp-report.label.uninstallation.description"));
        this.getSink().paragraph_();
        this.getSink().body_();
        this.getSink().flush();
        this.getSink().close();
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.jnlp-report.name");
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.jnlp-report.description");
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    public String getOutputName() {
        return this.outputName;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getPath();
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("jnlp-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }
}

