/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JRI;

import org.rosuda.JRI.Mutex;
import org.rosuda.JRI.REXP;
import org.rosuda.JRI.RMainLoopCallbacks;

public class Rengine
extends Thread {
    public static boolean jriLoaded;
    boolean loopHasLock = false;
    static Thread mainRThread;
    public static final int SO_NilValue = 0;
    public static final int SO_GlobalEnv = 1;
    public static final int SO_EmptyEnv = 2;
    public static final int SO_BaseEnv = 3;
    public static final int SO_UnboundValue = 4;
    public static final int SO_MissingArg = 5;
    public static final int SO_NaString = 6;
    public static final int SO_BlankString = 7;
    public static int DEBUG;
    public int idleDelay = 200;
    static Rengine mainEngine;
    boolean standAlone = true;
    boolean died = false;
    boolean alive;
    boolean runLoop;
    boolean loopRunning;
    String[] args;
    Mutex Rsync = new Mutex();
    RMainLoopCallbacks callback;

    public static long getVersion() {
        return 266L;
    }

    public static boolean versionCheck() {
        return Rengine.getVersion() == Rengine.rniGetVersion();
    }

    public static Rengine getMainEngine() {
        return mainEngine;
    }

    public static boolean inMainRThread() {
        return mainRThread != null && mainRThread.equals(Thread.currentThread());
    }

    public boolean isStandAlone() {
        return this.standAlone;
    }

    public Rengine(String[] args, boolean runMainLoop, RMainLoopCallbacks initialCallbacks) {
        this.alive = false;
        this.runLoop = runMainLoop;
        this.loopRunning = false;
        this.args = args;
        this.callback = initialCallbacks;
        mainEngine = this;
        mainRThread = this;
        this.start();
        while (!this.alive && !this.died) {
            Rengine.yield();
        }
    }

    public Rengine() {
        this.alive = true;
        this.runLoop = false;
        this.loopRunning = true;
        this.standAlone = false;
        this.args = new String[]{"--zero-init"};
        this.callback = null;
        mainEngine = this;
        mainRThread = Thread.currentThread();
        this.rniSetupR(this.args);
    }

    native int rniSetupR(String[] var1);

    public native int rniSetupRJava(int var1, int var2);

    public native int rniRJavaLock();

    public native int rniRJavaUnlock();

    synchronized int setupR() {
        return this.setupR(null);
    }

    synchronized int setupR(String[] args) {
        int r = this.rniSetupR(args);
        if (r == 0) {
            this.alive = true;
            this.died = false;
        } else {
            this.alive = false;
            this.died = true;
        }
        return r;
    }

    public synchronized native long rniParse(String var1, int var2);

    public synchronized native long rniEval(long var1, long var3);

    public synchronized native void rniProtect(long var1);

    public synchronized native void rniUnprotect(int var1);

    public synchronized native String rniGetString(long var1);

    public synchronized native String[] rniGetStringArray(long var1);

    public synchronized native int[] rniGetIntArray(long var1);

    public synchronized native int[] rniGetBoolArrayI(long var1);

    public synchronized native double[] rniGetDoubleArray(long var1);

    public synchronized native byte[] rniGetRawArray(long var1);

    public synchronized native long[] rniGetVector(long var1);

    public synchronized native long rniPutString(String var1);

    public synchronized native long rniPutStringArray(String[] var1);

    public synchronized native long rniPutIntArray(int[] var1);

    public synchronized native long rniPutBoolArrayI(int[] var1);

    public synchronized native long rniPutBoolArray(boolean[] var1);

    public synchronized native long rniPutDoubleArray(double[] var1);

    public synchronized native long rniPutRawArray(byte[] var1);

    public synchronized native long rniPutVector(long[] var1);

    public synchronized native long rniGetAttr(long var1, String var3);

    public synchronized native String[] rniGetAttrNames(long var1);

    public synchronized native void rniSetAttr(long var1, String var3, long var4);

    public synchronized native boolean rniInherits(long var1, String var3);

    public synchronized native long rniCons(long var1, long var3, long var5, boolean var7);

    public long rniCons(long head, long tail) {
        return this.rniCons(head, tail, 0L, false);
    }

    public long rniLCons(long head, long tail) {
        return this.rniCons(head, tail, 0L, true);
    }

    public synchronized native long rniCAR(long var1);

    public synchronized native long rniCDR(long var1);

    public synchronized native long rniTAG(long var1);

    public synchronized native long rniPutList(long[] var1);

    public synchronized native long[] rniGetList(long var1);

    public synchronized native String rniGetSymbolName(long var1);

    public synchronized native long rniInstallSymbol(String var1);

    public synchronized native void rniPrint(String var1, int var2);

    public synchronized native void rniPrintValue(long var1);

    public synchronized native void rniPreserve(long var1);

    public synchronized native void rniRelease(long var1);

    public synchronized native long rniParentEnv(long var1);

    public synchronized native long rniFindVar(String var1, long var2);

    public synchronized native long rniListEnv(long var1, boolean var3);

    public synchronized native long rniSpecialObject(int var1);

    public synchronized native long rniJavaToXref(Object var1);

    public synchronized native Object rniXrefToJava(long var1);

    public static native long rniGetVersion();

    public native int rniStop(int var1);

    public synchronized native boolean rniAssign(String var1, long var2, long var4);

    public synchronized native int rniExpType(long var1);

    public native void rniRunMainLoop();

    public synchronized native void rniIdle();

    public void addMainLoopCallbacks(RMainLoopCallbacks c) {
        this.callback = c;
    }

    public void startMainLoop() {
        this.runLoop = true;
    }

    public void jriWriteConsole(String text, int oType) {
        if (this.callback != null) {
            this.callback.rWriteConsole(this, text, oType);
        }
    }

    public void jriBusy(int which) {
        if (this.callback != null) {
            this.callback.rBusy(this, which);
        }
    }

    public String jriReadConsole(String prompt, int addToHistory) {
        if (DEBUG > 1) {
            System.out.println("Rengine.jreReadConsole BEGIN " + Thread.currentThread());
        }
        if (this.loopHasLock) {
            this.Rsync.unlock();
            this.loopHasLock = false;
        }
        String s = this.callback == null ? null : this.callback.rReadConsole(this, prompt, addToHistory);
        this.loopHasLock = this.Rsync.safeLock();
        if (!this.loopHasLock) {
            String es = "\n>>JRI Warning: jriReadConsole detected a possible deadlock [" + this.Rsync + "][" + Thread.currentThread() + "]. Proceeding without lock, but this is inherently unsafe.\n";
            this.jriWriteConsole(es, 1);
            System.err.print(es);
        }
        if (DEBUG > 1) {
            System.out.println("Rengine.jreReadConsole END " + Thread.currentThread());
        }
        return s;
    }

    public void jriShowMessage(String message) {
        if (this.callback != null) {
            this.callback.rShowMessage(this, message);
        }
    }

    public void jriLoadHistory(String filename) {
        if (this.callback != null) {
            this.callback.rLoadHistory(this, filename);
        }
    }

    public void jriSaveHistory(String filename) {
        if (this.callback != null) {
            this.callback.rSaveHistory(this, filename);
        }
    }

    public String jriChooseFile(int newFile) {
        if (this.callback != null) {
            return this.callback.rChooseFile(this, newFile);
        }
        return null;
    }

    public void jriFlushConsole() {
        if (this.callback != null) {
            this.callback.rFlushConsole(this);
        }
    }

    public synchronized REXP eval(String s) {
        return this.eval(s, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized REXP eval(String s, boolean convert) {
        if (DEBUG > 0) {
            System.out.println("Rengine.eval(" + s + "): BEGIN " + Thread.currentThread());
        }
        boolean obtainedLock = this.Rsync.safeLock();
        try {
            long er;
            long pr = this.rniParse(s, 1);
            if (pr != 0L && (er = this.rniEval(pr, 0L)) != 0L) {
                REXP x = new REXP(this, er, convert);
                if (DEBUG > 0) {
                    System.out.println("Rengine.eval(" + s + "): END (OK)" + Thread.currentThread());
                }
                REXP rEXP = x;
                return rEXP;
            }
        }
        finally {
            if (obtainedLock) {
                this.Rsync.unlock();
            }
        }
        if (DEBUG > 0) {
            System.out.println("Rengine.eval(" + s + "): END (ERR)" + Thread.currentThread());
        }
        return null;
    }

    public synchronized REXP idleEval(String s) {
        return this.idleEval(s, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized REXP idleEval(String s, boolean convert) {
        int lockStatus = this.Rsync.tryLock();
        if (lockStatus == 1) {
            return null;
        }
        boolean obtainedLock = lockStatus == 0;
        try {
            long er;
            long pr = this.rniParse(s, 1);
            if (pr != 0L && (er = this.rniEval(pr, 0L)) != 0L) {
                REXP x;
                REXP rEXP = x = new REXP(this, er, convert);
                return rEXP;
            }
        }
        finally {
            if (obtainedLock) {
                this.Rsync.unlock();
            }
        }
        return null;
    }

    public Mutex getRsync() {
        return this.Rsync;
    }

    public synchronized boolean waitForR() {
        return this.alive;
    }

    public void end() {
        this.alive = false;
        this.interrupt();
    }

    public void run() {
        block16: {
            if (DEBUG > 0) {
                System.out.println("Starting R...");
            }
            this.loopHasLock = this.Rsync.safeLock();
            try {
                if (this.setupR(this.args) == 0) {
                    if (!this.runLoop && this.loopHasLock) {
                        this.Rsync.unlock();
                        this.loopHasLock = false;
                    }
                    while (this.alive) {
                        block15: {
                            if (!this.runLoop) break block15;
                            if (DEBUG > 0) {
                                System.out.println("***> launching main loop:");
                            }
                            this.loopRunning = true;
                            this.rniRunMainLoop();
                            this.loopRunning = false;
                            if (DEBUG > 0) {
                                System.out.println("***> main loop finished:");
                            }
                            this.runLoop = false;
                            this.died = true;
                            return;
                        }
                        try {
                            Rengine.sleep(this.idleDelay);
                            if (!this.runLoop) continue;
                            this.rniIdle();
                        }
                        catch (InterruptedException ie) {
                            Rengine.interrupted();
                        }
                    }
                    this.died = true;
                    if (DEBUG > 0) {
                        System.out.println("Terminating R thread.");
                    }
                    break block16;
                }
                System.err.println("Unable to start R");
            }
            finally {
                if (this.loopHasLock) {
                    this.Rsync.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean assign(String sym, String ct) {
        boolean obtainedLock = this.Rsync.safeLock();
        try {
            long x1 = this.rniPutString(ct);
            boolean bl = this.rniAssign(sym, x1, 0L);
            return bl;
        }
        finally {
            if (obtainedLock) {
                this.Rsync.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean assign(String sym, REXP r) {
        boolean obtainedLock = this.Rsync.safeLock();
        try {
            if (r.Xt == -1) {
                boolean bl = this.rniAssign(sym, r.xp, 0L);
                return bl;
            }
            if (r.Xt == 1 || r.Xt == 32) {
                int[] nArray;
                if (r.rtype == 1) {
                    int[] nArray2 = new int[1];
                    nArray = nArray2;
                    nArray2[0] = (Integer)r.cont;
                } else {
                    nArray = (int[])r.cont;
                }
                int[] cont = nArray;
                long x1 = this.rniPutIntArray(cont);
                boolean bl = this.rniAssign(sym, x1, 0L);
                return bl;
            }
            if (r.Xt == 2 || r.Xt == 33) {
                double[] dArray;
                if (r.rtype == 2) {
                    double[] dArray2 = new double[1];
                    dArray = dArray2;
                    dArray2[0] = ((Double)r.cont).intValue();
                } else {
                    dArray = (double[])r.cont;
                }
                double[] cont = dArray;
                long x1 = this.rniPutDoubleArray(cont);
                boolean bl = this.rniAssign(sym, x1, 0L);
                return bl;
            }
            if (r.Xt == 37) {
                long x1 = this.rniPutBoolArrayI((int[])r.cont);
                boolean bl = this.rniAssign(sym, x1, 0L);
                return bl;
            }
            if (r.Xt == 3 || r.Xt == 34) {
                String[] stringArray;
                if (r.rtype == 3) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = (String)r.cont;
                } else {
                    stringArray = (String[])r.cont;
                }
                String[] cont = stringArray;
                long x1 = this.rniPutStringArray(cont);
                boolean bl = this.rniAssign(sym, x1, 0L);
                return bl;
            }
        }
        finally {
            if (obtainedLock) {
                this.Rsync.unlock();
            }
        }
        return false;
    }

    public boolean assign(String sym, double[] val) {
        return this.assign(sym, new REXP(val));
    }

    public boolean assign(String sym, int[] val) {
        return this.assign(sym, new REXP(val));
    }

    public boolean assign(String sym, boolean[] val) {
        return this.assign(sym, new REXP(val));
    }

    public boolean assign(String sym, String[] val) {
        return this.assign(sym, new REXP(val));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REXP createRJavaRef(Object o) {
        if (o == null) {
            return null;
        }
        String klass = o.getClass().getName();
        boolean obtainedLock = this.Rsync.safeLock();
        try {
            long l = this.rniEval(this.rniLCons(this.rniInstallSymbol(".jmkref"), this.rniLCons(this.rniJavaToXref(o), this.rniLCons(this.rniPutString(klass), 0L))), 0L);
            if (l <= 0L && l > -4L) {
                REXP rEXP = null;
                return rEXP;
            }
            REXP rEXP = new REXP(this, l, false);
            return rEXP;
        }
        finally {
            if (obtainedLock) {
                this.Rsync.unlock();
            }
        }
    }

    static {
        block2: {
            try {
                System.loadLibrary("jri");
                jriLoaded = true;
            }
            catch (UnsatisfiedLinkError e) {
                jriLoaded = false;
                String iu = System.getProperty("jri.ignore.ule");
                if (iu != null && iu.equals("yes")) break block2;
                System.err.println("Cannot find JRI native library!\nPlease make sure that the JRI native library is in a directory listed in java.library.path.\n");
                e.printStackTrace();
                System.exit(1);
            }
        }
        mainRThread = null;
        DEBUG = 0;
        mainEngine = null;
    }
}

