/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.Resource;

public class ClassLoaderUtil {
    private static final Log log = LogFactory.getLog(ClassLoaderUtil.class);

    public static URL[] getDeepURLs(URLClassLoader loader) {
        Stack<URL> urlToTreate = new Stack<URL>();
        ArrayList<URL> urlTreated = new ArrayList<URL>();
        URL[] result = ClassLoaderUtil.getURLs(loader);
        urlToTreate.addAll(Arrays.asList(result));
        while (!urlToTreate.isEmpty()) {
            URL currentUrl = (URL)urlToTreate.pop();
            urlTreated.add(currentUrl);
            if (!Resource.isJar(currentUrl.toString())) continue;
            try {
                URL[] newArrayURLs = Resource.getClassPathURLsFromJarManifest(currentUrl);
                if (newArrayURLs == null) continue;
                List<URL> newURLs = Arrays.asList(newArrayURLs);
                for (URL newURL : newURLs) {
                    if (urlTreated.contains(newURL) || urlToTreate.contains(newURL)) continue;
                    urlToTreate.add(newURL);
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("error with url" + currentUrl + " for reason : " + e.getMessage());
            }
        }
        return urlTreated.toArray(new URL[urlToTreate.size()]);
    }

    public static URL[] getURLs(URLClassLoader classLoader) {
        URL[] result;
        Method m;
        if (classLoader == null) {
            classLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        }
        try {
            m = classLoader.getClass().getMethod("getAllURLs", new Class[0]);
        }
        catch (Exception e) {
            m = null;
        }
        if (m == null) {
            result = classLoader.getURLs();
        } else {
            try {
                result = (URL[])m.invoke((Object)classLoader, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return result;
    }

    public static void printLoader(ClassLoader loader) {
        log.info(loader);
        if (loader instanceof URLClassLoader) {
            URL[] urls;
            for (URL url : urls = ClassLoaderUtil.getURLs((URLClassLoader)loader)) {
                log.info(url);
            }
        }
    }
}

