/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.config.plugin.io;

import com.google.common.io.Files;
import com.moandjiezana.toml.Toml;
import com.moandjiezana.toml.TomlWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.nuiton.config.plugin.io.ConfigModelIO;
import org.nuiton.config.plugin.io.ReadConfigModelException;
import org.nuiton.config.plugin.io.WriteConfigModelException;
import org.nuiton.config.plugin.model.ConfigModel;
import org.nuiton.config.plugin.model.OptionModel;

public class ConfigModelIOTomlImpl
implements ConfigModelIO {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ConfigModel read(Path path) throws ReadConfigModelException {
        try (BufferedReader reader = Files.newReader((File)path.toFile(), (Charset)StandardCharsets.UTF_8);){
            Toml toml = new Toml().read((Reader)reader);
            ConfigModel configModel = (ConfigModel)toml.to(ConfigModel.class);
            for (OptionModel optionModel : configModel.getOptions()) {
                optionModel.setType(optionModel.getType());
            }
            ConfigModel configModel2 = configModel;
            return configModel2;
        }
        catch (Exception e) {
            throw new ReadConfigModelException("Can't real toml config model from file: " + path, e);
        }
    }

    @Override
    public void write(ConfigModel configModel, Path path) throws WriteConfigModelException {
        try (BufferedWriter writer = Files.newWriter((File)path.toFile(), (Charset)StandardCharsets.UTF_8);){
            new TomlWriter().write((Object)configModel, (Writer)writer);
        }
        catch (Exception e) {
            throw new WriteConfigModelException("Can't write toml config model from file: " + path, e);
        }
    }
}

