/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.config.io.ini;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.configuration2.INIConfiguration;
import org.apache.commons.configuration2.SubnodeConfiguration;
import org.nuiton.config.io.ApplicationConfigIO;
import org.nuiton.config.io.ApplicationConfigReadFormat;
import org.nuiton.config.io.ApplicationConfigReadPropertiesException;
import org.nuiton.config.io.ApplicationConfigWritePropertiesException;

public class ApplicationConfigIOIni
implements ApplicationConfigIO {
    public boolean accept(ApplicationConfigReadFormat readFormat) {
        return ApplicationConfigReadFormat.ini.equals((Object)readFormat);
    }

    public Properties readProperties(URL url, String encoding) throws ApplicationConfigReadPropertiesException {
        Properties properties = new Properties();
        INIConfiguration iniConfiguration = new INIConfiguration();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), encoding));){
            iniConfiguration.read((Reader)reader);
        }
        catch (Exception e) {
            throw new ApplicationConfigReadPropertiesException("Can't read ini file: " + url, (Throwable)e);
        }
        Iterator keysIterator = iniConfiguration.getKeys();
        while (keysIterator.hasNext()) {
            String key = (String)keysIterator.next();
            properties.put(key, iniConfiguration.getProperty(key));
        }
        for (String sectionName : iniConfiguration.getSections()) {
            if (sectionName == null) continue;
            SubnodeConfiguration section = iniConfiguration.getSection(sectionName);
            Iterator sectionKeysIterator = section.getKeys();
            while (sectionKeysIterator.hasNext()) {
                String key = (String)sectionKeysIterator.next();
                properties.put(sectionName + "." + key, section.getProperty(key));
            }
        }
        return properties;
    }

    public void writeProperties(Properties properties, File file, String encoding, String comment) throws ApplicationConfigWritePropertiesException {
        INIConfiguration iniConfiguration = new INIConfiguration();
        ArrayListMultimap splits = ArrayListMultimap.create();
        for (String key : properties.stringPropertyNames()) {
            ArrayList<String> split = new ArrayList<String>(Arrays.asList(key.split("\\.")));
            if (split.size() == 1) {
                iniConfiguration.addProperty(key, (Object)properties.getProperty(key));
                continue;
            }
            String lastKey = (String)split.remove(split.size() - 1);
            splits.put((Object)Joiner.on((String)".").join(split), (Object)lastKey);
        }
        for (String sectionName : splits.keySet()) {
            Collection keyNames = splits.get((Object)sectionName);
            if (keyNames.size() > 1) {
                SubnodeConfiguration section = iniConfiguration.getSection(sectionName);
                for (String keyName : keyNames) {
                    section.addProperty(keyName, (Object)properties.getProperty(sectionName + "." + keyName));
                }
                continue;
            }
            String keyName = (String)keyNames.iterator().next();
            iniConfiguration.addProperty(sectionName + "." + keyName, (Object)properties.getProperty(sectionName + "." + keyName));
        }
        try (BufferedWriter writer = Files.newWriter((File)file, (Charset)Charset.forName(encoding));){
            iniConfiguration.write((Writer)writer);
        }
        catch (Exception e) {
            throw new ApplicationConfigWritePropertiesException("Can't write ini file: " + file, (Throwable)e);
        }
    }
}

