/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin;

import java.text.ParseException;
import java.util.Date;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;
import org.nuiton.jredmine.model.Version;
import org.nuiton.jredmine.plugin.AbstractRedmineMojoWithProjectAndVersion;
import org.nuiton.jredmine.plugin.DryRunAware;
import org.nuiton.plugin.PluginHelper;

@Mojo(name="next-version", requiresOnline=true, requiresProject=true)
public class NextVersionMojo
extends AbstractRedmineMojoWithProjectAndVersion
implements DryRunAware {
    @Parameter(property="redmine.anonymous", defaultValue="false")
    protected boolean anonymous;
    @Parameter(property="redmine.versionDescription")
    protected String versionDescription;
    @Parameter(property="redmine.effectiveDate")
    protected String effectiveDate;
    @Parameter(property="redmine.previousVersionName")
    protected String previousVersionName;
    @Parameter(property="redmine.skipNextVersion", defaultValue="false")
    protected boolean skipNextVersion;
    @Parameter(property="redmine.dryRun", defaultValue="false")
    protected boolean dryRun;
    @Parameter(property="redmine.runOnce", defaultValue="true")
    protected boolean runOnce;
    private Date date;

    public NextVersionMojo() {
        super(true, false);
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    @Override
    public boolean isDryRun() {
        return this.dryRun;
    }

    @Override
    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    @Override
    protected boolean isGoalSkip() {
        return this.skipNextVersion;
    }

    @Override
    protected boolean isRunOnce() {
        return this.runOnce;
    }

    @Override
    protected boolean checkRunOnceDone() {
        return this.isRunOnce() && !this.isExecutionRoot();
    }

    @Override
    protected void init() throws Exception {
        if (StringUtils.isBlank((String)this.versionId)) {
            throw new MojoExecutionException("required a versionId parameter");
        }
        this.versionId = PluginHelper.removeSnapshotSuffix((String)this.versionId);
        this.runOnceDone = false;
        if (this.isRunOnce()) {
            this.runOnceDone = this.checkRunOnceDone();
            if (this.runOnceDone) {
                return;
            }
        }
        if (StringUtils.isNotBlank((String)this.effectiveDate)) {
            try {
                this.date = this.dateFormat.parse(this.effectiveDate);
            }
            catch (ParseException e) {
                throw new MojoExecutionException("could not parse effectivate date " + this.effectiveDate + " for reason " + e.getMessage(), (Exception)e);
            }
        }
        super.init();
    }

    @Override
    protected void doAction() throws Exception {
        if (this.dryRun) {
            this.getLog().info((CharSequence)"\n  dryRun flag is on, no data will be send!\n");
        }
        Version v = this.getProjectVersion(this.versionId);
        boolean usePreviousVersion = false;
        if (StringUtils.isNotBlank((String)this.previousVersionName)) {
            Version previousVersion = this.getProjectVersion(this.previousVersionName);
            if (previousVersion == null) {
                this.getLog().warn((CharSequence)("can not find the previous version " + this.previousVersionName));
            } else {
                usePreviousVersion = true;
            }
        }
        if (v == null) {
            v = new Version();
            v.setName(this.versionId);
        }
        if (StringUtils.isNotBlank((String)this.versionDescription)) {
            v.setDescription(this.versionDescription.trim());
        }
        if (this.date != null) {
            v.setEffectiveDate(this.date);
        }
        this.releaseVersion = v;
        if (!this.dryRun) {
            this.getLog().info((CharSequence)("next version " + this.releaseVersion.getName() + (usePreviousVersion ? " from previous version " + this.previousVersionName : "")));
            this.service.nextVersion(this.projectId, usePreviousVersion ? this.previousVersionName : null, this.releaseVersion);
        }
    }
}

