/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jpa.templates;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.nuiton.eugene.java.JavaGeneratorUtil;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.jpa.templates.AbstractJpaTransformer;

public class JpaTemplatesGeneratorUtil
extends JavaGeneratorUtil {
    public static final Comparator<ObjectModelClass> OBJECT_MODEL_CLASS_COMPARATOR = new Comparator<ObjectModelClass>(){

        @Override
        public int compare(ObjectModelClass o1, ObjectModelClass o2) {
            return o1.getQualifiedName().compareTo(o2.getQualifiedName());
        }
    };

    public static boolean isEntity(ObjectModelClassifier input) {
        return input.getPackageName().endsWith(".entity");
    }

    public static String getPersistenceContextPackage(AbstractJpaTransformer transformer, ObjectModel model) {
        String result = transformer.getDefaultPackageName();
        return result;
    }

    public static String getEntityPackage(AbstractJpaTransformer transformer, ObjectModel model, ObjectModelClassifier input) {
        String result = input.getPackageName();
        return result;
    }

    public static String getDaoPackage(AbstractJpaTransformer transformer, ObjectModel model, ObjectModelClassifier input) {
        Preconditions.checkState((boolean)JpaTemplatesGeneratorUtil.isEntity(input), (Object)("Cant' find dao package name for a none entity " + input));
        int lastIndexOf = input.getPackageName().lastIndexOf(".entity");
        String result = input.getPackageName().substring(0, lastIndexOf) + ".dao";
        return result;
    }

    public static List<ObjectModelClass> getEntityClasses(ObjectModel model, boolean sort) {
        ArrayList<ObjectModelClass> classes = new ArrayList<ObjectModelClass>();
        for (ObjectModelClass clazz : model.getClasses()) {
            if (!JpaTemplatesGeneratorUtil.isEntity((ObjectModelClassifier)clazz)) continue;
            classes.add(clazz);
        }
        if (sort && !classes.isEmpty()) {
            Collections.sort(classes, OBJECT_MODEL_CLASS_COMPARATOR);
        }
        return classes;
    }

    public static String getPersistenceContextAbstractName(ObjectModel model) {
        return "AbstractJpa" + model.getName() + "PersistenceContext";
    }

    public static String getPersistenceContextConcreteName(ObjectModel model) {
        return "Jpa" + model.getName() + "PersistenceContext";
    }

    public static String getEntityAbstractName(ObjectModelClass input) {
        return "AbstractJpa" + input.getName();
    }

    public static String getEntityConcreteName(ObjectModelClass input) {
        return input.getName();
    }

    public static String getDaoAbstractName(ObjectModelClass input) {
        return "Abstract" + input.getName() + "JpaDao";
    }

    public static String getDaoGeneratedName(ObjectModelClass input) {
        return "Generated" + input.getName() + "JpaDao";
    }

    public static String getDaoConcreteName(ObjectModelClass input) {
        return input.getName() + "JpaDao";
    }

    public static String getConcreteEntityQualifiedName(AbstractJpaTransformer transformer, ObjectModel model, ObjectModelClass input) {
        return JpaTemplatesGeneratorUtil.getEntityPackage(transformer, model, (ObjectModelClassifier)input) + "." + JpaTemplatesGeneratorUtil.getEntityConcreteName(input);
    }

    public static String getConcreteDaoQualifiedName(AbstractJpaTransformer transformer, ObjectModel model, ObjectModelClass input) {
        return JpaTemplatesGeneratorUtil.getDaoPackage(transformer, model, (ObjectModelClassifier)input) + "." + JpaTemplatesGeneratorUtil.getDaoConcreteName(input);
    }

    public static Class<?> getCollectionType(ObjectModelAttribute attr) {
        boolean ordered = attr.isOrdered() || JpaTemplatesGeneratorUtil.hasOrderedStereotype((ObjectModelAttribute)attr);
        boolean unique = JpaTemplatesGeneratorUtil.hasUniqueStereotype(attr);
        Class result = ordered ? (unique ? LinkedHashSet.class : List.class) : (unique ? Set.class : Collection.class);
        return result;
    }

    public static Class<?> getCollectionInstanceType(ObjectModelAttribute attr) {
        boolean ordered = attr.isOrdered() || JpaTemplatesGeneratorUtil.hasOrderedStereotype((ObjectModelAttribute)attr);
        boolean unique = JpaTemplatesGeneratorUtil.hasUniqueStereotype(attr);
        Class result = ordered ? (unique ? LinkedHashSet.class : ArrayList.class) : (unique ? HashSet.class : ArrayList.class);
        return result;
    }

    public static boolean containsMutiple(Collection<ObjectModelAttribute> attributes) {
        boolean result = false;
        for (ObjectModelAttribute attr : attributes) {
            if (!JpaTemplatesGeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static String getAttributeName(ObjectModelAttribute attr) {
        String attrName = attr.getName();
        if (attr.hasAssociationClass()) {
            String assocAttrName = JpaTemplatesGeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr);
            attrName = JpaTemplatesGeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName);
        }
        return attrName;
    }

    public static String getAttributeType(ObjectModelAttribute attr) {
        String attrType = attr.getType();
        if (attr.hasAssociationClass()) {
            attrType = attr.getAssociationClass().getName();
        }
        return attrType;
    }

    public static List<ObjectModelAttribute> getProperties(ObjectModelClass input) {
        List attributes = (List)input.getAttributes();
        ArrayList<ObjectModelAttribute> attrs = new ArrayList<ObjectModelAttribute>();
        for (ObjectModelAttribute attr : attributes) {
            if (!attr.isNavigable()) continue;
            attrs.add(attr);
        }
        return attrs;
    }

    public static String getIdFactoryTagValue(ObjectModel model) {
        String value = JpaTemplatesGeneratorUtil.findTagValue((String)"idFactory", null, (Model)model);
        return value;
    }

    public static boolean useIdFactory(ObjectModel model) {
        String value = JpaTemplatesGeneratorUtil.getIdFactoryTagValue(model);
        return ObjectUtils.equals((Object)"true", (Object)value);
    }

    public static String getGeneratePropertyChangeListenersTagValue(ObjectModel model) {
        String value = JpaTemplatesGeneratorUtil.findTagValue((String)"generatePropertyChangeListeners", null, (Model)model);
        return value;
    }

    public static boolean useGeneratePropertyChangeListeners(ObjectModel model) {
        String value = JpaTemplatesGeneratorUtil.getGeneratePropertyChangeListenersTagValue(model);
        return ObjectUtils.equals((Object)"true", (Object)value);
    }

    public static String getGenerateVisitorsTagValue(ObjectModel model) {
        String value = JpaTemplatesGeneratorUtil.findTagValue((String)"generateVisitors", null, (Model)model);
        return value;
    }

    public static boolean useGenerateVisitors(ObjectModel model) {
        String value = JpaTemplatesGeneratorUtil.getGenerateVisitorsTagValue(model);
        return ObjectUtils.equals((Object)"true", (Object)value);
    }

    public static String getGenerateExtraTechnicalFieldsTagValue(ObjectModel model, ObjectModelClassifier classifier) {
        String value = JpaTemplatesGeneratorUtil.findTagValue((String)"generateExtraTechnicalFields", null, (Model)model);
        return value;
    }

    public static boolean useGenerateExtraTechnicalFields(ObjectModel model, ObjectModelClassifier classifier) {
        String value = JpaTemplatesGeneratorUtil.getGenerateExtraTechnicalFieldsTagValue(model, classifier);
        return ObjectUtils.equals((Object)"true", (Object)value);
    }

    public static String getEntitySuperClassTagValue(ObjectModel model, ObjectModelClassifier classifier) {
        String value = JpaTemplatesGeneratorUtil.findTagValue((String)"entitySuperClass", (ObjectModelElement)classifier, (Model)model);
        return value;
    }

    public static String getDaoSuperClassTagValue(ObjectModel model, ObjectModelClassifier classifier) {
        String value = JpaTemplatesGeneratorUtil.findTagValue((String)"daoSuperClass", (ObjectModelElement)classifier, (Model)model);
        return value;
    }

    public static String getPersistenceContextSuperClassTagValue(ObjectModel model) {
        String value = JpaTemplatesGeneratorUtil.findTagValue((String)"persistenceContextSuperClass", null, (Model)model);
        return value;
    }

    public static String getInverseTagValue(ObjectModelAttribute attribute) {
        String value = JpaTemplatesGeneratorUtil.findTagValue((String)"inverse", (ObjectModelElement)attribute, null);
        return value;
    }

    public static boolean hasUniqueStereotype(ObjectModelAttribute attribute) {
        return attribute.hasStereotype("unique");
    }

    public static boolean hasNotGeneratedValueStereotype(ObjectModelClassifier clazz) {
        return clazz.hasStereotype("notGeneratedValue");
    }

    public static boolean generateEntityGeneratedValueAnnotation(ObjectModel model, ObjectModelClass clazz) {
        boolean result;
        boolean bl = result = !JpaTemplatesGeneratorUtil.useIdFactory(model);
        if (result) {
            result = !JpaTemplatesGeneratorUtil.hasNotGeneratedValueStereotype((ObjectModelClassifier)clazz);
        }
        return result;
    }
}

