/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jpa.hibernate;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.cfg.ImprovedNamingStrategy;
import org.hibernate.cfg.NamingStrategy;

public class OracleCompliantImprovedNamingStrategy
extends ImprovedNamingStrategy
implements NamingStrategy {
    protected static final int MAXIMUM_IDENTIFIER_LENGTH = 30;
    protected BiMap<String, String> identifierToShortenedIdentifier = HashBiMap.create();

    protected String getShortenedIdentifier(String value) {
        String reducedValue = value;
        if (value.length() > 30 && (reducedValue = (String)this.identifierToShortenedIdentifier.get((Object)value)) == null) {
            reducedValue = this.shortenIdentifier(value);
            this.checkConflict(value, reducedValue);
            this.identifierToShortenedIdentifier.put((Object)value, (Object)reducedValue);
        }
        return reducedValue;
    }

    protected void checkConflict(String value, String reducedValue) {
        boolean conflictInShortenedIdentifier = this.identifierToShortenedIdentifier.inverse().containsKey((Object)reducedValue);
        if (conflictInShortenedIdentifier) {
            String otherIdentifier = (String)this.identifierToShortenedIdentifier.inverse().get((Object)reducedValue);
            throw new HibernateException("error while using this naming strategy, a conflict occurred when short identifier for '" + value + "' was computed. Generated short identifier (" + reducedValue + ") is already used for identifier " + otherIdentifier);
        }
    }

    protected String shortenIdentifier(String identifier) {
        Iterable split = Splitter.on((char)'_').split((CharSequence)identifier);
        int numberOfElements = Iterables.size((Iterable)split);
        int numberOfUnderscores = numberOfElements - 1;
        int acceptedLengthForAnElement = (30 - numberOfUnderscores) / numberOfElements;
        LinkedList reducedElements = Lists.newLinkedList();
        for (String element : split) {
            reducedElements.add(StringUtils.left((String)element, (int)acceptedLengthForAnElement));
        }
        String reducedIdentifier = Joiner.on((char)'_').join((Iterable)reducedElements);
        return reducedIdentifier;
    }

    public String classToTableName(String className) {
        return this.getShortenedIdentifier(super.classToTableName(className));
    }

    public String propertyToColumnName(String propertyName) {
        return this.getShortenedIdentifier(super.propertyToColumnName(propertyName));
    }

    public String tableName(String tableName) {
        return this.getShortenedIdentifier(super.tableName(tableName));
    }

    public String columnName(String columnName) {
        return this.getShortenedIdentifier(super.columnName(columnName));
    }

    public String collectionTableName(String ownerEntity, String ownerEntityTable, String associatedEntity, String associatedEntityTable, String propertyName) {
        return this.getShortenedIdentifier(super.collectionTableName(ownerEntity, ownerEntityTable, associatedEntity, associatedEntityTable, propertyName));
    }

    public String joinKeyColumnName(String joinedColumn, String joinedTable) {
        return this.getShortenedIdentifier(super.joinKeyColumnName(joinedColumn, joinedTable));
    }

    public String foreignKeyColumnName(String propertyName, String propertyEntityName, String propertyTableName, String referencedColumnName) {
        return this.getShortenedIdentifier(super.foreignKeyColumnName(propertyName, propertyEntityName, propertyTableName, referencedColumnName));
    }

    public String logicalColumnName(String columnName, String propertyName) {
        return this.getShortenedIdentifier(super.logicalColumnName(columnName, propertyName));
    }

    public String logicalCollectionTableName(String tableName, String ownerEntityTable, String associatedEntityTable, String propertyName) {
        return this.getShortenedIdentifier(super.logicalCollectionTableName(tableName, ownerEntityTable, associatedEntityTable, propertyName));
    }

    public String logicalCollectionColumnName(String columnName, String propertyName, String referencedColumn) {
        return this.getShortenedIdentifier(super.logicalCollectionColumnName(columnName, propertyName, referencedColumn));
    }
}

