package org.nuiton.jaxx.plugin;

import jaxx.compiler.decorators.HelpRootCompiledObjectDecorator;
import org.apache.maven.plugin.MojoFailureException;

import java.io.File;
import java.util.Locale;
import java.util.Set;

/**
 * Generate the help ids files from the previous jaxx generation.
 * <p/>
 * Created: 22 déc. 2009
 *
 * @author Tony Chemit <chemit@codelutin.com> Copyright Code Lutin
 * @author chemit
 * @version $Revision: 1720 $
 *          <p/>
 *          Mise a jour: $Date: 2010-01-19 18:50:08 +0100 (mar., 19 janv. 2010) $ par :
 *          $Author: tchemit $
 * @goal generate-help-ids
 * @phase process-sources
 * @requiresProject
 * @since 2.0.0
 */
public class GenerateHelpIdsMojo extends AbstractGenerateHelpMojo {

    /**
     * help ids to react.
     */
    protected Set<String> helpIds;

    @Override
    public void init() throws Exception {
        if (!generateHelp) {

            return;
        }

        super.init();

        // check there is some bundle
        if (getHelpIdsFilename() == null) {
            throw new MojoFailureException("you must set the 'helpIdStore' property.");
        }
        if (getMergeHelpIdsFilename() == null) {
            throw new MojoFailureException("you must set the 'helpIdStoreAll' property.");
        }

        helpIds = HelpRootCompiledObjectDecorator.getHelpIds();

        // always clean helpIdsStore before all
        cleanHelpIdsStore();

    }

    @Override
    protected boolean checkSkip() {
        boolean b = super.checkSkip();
        if (b) {

            if (helpIds.isEmpty()) {
//            if (isVerbose()) {
                // no ids detected in this compilation round
                getLog().info("No help ids to treate, will skip goal.");
//            }
                return false;
            }
        }
        return b;
    }

    @Override
    public void doAction() throws Exception {

        // store current jaxx session detected help ids

        File idsStore = getHelpIdsStoreFile();
        getLog().info("Store detected help ids to " + idsStore);

        storeHelpIds(idsStore, helpIds);

        // store merged help ids (to make possible a force on help generation)


        File idsStoreAll = getMergeHelpIdsStoreFile();
        getLog().info("Merge help ids to " + idsStoreAll);

        if (idsStoreAll.exists()) {
            Set<String> allIds = loadHelpIds(idsStoreAll);
            helpIds.addAll(allIds);
            allIds.clear();
        }

        storeHelpIds(idsStoreAll, helpIds);

        helpIds.clear();

    }

    @Override
    protected void doActionForLocale(Locale locale, boolean isDefaultLocale, File source, String localePath) throws Exception {
        // nothing to do specific to locale
    }

    @Override
    protected void postDoAction() {
    }

    @Override
    public File getTargetDirectory() {
        return getOutputHelpIds();
    }

    @Override
    public void setTargetDirectory(File targetDirectory) {
        setOutputHelpIds(targetDirectory);
    }
}
