/* *##% 
 * JAXX Maven plugin
 * Copyright (C) 2008 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*/
package org.nuiton.jaxx.plugin;

import org.apache.maven.project.MavenProject;

import java.io.File;
import org.nuiton.plugin.AbstractPlugin;

/**
 * Abract Jaxx Mojo.
 *
 * @author chemit
 *
 * @since 1.3
 */
public abstract class AbstractJaxxMojo extends AbstractPlugin {

    public abstract File getTargetDirectory();

    public abstract void setTargetDirectory(File targetDirectory);
    /**
     * Dépendance du projet.
     *
     * @parameter default-value="${project}"
     * @required
     * @readonly
     */
    protected MavenProject project;
    /**
     * Encoding pour la generation des fichiers
     *
     * @parameter expression="${jaxx.encoding}" default-value="${project.build.sourceEncoding}"
     * @since 2.0.0
     */
    protected String encoding;
    /**
     * verbose flag
     *
     * @parameter expression="${jaxx.verbose}" default-value="false"
     *
     * @since 1.3
     */
    protected boolean verbose;
    /**
     * The store of helpIds generated by the goal {@link GenerateMojo} and then
     * used by the goal {@link GenerateHelpMojo}.
     * 
     * @parameter expression="${jaxx.helpIdsStore}" default-value="target/generated-sources/jaxx/helpIds.properties"
     * @required
     *
     * @since 1.3
     */
    protected File helpIdsStore;

    @Override
    protected boolean checkPackaging() {
        return project != null && !"pom".equals(project.getPackaging()) && !"site".equals(project.getPackaging());
    }

    @Override
    public MavenProject getProject() {
        return project;
    }

    @Override
    public boolean isVerbose() {
        return verbose;
    }

    @Override
    public void setProject(MavenProject project) {
        this.project = project;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public File getHelpIdsStore() {
        return helpIdsStore;
    }

    public void setHelpIdsStore(File helpIdsStore) {
        this.helpIdsStore = helpIdsStore;
    }

    public String getEncoding() {
        return encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}
