/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing.wizard;

import java.awt.Component;
import java.lang.reflect.Array;
import java.util.List;
import javax.swing.JTabbedPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.runtime.swing.wizard.WizardModel;
import org.nuiton.jaxx.runtime.swing.wizard.WizardStep;
import org.nuiton.jaxx.runtime.swing.wizard.WizardStepUI;
import org.nuiton.jaxx.runtime.swing.wizard.WizardUI;

public class WizardUtil {
    private static final Log log = LogFactory.getLog(WizardUI.class);

    protected WizardUtil() {
    }

    public static void addDebugLogListener(Log log, WizardModel<?> model) {
        if (log.isDebugEnabled()) {
            model.addPropertyChangeListener(evt -> log.debug((Object)(evt.getPropertyName() + " <" + evt.getOldValue() + " - " + evt.getNewValue() + ">")));
        }
    }

    public static void addTraceLogListener(Log log, WizardModel<?> model) {
        if (log.isTraceEnabled()) {
            model.addPropertyChangeListener(evt -> log.trace((Object)(evt.getPropertyName() + " <" + evt.getOldValue() + " - " + evt.getNewValue() + ">")));
        }
    }

    public static <E extends WizardStep, M extends WizardModel<E>> void installWizardUIListeners(WizardUI<E, M> ui) {
        ((WizardModel)ui.getModel()).addPropertyChangeListener(evt -> {
            String propertyName = evt.getPropertyName();
            if ("steps".equals(propertyName)) {
                List steps = (List)evt.getNewValue();
                ui.onStepsChanged(steps.toArray((WizardStep[])Array.newInstance(((WizardModel)ui.getModel()).stepClass, steps.size())));
                return;
            }
            if ("step".equals(propertyName)) {
                ui.onStepChanged((WizardStep)evt.getOldValue(), (WizardStep)evt.getNewValue());
            }
        });
    }

    public static <E extends WizardStep, M extends WizardModel<E>> void addTabsDisplayUntilStepListener(WizardUI<E, M> ui) {
        ((WizardModel)ui.getModel()).addPropertyChangeListener("step", evt -> {
            WizardModel model = (WizardModel)evt.getSource();
            WizardStep oldStep = (WizardStep)evt.getOldValue();
            WizardStep newStep = (WizardStep)evt.getNewValue();
            log.debug((Object)("step has changed <old:" + oldStep + ", new:" + newStep + ">"));
            int oldStepIndex = oldStep == null ? -1 : model.getStepIndex(oldStep);
            int newStepIndex = model.getStepIndex(newStep);
            JTabbedPane tabs = ui.getTabs();
            if (oldStepIndex + 1 == newStepIndex) {
                WizardStepUI c = ui.getStepUI(newStep);
                String title = I18n.t((String)newStep.getLabel(), (Object[])new Object[0]);
                String tip = I18n.t((String)newStep.getDescription(), (Object[])new Object[0]);
                tabs.addTab(title, null, (Component)((Object)c), tip);
                int index = tabs.indexOfComponent((Component)((Object)c));
                if (index > -1) {
                    tabs.setSelectedIndex(index);
                }
            } else if (oldStepIndex > newStepIndex) {
                int index = newStepIndex + 1;
                while (tabs.getTabCount() > index) {
                    log.trace((Object)("remove tab : " + index));
                    tabs.remove(index);
                }
            } else {
                throw new IllegalStateException("can not go from " + oldStep + " to " + newStep);
            }
        });
    }
}

