/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.api.swing;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.plaf.LayerUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.runtime.api.JAXXObject;

public class JLayers {
    private static final Log log = LogFactory.getLog(JLayers.class);

    public static <V extends Component> JLayer<V> boxComponentWithJLayer(V component) {
        JLayer<V> layer = JLayers.getLayer(component);
        if (layer == null) {
            layer = new JLayer();
            layer.setView(component);
        }
        return layer;
    }

    public static List<Component> getLayeredComponents(JAXXObject object) {
        ArrayList<Component> result = new ArrayList<Component>();
        for (Map.Entry<String, Object> child : object.get$objectMap().entrySet()) {
            JComponent comp;
            if (child.getValue() == null) {
                log.warn((Object)("find a null object in $objectMap " + child.getKey()));
                continue;
            }
            if (!JComponent.class.isAssignableFrom(child.getValue().getClass()) || !JLayers.isLayered(comp = (JComponent)child.getValue())) continue;
            result.add(comp);
        }
        return result;
    }

    public static <V extends Component> JLayer<V> getLayer(V comp) {
        if (!JLayers.isLayered(comp)) {
            return null;
        }
        return (JLayer)comp.getParent();
    }

    public static <V extends Component> void setLayerUI(Component comp, LayerUI<V> ui) {
        JLayer<Component> layer = JLayers.getLayer(comp);
        if (layer != null) {
            layer.setUI(ui);
        }
    }

    public static boolean isLayered(Component comp) {
        Container parent = comp.getParent();
        return parent != null && parent instanceof JLayer;
    }
}

