package jaxx.runtime.validator.field;

import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.validators.FieldValidatorSupport;

import java.io.File;

/**
 * <!-- START SNIPPET: javadoc -->
 * ExistingFileFieldValidator checks that a File field exists. *
 * <!-- END SNIPPET: javadoc -->
 * <p/>
 * <p/>
 * <!-- START SNIPPET: parameters -->
 * <ul>
 * <li>fieldName - The field name this validator is validating. Required if using Plain-Validator Syntax otherwise not required</li>
 * </ul>
 * <!-- END SNIPPET: parameters -->
 * <p/>
 * <p/>
 * <pre>
 * <!-- START SNIPPET: examples -->
 *     &lt;validators&gt;
 *         &lt;!-- Plain-Validator Syntax --&gt;
 *         &lt;validator type="fileExisting"&gt;
 *             &lt;param name="fieldName"&gt;tmp&lt;/param&gt;
 *             &lt;message&gt;tmp is not an existing file&lt;/message&gt;
 *         &lt;/validator&gt;
 * <p/>
 *         &lt;!-- Field-Validator Syntax --&gt;
 *         &lt;field name="tmp"&gt;
 *         	  &lt;field-validator type="fileExisting"&gt;
 *                 &lt;message&gt;tmp is not an existing file&lt;/message&gt;
 *            &lt;/field-validator&gt;
 *         &lt;/field&gt;
 *     &lt;/validators&gt;
 * <!-- END SNIPPET: examples -->
 * </pre>
 *
 * @author chemit
 */
public class ExistingFileFieldValidator extends FieldValidatorSupport {

    public void validate(Object object) throws ValidationException {
        String fieldName = getFieldName();
        Object value = this.getFieldValue(fieldName, object);
        if (value == null) {
            // no value defined
            addFieldError(fieldName, object);
            return;
        }
        File f;
        if (value instanceof File) {
            f = (File) value;
        } else if (value instanceof String) {
            f = new File((String) value);
        } else {
            addFieldError(fieldName, object);
            return;
        }

        if (!(f.isFile() && f.exists())) {
            // f is  not a file nor exists
            addFieldError(fieldName, object);
        }
    }

    @Override
    public String getValidatorType() {
        return "existingFile";
    }
}
