package jaxx.runtime.validator;

import static org.nuiton.i18n.I18n.n_;

/**
 * The differents levels of messages in validation process.
 * <p/>
 * The order of the enum defines the severity of validation.
 * <p/>
 * Always begin with error, then if no error found, try warning, then info...
 *
 * @author chemit
 */
public enum BeanValidatorScope {

    /**
     * the error scope level.
     *
     * When a message of a such scope is found on a validator, then the validator
     * is invalid and modified.
     */
    ERROR(n_("validator.scope.error.label")),
    /**
     * the warning scope level.
     *
     * When a message of a such scope is found on a validator, then the validator
     * is still valid but modified.
     */
    WARNING(n_("validator.scope.warning.label")),
    /**
     * the information scope level.
     *
     * When a message of a sucg scope is found on a validator, then the
     * validator is still valid and not modified.
     */
    INFO(n_("validator.scope.info.label"));
    private final String label;

    private BeanValidatorScope(String label) {
        this.label = label;
    }

    public String getLabel() {
        return label;
    }
}
