/*
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2014 Code Lutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package jaxx.demo.component.jaxx.editor;

import org.jdesktop.beans.AbstractSerializableBean;

/**
 * @author Tony Chemit - chemit@codelutin.com
 * @since 1.5
 */
public class NumberEditorDemoModel extends AbstractSerializableBean {

    public static final String INTEGER_PROPERTY = "integerProperty";

    public static final String FLOAT_PROPERTY = "floatProperty";

    private static final long serialVersionUID = 1L;

    protected int integerProperty;

    protected float floatProperty;

    public float getFloatProperty() {
        return floatProperty;
    }

    public int getIntegerProperty() {
        return integerProperty;
    }

    public void setFloatProperty(float floatProperty) {
        float old = this.floatProperty;
        this.floatProperty = floatProperty;
        firePropertyChange(FLOAT_PROPERTY, old, floatProperty);
    }

    public void setIntegerProperty(int integerProperty) {
        int old = this.integerProperty;
        this.integerProperty = integerProperty;
        firePropertyChange(INTEGER_PROPERTY, old, integerProperty);
    }
}
