/*
 * *##% 
 * JAXX Demo
 * Copyright (C) 2008 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package jaxx.demo.component.jaxx.navigation;

import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.*;
import java.util.Arrays;
import java.util.List;

/**
 *
 * @author chemit
 * @since 1.7.2
 */
public class FullNavigationTreeHelper extends NavigationTreeHelper {

//    static {
//        // register decorator one for all
//
//        DecoratorUtils.register(
//                Movie.class.getSimpleName(),
//                DecoratorUtils.newMultiJXPathDecorator(Movie.class, "${title}$s##${year}$s", "##", " - "));
//
//        DecoratorUtils.register(
//                People.class.getSimpleName(),
//                DecoratorUtils.newMultiJXPathDecorator(People.class, "${firstName}$s##${lastName}$s", "##", " "));
//    }
    /**
     * Logger
     */
    static private final Log log = LogFactory.getLog(FullNavigationTreeHelper.class);
    /**
     * where the movies are hold in context
     */
    static public final JAXXContextEntryDef<List<Movie>> MOVIES = JAXXUtil.newListContextEntryDef("movies");
    /**
     * where the actors are hold in context
     */
    static public final JAXXContextEntryDef<List<People>> ACTORS = JAXXUtil.newListContextEntryDef("actors");
    protected FullNavigationTreeModelBuilder builder;

    public FullNavigationTreeHelper() {
        super("full");
    }

    /**
     * Create the model and store it in the given context.
     *
     * @param context the context where to hold the model
     */
    public void createModel(JAXXContext context) {
        log.info("for " + this);
        People a = new People("0", "Jack", "Black", 0, "/jaxx/demo/images/jack.jpg");
        People a2 = new People("1", "Héctor", "Jiménez", 0, "/jaxx/demo/images/hector.jpg");
        People a3 = new People("2", "Ana", "de la Reguera", 0, "/jaxx/demo/images/ana.jpg");

        Movie m = new Movie("0", "Nacho libre", 1996, "/jaxx/demo/images/nacho.jpg");
        m.addActor(a);
        m.addActor(a2);
        m.addActor(a3);

        Movie m2 = new Movie("1", "Nacho 2", 2009, "/jaxx/demo/images/nacho2.png");
        m2.addActor(a);
        m2.addActor(a2);

        MOVIES.setContextValue(context, Arrays.asList(m, m2));
        ACTORS.setContextValue(context, Arrays.asList(a, a2, a3));
    }

    @Override
    public NavigationTreeModel createTreeModel(JAXXContext context) {

        if (builder == null) {
            builder = new FullNavigationTreeModelBuilder(context);
        }

        builder.createInitialModel();

        NavigationTreeModel model = builder.getModel();

        // save tree model in context
        setModel(context, model);
        return model;
    }

    @Override
    public NavigationTreeHandler createTreeHandler(JAXXObject context) {

        if (log.isDebugEnabled()) {
            log.debug("create handler");
        }

        NavigationTreeHandler handler;

        handler = new NavigationTreeHandlerWithCardLayout(
                getPrefix(),
                context,
                NavigationTreeHandler.Strategy.PER_UI_TYPE) {

            private static final long serialVersionUID = 1L;

            @Override
            protected NavigationModel getNavigationTreeModel() {
                return getSafeModel(getContext());
            }

            @Override
            protected JPanel getContentContainer() {
                return getContext().getContent();
            }

            @Override
            protected CardLayout2 getContentLayout() {
                return getContext().getContentLayout();
            }

            @Override
            protected void treateError(Exception e) {
                ErrorDialogUI.showError(e);
            }

            @Override
            public FullNavigationTreeDemo getContext() {
                return (FullNavigationTreeDemo) this.context;
            }
        };
        // on ne peut selectionner qu'un seul noeud a la fois
        handler.setSelectionMode(NavigationTreeHandler.SINGLE_TREE_SELECTION);

        // save handler in ui context
        setTreeHandler(context, handler);
        return handler;
    }
}
