package jaxx.demo;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import java.util.Locale;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.demo.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.navigation.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class DemoUI extends javax.swing.JFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_MAIN_FRAME_UNDECORATED = "mainFrame.undecorated";
    public static final String BINDING_MENU_FILE_FULLSCREEN_VISIBLE = "menuFileFullscreen.visible";
    public static final String BINDING_MENU_FILE_LANGUAGE_FR_ENABLED = "menuFileLanguageFR.enabled";
    public static final String BINDING_MENU_FILE_LANGUAGE_UK_ENABLED = "menuFileLanguageUK.enabled";
    public static final String BINDING_MENU_FILE_NORMALSCREEN_VISIBLE = "menuFileNormalscreen.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVYzU8bRxRfG8xnCIQAIQlJDWkrkMICSdVWImpDCA4Q8yEMaRSk0rF3sCdZ7252Z8HEStU/oX9Ce++lUm89VT303EMvVf+Fquqh16pvZj9nPcarREXCmJnfe/N+v3nzZt9+96eSc2xl+jlqNFTbNSipY3Vz5enTnfJzXKEPsVOxiUVNW/F+Mlkle6gMauG4Q5Vbh0VmvuCbL6yadcs0sBGzXi4qAw4907FTw5hS5YZoUXGchVI4vdywXDvwGgYl8/rN339lv9a++jarKA0LorsCVPKdrCIm3UUlSzSqjMJKJ2hBR0YVwrCJUYV4h9jYqo4cZxvV8UvlS6W3qPRYyAZnVJlJT5n74PYNiyr9dUSMgg0uqTLCQ9Vw3VQfwsfBhmVxYA9VhiqmQcFfEZ2ZLqx3U2DlnEKM6iqyNW/+TmTYXceGS5UxFn3DB25uwdgDZEeoPoYqEB2CuNSCZJjhEDoeQFdN45hUXRtRArEp4y12GxTXmdFoaDsS2BZBWhdVuYxjImY0iSnssZkr7GOyPergsQR14d3NEoYtQqD/IlUmhBDDmTbrF1xdh83D2Ag9R6ixALVt2nXUHhePYImN5RPzgZ+1BqESe74x61i3QqWGRVs2F8xz27nW+RKhWDI/FMyvlCFnJIA+lpu7yICsGBWkY2M6A/WH2H7H0gn1wAmdgwmGXAoNLhrohFR58nhWV0Srim3qemD2QWg2EJklc3Uf9oChPgrBvf6pYf/eFf1k4Oy9JzlEJYqo62xhx4GkCnlC2LZyXYBDjVKjGhUVkcyhkrNdGKbK5GFrWduDKa+gTSYKGnPIZ/+duPzbj3/8UAiq2HVYe1wKjRVhqC6WbVrYpoQtPeyVMJcSfWELWcuHsEFYhwrOK/SUJLCSPw3BwXpcWZWZq+vIqYGLXO/vP/088cWvXUq2oAzoJtIKiOE3lH5as0EFU9ca1qf3eUQXTvvgcwR+uyA1jgFNUZlVl9wxHBb422Na6KUbGxgqm7aG7V3IOIq1YLwBOk1JdAqDLff/8s/l0vf3A60yEPvVtvBIr9wzpYcYOjEwr/l+OZfW+EHLwa5mRmVbVsgVSKe+zX3T1KO6+oh/PpZJMsISkxiu6TpBRe+mNtNjFK6NfdOt1NYaFjI0TzV/blAjJwREKpFX8F/mwwYvzSVOm307YFEMRAeucxw5SihboJ9d8Xl26cB3AsFt1CH9qfJ5U9CyxI7IAUsKqHeI4g1AzgLOuwpm51T4vmOxszk7gywIo8IPqso8qhaitZk5juHeZ+deAyXX0HDFhPrINn2qGXdGHFaCS7y0AriVbfz2tDqQzQDZoxoUOxC/OeMSlVmqrALOSD3ze7OT0y62NbhBeX1sNPjNzezUY36V9tUNGDFIBTarEK0/Lq7PwfIgwmu5UyC5MJAbYSBwOpn2FfGajse0CtniodhGwqH0sLArFBJ5n1j73OX0uS5VCo83IbdbEm4iXs5U/lSRnvbVVv1V3ayg5DYkKfdTGxmODumXZH2ex4DtlIytB5LTbHkA6sSQXWLYYFUAjsdScxpVKtiiRb5E8uT5o3O38zPH9lFhb4YdsBZ9/D30olSP7ZY0FfTpJUsfG/MMJarTkmahPzEf3mmvEGDlIkmeAP8nmbBx9OhBGpncF6JMB1KZGCqdTO6L9DK5L1LKdPA4hUw+0WvJwI7Dp11gc0Icwi+e0eY0cQ6iEs1rdlyI3YQQA3E/ohY32y8pipGXiRGBO6gRPbanV2MqGZoRe6qP63Gpeb4c2wk5RnSMTvB8e1Hy560syvK+NEcS/uXiSLuV9MV1LBkkhmZFJP40Qbzbg4hkJ2V+RJLXZCQZTE5MaJ/e+Lb2lo7Twe1vazZ6zm3N+qm3UFYaiqisB+mgLAOdryxHtCcjNJdvQcghNHEFO0lCHqQDIQZKQYjBOhBi3XB6QuPJQFCZP67HGa0kGOV8TLsHirgnkdN1GSeOk5MSW/hOrLrjpczvKcSnIejiTudlCdZSIRlyPUyydt2b5JAEhilO62CdGKTu1r1+Z6Jp4NP8Q+hDDId1GHfuLt5eZAW4x1scvjQNKIQwcrVm2uQVMEK69x4BmrJdE9qRM6rMNmPvFtT1nb2NZzvb+yvFo9Lq3k6x+GBl72h77cnanlTvxEuLFIIP2qZJnwSiB91u/zEEN+9wXtmlJdgGHdlVvGVqWA+3ZoRJ5eyB/Tp0gvyNQntdY+9F0igL+sBl5PcEN5pRzygoslvc2Ac5L0B7D6F+hkm1BrnQtaQuRil7OUrZsqmdqVpZnqreCyIrhWrQquVdB+8Y+pkvXPQ6Ndh9XyTpmRBelXZaLAtpo/st+HBTMH0tfSTxSaonBJ+qPl7OOHj7lIJvT83XdvSe91Yijyi1Sdml+JMW1xn2OZCm4T0lGq3BdEZ/cyehOhfvaYiifJkYGjGqbcK6kyasOktzFtap3MlyCicXvddZkApbKbz9B0sChLDXGAAA";
    protected static final Log log = LogFactory.getLog(jaxx.demo.DemoUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel content;
    protected jaxx.runtime.swing.CardLayout2 contentLayout;
    protected DemoUI mainFrame = this;
    protected javax.swing.JPanel mainPane;
    protected javax.swing.JMenuBar menu;
    protected javax.swing.JMenu menuFile;
    protected javax.swing.JMenuItem menuFileConfiguration;
    protected javax.swing.JMenuItem menuFileExit;
    protected javax.swing.JMenuItem menuFileFullscreen;
    protected javax.swing.JMenu menuFileLanguage;
    protected javax.swing.JMenuItem menuFileLanguageFR;
    protected javax.swing.JMenuItem menuFileLanguageUK;
    protected javax.swing.JMenuItem menuFileNormalscreen;
    protected javax.swing.JMenu menuHelp;
    protected javax.swing.JMenuItem menuHelpAbout;
    protected javax.swing.JMenuItem menuHelpHelp;
    protected javax.swing.JMenuItem menuHelpSite;
    protected javax.swing.JTree navigation;
    protected javax.swing.JScrollPane navigationPane;
    protected jaxx.runtime.swing.StatusMessagePanel p;
    protected javax.swing.JSplitPane splitPane;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JSeparator $JSeparator0;
    private javax.swing.JSeparator $JSeparator1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    public DemoConfig getConfig() {
        return getContextValue(DemoConfig.class);
    }
    
    protected DemoUIHandler getHandler() {
        return getContextValue(DemoUIHandler.class);
    }
    
    protected DemoTreeHelper getTreeHelper() {
        return getContextValue(DemoTreeHelper.class);
    }
    
    public boolean acceptLocale(Locale l, String expected) {
      return l !=null && l.toString().equals(expected);
    }
    
    private void $afterCompleteSetup() {
        // share the tree
        getTreeHelper().setTree(this, navigation);
        // auto-expand node when selected
        SwingUtil.addExpandOnClickListener(navigation);
        
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DemoUI() {
        $initialize();
    }

    public DemoUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__menuFileConfiguration(java.awt.event.ActionEvent event) {
        getHandler().showConfig(this);
    }

    public void doActionPerformed__on__menuFileExit(java.awt.event.ActionEvent event) {
        getHandler().close(this);
    }

    public void doActionPerformed__on__menuFileFullscreen(java.awt.event.ActionEvent event) {
        getHandler().changeScreen(this, true);
    }

    public void doActionPerformed__on__menuFileLanguageFR(java.awt.event.ActionEvent event) {
        getHandler().changeLanguage(this, Locale.FRANCE);
    }

    public void doActionPerformed__on__menuFileLanguageUK(java.awt.event.ActionEvent event) {
        getHandler().changeLanguage(this, Locale.UK);
    }

    public void doActionPerformed__on__menuFileNormalscreen(java.awt.event.ActionEvent event) {
        getHandler().changeScreen(this, false);
    }

    public void doActionPerformed__on__menuHelpAbout(java.awt.event.ActionEvent event) {
        getHandler().showAbout(this);
    }

    public void doActionPerformed__on__menuHelpHelp(java.awt.event.ActionEvent event) {
        getHandler().showHelp(this, null);
    }

    public void doActionPerformed__on__menuHelpSite(java.awt.event.ActionEvent event) {
        getHandler().gotoSite(this);
    }

    public void doWindowClosing__on__mainFrame(java.awt.event.WindowEvent event) {
        getHandler().close(mainFrame);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JPanel getContent() {
        return content;
    }

    public jaxx.runtime.swing.CardLayout2 getContentLayout() {
        return contentLayout;
    }

    public javax.swing.JPanel getMainPane() {
        return mainPane;
    }

    public javax.swing.JMenuBar getMenu() {
        return menu;
    }

    public javax.swing.JMenu getMenuFile() {
        return menuFile;
    }

    public javax.swing.JMenuItem getMenuFileConfiguration() {
        return menuFileConfiguration;
    }

    public javax.swing.JMenuItem getMenuFileExit() {
        return menuFileExit;
    }

    public javax.swing.JMenuItem getMenuFileFullscreen() {
        return menuFileFullscreen;
    }

    public javax.swing.JMenu getMenuFileLanguage() {
        return menuFileLanguage;
    }

    public javax.swing.JMenuItem getMenuFileLanguageFR() {
        return menuFileLanguageFR;
    }

    public javax.swing.JMenuItem getMenuFileLanguageUK() {
        return menuFileLanguageUK;
    }

    public javax.swing.JMenuItem getMenuFileNormalscreen() {
        return menuFileNormalscreen;
    }

    public javax.swing.JMenu getMenuHelp() {
        return menuHelp;
    }

    public javax.swing.JMenuItem getMenuHelpAbout() {
        return menuHelpAbout;
    }

    public javax.swing.JMenuItem getMenuHelpHelp() {
        return menuHelpHelp;
    }

    public javax.swing.JMenuItem getMenuHelpSite() {
        return menuHelpSite;
    }

    public javax.swing.JTree getNavigation() {
        return navigation;
    }

    public javax.swing.JScrollPane getNavigationPane() {
        return navigationPane;
    }

    public jaxx.runtime.swing.StatusMessagePanel getP() {
        return p;
    }

    public javax.swing.JSplitPane getSplitPane() {
        return splitPane;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected javax.swing.JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToMainFrame() {
        if (!allComponentsCreated) {
            return;
        }
        add(mainPane);
        mainFrame.setJMenuBar(menu);
    }

    protected void addChildrenToMainPane() {
        if (!allComponentsCreated) {
            return;
        }
        mainPane.add(splitPane, BorderLayout.CENTER);
        mainPane.add(p, BorderLayout.SOUTH);
    }

    protected void addChildrenToMenu() {
        if (!allComponentsCreated) {
            return;
        }
        menu.add(menuFile);
        menu.add(menuHelp);
    }

    protected void addChildrenToMenuFile() {
        if (!allComponentsCreated) {
            return;
        }
        menuFile.add(menuFileConfiguration);
        menuFile.add(menuFileLanguage);
        menuFile.add($JSeparator0);
        menuFile.add(menuFileFullscreen);
        menuFile.add(menuFileNormalscreen);
        menuFile.add($JSeparator1);
        menuFile.add(menuFileExit);
    }

    protected void addChildrenToMenuFileLanguage() {
        if (!allComponentsCreated) {
            return;
        }
        menuFileLanguage.add(menuFileLanguageFR);
        menuFileLanguage.add(menuFileLanguageUK);
    }

    protected void addChildrenToMenuHelp() {
        if (!allComponentsCreated) {
            return;
        }
        menuHelp.add(menuHelpHelp);
        menuHelp.add(menuHelpSite);
        menuHelp.add(menuHelpAbout);
    }

    protected void addChildrenToNavigationPane() {
        if (!allComponentsCreated) {
            return;
        }
        navigationPane.getViewport().add(navigation);
    }

    protected void addChildrenToSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        splitPane.add(navigationPane, JSplitPane.LEFT);
        splitPane.add(content, JSplitPane.RIGHT);
    }

    protected void createContent() {
        $objectMap.put("content", content = new javax.swing.JPanel());
        content.setName("content");
        content.setLayout(contentLayout);
        content.putClientProperty("help", "ui.main.body.db.view.content");
    }

    protected void createContentLayout() {
        $objectMap.put("contentLayout", contentLayout = new jaxx.runtime.swing.CardLayout2());
        contentLayout.setUseOnlyVisibleComponentDimension(true);
    }

    protected void createMainPane() {
        $objectMap.put("mainPane", mainPane = new javax.swing.JPanel());
        mainPane.setName("mainPane");
        mainPane.setLayout(new BorderLayout());
    }

    protected void createMenu() {
        $objectMap.put("menu", menu = new javax.swing.JMenuBar());
        menu.setName("menu");
        menu.putClientProperty("help", "ui.main.menu");
    }

    protected void createMenuFile() {
        $objectMap.put("menuFile", menuFile = new javax.swing.JMenu());
        menuFile.setName("menuFile");
        menuFile.setText(_("jaxxdemo.menu.file"));
        menuFile.setMnemonic(70);
        menuFile.putClientProperty("help", "ui.main.menu.file");
    }

    protected void createMenuFileConfiguration() {
        $objectMap.put("menuFileConfiguration", menuFileConfiguration = new javax.swing.JMenuItem());
        menuFileConfiguration.setName("menuFileConfiguration");
        menuFileConfiguration.setText(_("jaxxdemo.action.configuration"));
        menuFileConfiguration.setMnemonic(67);
        menuFileConfiguration.setToolTipText(_("jaxxdemo.action.configuration.tip"));
        menuFileConfiguration.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileConfiguration"));
        menuFileConfiguration.putClientProperty("help", "ui.main.menu.file.configuration");
    }

    protected void createMenuFileExit() {
        $objectMap.put("menuFileExit", menuFileExit = new javax.swing.JMenuItem());
        menuFileExit.setName("menuFileExit");
        menuFileExit.setText(_("jaxxdemo.action.exit"));
        menuFileExit.setMnemonic(88);
        menuFileExit.setToolTipText(_("jaxxdemo.action.exit.tip"));
        menuFileExit.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileExit"));
        menuFileExit.putClientProperty("help", "ui.main.menu.file.exit");
    }

    protected void createMenuFileFullscreen() {
        $objectMap.put("menuFileFullscreen", menuFileFullscreen = new javax.swing.JMenuItem());
        menuFileFullscreen.setName("menuFileFullscreen");
        menuFileFullscreen.setText(_("jaxxdemo.action.fullscreen"));
        menuFileFullscreen.setMnemonic(80);
        menuFileFullscreen.setToolTipText(_("jaxxdemo.action.fullscreen.tip"));
        menuFileFullscreen.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileFullscreen"));
        menuFileFullscreen.putClientProperty("help", "ui.main.menu.file.fullscreen");
    }

    protected void createMenuFileLanguage() {
        $objectMap.put("menuFileLanguage", menuFileLanguage = new javax.swing.JMenu());
        menuFileLanguage.setName("menuFileLanguage");
        menuFileLanguage.setText(_("jaxxdemo.menu.file.locale"));
        menuFileLanguage.setMnemonic(67);
        menuFileLanguage.setToolTipText(_("jaxxdemo.menu.file.locale"));
        menuFileLanguage.putClientProperty("help", "ui.main.menu.file.locale");
    }

    protected void createMenuFileLanguageFR() {
        $objectMap.put("menuFileLanguageFR", menuFileLanguageFR = new javax.swing.JMenuItem());
        menuFileLanguageFR.setName("menuFileLanguageFR");
        menuFileLanguageFR.setText(_("jaxxdemo.action.locale.fr"));
        menuFileLanguageFR.setMnemonic(70);
        menuFileLanguageFR.setToolTipText(_("jaxxdemo.action.locale.fr.tip"));
        menuFileLanguageFR.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileLanguageFR"));
        menuFileLanguageFR.putClientProperty("help", "ui.main.menu.file.locale.fr");
    }

    protected void createMenuFileLanguageUK() {
        $objectMap.put("menuFileLanguageUK", menuFileLanguageUK = new javax.swing.JMenuItem());
        menuFileLanguageUK.setName("menuFileLanguageUK");
        menuFileLanguageUK.setText(_("jaxxdemo.action.locale.uk"));
        menuFileLanguageUK.setMnemonic(85);
        menuFileLanguageUK.setToolTipText(_("jaxxdemo.action.locale.uk.tip"));
        menuFileLanguageUK.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileLanguageUK"));
        menuFileLanguageUK.putClientProperty("help", "ui.main.menu.file.locale.uk");
    }

    protected void createMenuFileNormalscreen() {
        $objectMap.put("menuFileNormalscreen", menuFileNormalscreen = new javax.swing.JMenuItem());
        menuFileNormalscreen.setName("menuFileNormalscreen");
        menuFileNormalscreen.setText(_("jaxxdemo.action.normalscreen"));
        menuFileNormalscreen.setMnemonic(78);
        menuFileNormalscreen.setToolTipText(_("jaxxdemo.action.normalscreen.tip"));
        menuFileNormalscreen.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileNormalscreen"));
        menuFileNormalscreen.putClientProperty("help", "ui.main.menu.file.leave-fullscreen");
    }

    protected void createMenuHelp() {
        $objectMap.put("menuHelp", menuHelp = new javax.swing.JMenu());
        menuHelp.setName("menuHelp");
        menuHelp.setText(_("jaxxdemo.menu.help"));
        menuHelp.setMnemonic(101);
        menuHelp.putClientProperty("help", "ui.main.menu.help");
    }

    protected void createMenuHelpAbout() {
        $objectMap.put("menuHelpAbout", menuHelpAbout = new javax.swing.JMenuItem());
        menuHelpAbout.setName("menuHelpAbout");
        menuHelpAbout.setText(_("jaxxdemo.action.about"));
        menuHelpAbout.setMnemonic(65);
        menuHelpAbout.setToolTipText(_("jaxxdemo.action.about.tip"));
        menuHelpAbout.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpAbout"));
        menuHelpAbout.putClientProperty("help", "ui.main.menu.help.about");
    }

    protected void createMenuHelpHelp() {
        $objectMap.put("menuHelpHelp", menuHelpHelp = new javax.swing.JMenuItem());
        menuHelpHelp.setName("menuHelpHelp");
        menuHelpHelp.setText(_("jaxxdemo.action.help"));
        menuHelpHelp.setMnemonic(101);
        menuHelpHelp.setToolTipText(_("jaxxdemo.action.help.tip"));
        menuHelpHelp.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpHelp"));
        menuHelpHelp.putClientProperty("help", "ui.main.menu.help.help");
    }

    protected void createMenuHelpSite() {
        $objectMap.put("menuHelpSite", menuHelpSite = new javax.swing.JMenuItem());
        menuHelpSite.setName("menuHelpSite");
        menuHelpSite.setText(_("jaxxdemo.action.site"));
        menuHelpSite.setMnemonic(115);
        menuHelpSite.setToolTipText(_("jaxxdemo.action.site.tip"));
        menuHelpSite.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpSite"));
        menuHelpSite.putClientProperty("help", "ui.main.menu.help.site");
    }

    protected void createNavigation() {
        $objectMap.put("navigation", navigation = new javax.swing.JTree());
        navigation.setName("navigation");
        navigation.setRootVisible(false);
        if (navigation.getFont() != null) {
            navigation.setFont(navigation.getFont().deriveFont((float) 11));
        }
        navigation.setLargeModel(true);
        navigation.setShowsRootHandles(false);
    }

    protected void createNavigationPane() {
        $objectMap.put("navigationPane", navigationPane = new javax.swing.JScrollPane());
        navigationPane.setName("navigationPane");
    }

    protected void createP() {
        $objectMap.put("p", p = new jaxx.runtime.swing.StatusMessagePanel());
        p.setName("p");
    }

    protected void createSplitPane() {
        $objectMap.put("splitPane", splitPane = new javax.swing.JSplitPane());
        splitPane.setName("splitPane");
        splitPane.setContinuousLayout(true);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerSize(6);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToMainFrame();
        addChildrenToMenu();
        addChildrenToMenuFile();
        addChildrenToMenuFileLanguage();
        addChildrenToMenuHelp();
        addChildrenToMainPane();
        addChildrenToSplitPane();
        addChildrenToNavigationPane();
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 18 property setters
        navigation.setModel(getTreeHelper().createTreeModel(DemoUI.this));
        navigation.setSelectionModel(getTreeHelper().createTreeHandler(DemoUI.this));
        setIconImage(jaxx.runtime.SwingUtil.createIcon(getConfig().getOption("application.icon.path")).getImage());
        menuFileConfiguration.setIcon(jaxx.runtime.SwingUtil.createActionIcon("config"));
        menuFileLanguage.setIcon(jaxx.runtime.SwingUtil.createActionIcon("translate"));
        menuFileLanguageFR.setIcon(jaxx.runtime.SwingUtil.createActionIcon("i18n-fr"));
        menuFileLanguageUK.setIcon(jaxx.runtime.SwingUtil.createActionIcon("i18n-uk"));
        menuFileFullscreen.setIcon(jaxx.runtime.SwingUtil.createActionIcon("fullscreen"));
        menuFileNormalscreen.setIcon(jaxx.runtime.SwingUtil.createActionIcon("leave-fullscreen"));
        menuFileExit.setIcon(jaxx.runtime.SwingUtil.createActionIcon("exit"));
        menuHelpHelp.setIcon(jaxx.runtime.SwingUtil.createActionIcon("help"));
        menuHelpSite.setIcon(jaxx.runtime.SwingUtil.createActionIcon("site"));
        menuHelpAbout.setIcon(jaxx.runtime.SwingUtil.createActionIcon("about"));
        navigationPane.setMinimumSize(new Dimension(230,0));
        navigationPane.setBorder(null);
        navigationPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 5 data bindings
        $registerDefaultBindings();
        $objectMap.put("mainFrame", this);
        createContentLayout();
        createMenu();
        createMenuFile();
        createMenuFileConfiguration();
        createMenuFileLanguage();
        createMenuFileLanguageFR();
        createMenuFileLanguageUK();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new javax.swing.JSeparator());
        $JSeparator0.setName("$JSeparator0");
        createMenuFileFullscreen();
        createMenuFileNormalscreen();
        // inline creation of $JSeparator1
        $objectMap.put("$JSeparator1", $JSeparator1 = new javax.swing.JSeparator());
        $JSeparator1.setName("$JSeparator1");
        createMenuFileExit();
        createMenuHelp();
        createMenuHelpHelp();
        createMenuHelpSite();
        createMenuHelpAbout();
        createMainPane();
        createSplitPane();
        createNavigationPane();
        createNavigation();
        createContent();
        createP();
        // inline creation of mainFrame
        setName("mainFrame");
        SwingUtil.setComponentHeight(mainFrame,800);
        SwingUtil.setComponentWidth(mainFrame,1024);
        setTitle(_("JAXX Demo"));
        mainFrame.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__mainFrame"));
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MAIN_FRAME_UNDECORATED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("fullScreen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    setUndecorated(getConfig().isFullScreen());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("fullScreen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_FILE_LANGUAGE_FR_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    menuFileLanguageFR.setEnabled(!acceptLocale(getConfig().getLocale(), "fr_FR"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("locale", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_FILE_LANGUAGE_UK_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    menuFileLanguageUK.setEnabled(!acceptLocale(getConfig().getLocale(), "en_GB"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("locale", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MENU_FILE_FULLSCREEN_VISIBLE, true ,"undecorated") {
        
            @Override
            public void processDataBinding() {
                menuFileFullscreen.setVisible(!isUndecorated());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MENU_FILE_NORMALSCREEN_VISIBLE, true ,"undecorated") {
        
            @Override
            public void processDataBinding() {
                menuFileNormalscreen.setVisible(isUndecorated());
            }
        });
    }

}