/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.parser.impl;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuiton.i18n.plugin.parser.FileParser;
import org.nuiton.i18n.plugin.parser.impl.ParserJavaMojo;

public class ParserJavaActionConfigMojo
extends ParserJavaMojo {
    protected static final Pattern MATCH_PATTERN = Pattern.compile("(name|shortDescription|longDescription|name2|shortDescription2|longDescription2)\\s*=\\s*\"([\\w|\\.]+)\"(|\\s*|\\s*,\\s*$)");

    @Override
    protected String getOutGetter() {
        return "java-action-config.getter";
    }

    @Override
    public FileParser newFileParser() {
        return new ParserJavaMojo.JavaFileParser(this.getLog(), this.encoding, this.oldParser, this.showTouchedFiles){

            @Override
            public void parseLine(File srcFile, String line) {
                String key = this.extract(line);
                if (key != null) {
                    this.setTouched(true);
                    this.registerKey(key);
                }
            }

            String extract(String i18nString) {
                Matcher matcher = MATCH_PATTERN.matcher(i18nString.trim());
                if (matcher.matches()) {
                    return matcher.group(2);
                }
                return null;
            }
        };
    }

    @Override
    protected String getKeyModifierStart() {
        return "[\\w|\\.]+\\s*=\\s*\"";
    }

    @Override
    protected String getKeyModifierEnd() {
        return "\"\\s*(\\)|,|\\+|$)";
    }
}

