/**
 * *##% guix-compiler
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */

package org.nuiton.guix.model;

//~--- JDK imports ------------------------------------------------------------

import java.util.ArrayList;
import java.util.List;

/**
 * Represents a selector of a CSS file
 *
 * @author morin
 */
public class Selector implements java.io.Serializable, Comparable<Selector> {
    public static final int ALWAYS_APPLIES                   = 4;
    public static final int ALWAYS_APPLIES_INHERIT_ONLY      = 3;
    public static final int NEVER_APPLIES                    = 0;
    public static final int PSEUDOCLASS_APPLIES              = 2;
    public static final int PSEUDOCLASS_APPLIES_INHERIT_ONLY = 1;

    /** List of the rules applied to the selector */
    private List<Rule> rules = new ArrayList<Rule>();

    /**
     * Id of the object which rules are applied to
     *  e.g. #label5
     */
    private String id;

    /**
     * Class which rules are applied to
     *  e.g. Label
     */
    private String javaClassName;

    /**
     * Pseudoclass which rules are applied to
     *  e.g. :hover
     */
    private String pseudoClass;

    /**
     * Styleclass which rules are applied to
     *  e.g. .bold
     */
    private String styleClass;

    /**
     * Constructor
     *
     * @param javaClassName class which rules are applied to
     * @param styleClass    styleclass which rules are applied to
     * @param pseudoClass   pseudoclass which rules are applied to
     * @param id            id of the object which rules are applied to
     */
    public Selector(String javaClassName, String styleClass, String pseudoClass, String id) {
        this.javaClassName = javaClassName;
        this.styleClass    = styleClass;
        this.pseudoClass   = pseudoClass;
        this.id            = id;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getJavaClassName() {
        return javaClassName;
    }

    public void setJavaClassName(String javaClassName) {
        this.javaClassName = javaClassName;
    }

    public String getPseudoClass() {
        return pseudoClass;
    }

    public void setPseudoClass(String pseudoClass) {
        this.pseudoClass = pseudoClass;
    }

    public List<Rule> getRules() {
        return rules;
    }

    public void setRules(List<Rule> rules) {
        this.rules = rules;
    }

    public String getStyleClass() {
        return styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    @Override
    public int compareTo(Selector selector) {
        if ((pseudoClass != null) && (selector.pseudoClass == null)) {
            return 1;
        }

        if ((pseudoClass == null) && (selector.pseudoClass != null)) {
            return -1;
        }

        if ((id != null) && (selector.id == null)) {
            return 1;
        }

        if ((id == null) && (selector.id != null)) {
            return -1;
        }

        if ((styleClass != null) && (selector.styleClass == null)) {
            return 1;
        }

        if ((styleClass == null) && (selector.styleClass != null)) {
            return -1;
        }

        if ((javaClassName != null) && (selector.javaClassName == null)) {
            return 1;
        }

        if ((javaClassName == null) && (selector.javaClassName != null)) {
            return -1;
        }

        return 0;
    }

    @Override
    public String toString() {
        return "Selector[" + javaClassName + ", " + styleClass + ", " + pseudoClass + ", " + id + "]";
    }
}


//~ Formatted by Jindent --- http://www.jindent.com
