/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.nuiton.eugene.plugin.EugeneAbstractMojo;
import org.nuiton.plugin.PluginHelper;
import org.nuiton.plugin.PluginIOContext;
import org.nuiton.util.FasterCachedResourceResolver;
import org.nuiton.util.FileUtil;
import org.nuiton.util.Resource;
import org.nuiton.util.ResourceResolver;
import org.nuiton.util.StringUtil;

public abstract class Xmi2Model
extends EugeneAbstractMojo {
    protected PluginIOContext xmiResources;
    protected String fullPackagePath;
    protected String extractedPackages;
    protected String acceptedXmiTypes;
    protected String resolver;
    protected File extraClassPathDirectory;

    protected abstract String getExtension();

    protected abstract String getStyleSheet(File var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAction() throws MojoExecutionException, MojoFailureException {
        long t0 = System.nanoTime();
        try {
            this.getLog().info((CharSequence)"Processing XSL tranformation");
            this.getLog().info((CharSequence)(" with fullPackagePath   : " + this.fullPackagePath));
            this.getLog().info((CharSequence)(" with extractedPackages : " + this.extractedPackages));
            this.getLog().info((CharSequence)(" with acceptedXmiTypes  : " + this.acceptedXmiTypes));
            this.getLog().info((CharSequence)(" with resolver          : " + this.resolver));
            TransformerFactory factory = TransformerFactory.newInstance();
            ClassLoader fixedClassLoader = this.fixClassLoader();
            String[] includes = this.getSuffixPattern("*");
            String[] acceptedTypesAsArray = this.getAcceptedTypesAsArray();
            for (File dir : this.xmiResources.getInputs()) {
                List files = PluginHelper.getIncludedFiles((File)dir, (String[])includes, null);
                this.actionXsl(dir, files, factory, fixedClassLoader, acceptedTypesAsArray);
            }
        }
        finally {
            this.getLog().info((CharSequence)("xsl done in " + StringUtil.convertTime((long)(System.nanoTime() - t0))));
        }
        this.getLog().info((CharSequence)"Copy resources files");
        try {
            String[] excludes = this.getSuffixPattern("**/*");
            PluginHelper.copyFiles((PluginIOContext)this.xmiResources, null, (String[])excludes, (boolean)this.overwrite);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("could not copy some files for reason " + ex.getMessage(), (Exception)ex);
        }
    }

    @Override
    protected PluginIOContext getResources() {
        return this.xmiResources;
    }

    @Override
    protected PluginIOContext initResources() {
        File defaultIn = this.getFileFromBasedir(new String[]{"target", "generated-sources", "xmi"});
        File defaultOut = this.getFileFromBasedir(new String[]{"target", "generated-sources", "models"});
        File defaultTestIn = this.getFileFromBasedir(new String[]{"target", "generated-sources", "test-xmi"});
        File defaultTestOut = this.getFileFromBasedir(new String[]{"target", "generated-sources", "test-models"});
        this.xmiResources = this.initResources(defaultIn, defaultOut, defaultTestIn, defaultTestOut);
        return this.xmiResources;
    }

    protected String[] getSuffixPattern(String prefix) {
        String[] acceptedSuffixes = this.getAcceptedTypesAsArray();
        int max = acceptedSuffixes.length;
        String[] patterns = new String[max];
        for (int i = 0; i < max; ++i) {
            patterns[i] = prefix + acceptedSuffixes[i];
        }
        return patterns;
    }

    protected void actionXsl(File dir, List<File> files, TransformerFactory factory, ClassLoader fixedClassLoader, String[] acceptedSuffixes) throws MojoExecutionException {
        for (File file : files) {
            try {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("treate file : " + file));
                }
                URIResolver fileResolver = this.getUriResolver(file, fixedClassLoader);
                String styleSheet = this.getStyleSheet(file);
                URL xsl = Resource.getURL((String)styleSheet);
                String filename = FileUtil.basename((File)file, (String[])acceptedSuffixes).concat(".").concat(this.getExtension());
                String relatifPath = file.getParentFile().getAbsolutePath().substring(dir.getAbsolutePath().length());
                File dstDir = this.xmiResources.getOutput();
                if (!relatifPath.isEmpty()) {
                    dstDir = new File(dstDir, relatifPath);
                    dstDir.mkdirs();
                }
                File result = new File(dstDir, filename);
                if (!this.overwrite && file.lastModified() < result.lastModified()) {
                    this.getLog().info((CharSequence)("file up-to-date : " + result));
                    continue;
                }
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("generate " + result));
                }
                Transformer transformer = factory.newTransformer(new StreamSource(xsl.openStream()));
                transformer.setParameter("fullPackagePath", this.fullPackagePath);
                transformer.setParameter("extraPackages", this.extractedPackages);
                transformer.setURIResolver(fileResolver);
                transformer.transform(new StreamSource(file), new StreamResult(new FileOutputStream(result)));
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
    }

    protected String[] getAcceptedTypesAsArray() {
        String[] splittedTypes = this.acceptedXmiTypes.split(",");
        String[] result = new String[splittedTypes.length];
        for (int i = 0; i < splittedTypes.length; ++i) {
            String type = splittedTypes[i];
            if (!type.startsWith(".")) {
                type = "." + type;
            }
            result[i] = type;
        }
        return result;
    }

    protected URIResolver getUriResolver(File model, ClassLoader cl) {
        URIResolver result = null;
        try {
            Class<?> clazz = Class.forName(this.resolver, true, cl);
            try {
                Constructor<?> withBaseConstructor = clazz.getConstructor(String.class);
                String base = model.getParentFile().getAbsolutePath();
                result = (URIResolver)withBaseConstructor.newInstance(base);
            }
            catch (Exception eee) {
                this.getLog().warn((CharSequence)"Unable to instantiate resolver with String parameter", (Throwable)eee);
            }
            if (result == null) {
                result = (URIResolver)clazz.newInstance();
            }
            if (result instanceof ResourceResolver) {
                ((ResourceResolver)result).setVerbose(this.verbose);
                ((ResourceResolver)result).setCl(cl);
                if (result instanceof FasterCachedResourceResolver) {
                    boolean offline = this.settings.isOffline();
                    this.getLog().debug((CharSequence)("using offline mode  ? : " + offline));
                    ((FasterCachedResourceResolver)result).setOffline(offline);
                }
            }
        }
        catch (Exception eee) {
            this.getLog().warn((CharSequence)"Unable to instantiate resolver using the default constructor", (Throwable)eee);
        }
        return result;
    }

    protected ClassLoader fixClassLoader() throws MojoExecutionException {
        HashSet urlsAsString = new HashSet();
        ArrayList urls = new ArrayList();
        try {
            if (this.extraClassPathDirectory != null) {
                if (this.verbose) {
                    this.getLog().info((CharSequence)("Add extra directory in generator's classLoader : " + this.extraClassPathDirectory));
                }
                this.addDirectoryToUrlsList(this.extraClassPathDirectory, urls, urlsAsString);
            }
            if (this.project.getProjectReferences() != null) {
                Iterator i$ = this.project.getProjectReferences().entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry o;
                    Map.Entry entry = o = i$.next();
                    MavenProject relatedProject = (MavenProject)entry.getValue();
                    if (this.verbose) {
                        this.getLog().info((CharSequence)("Add project reference in generator's classLoader : '" + relatedProject.getArtifact() + "'"));
                    }
                    this.addDirectoryToUrlsList(relatedProject.getArtifact().getFile(), urls, urlsAsString);
                }
            }
            if (!this.project.getArtifacts().isEmpty()) {
                if (this.verbose) {
                    this.getLog().info((CharSequence)"Use resolved artifacts to build class-path");
                }
                for (Map.Entry o : this.project.getArtifacts()) {
                    Artifact a = (Artifact)o;
                    if (a.getScope().equals("provided")) continue;
                    this.addDirectoryToUrlsList(a.getFile(), urls, urlsAsString);
                }
            }
            ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().info((CharSequence)("original classloader " + loader));
            }
            if (loader instanceof URLClassLoader) {
                for (URL u : ((URLClassLoader)loader).getURLs()) {
                    this.addUrlToUrlsList(u, urls, urlsAsString);
                    if (!this.getLog().isDebugEnabled()) continue;
                    this.getLog().debug((CharSequence)("original cp entry: " + u));
                }
                if (loader.getParent() != null) {
                    loader = loader.getParent();
                }
            }
            if (!urls.isEmpty()) {
                loader = new URLClassLoader(urls.toArray(new URL[urls.size()]), loader);
            }
            if (this.getLog().isDebugEnabled()) {
                for (URL u : urls) {
                    this.getLog().debug((CharSequence)("cp entry: " + u));
                }
            }
            ClassLoader classLoader = loader;
            return classLoader;
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        finally {
            urls.clear();
            urlsAsString.clear();
        }
    }
}

